package io.iohk.atala.prism.api.node

import com.ionspin.kotlin.bignum.integer.BigInteger
import io.iohk.atala.prism.api.common.AuthDetails
import io.iohk.atala.prism.common.PrismSdkInternal
import io.iohk.atala.prism.protos.SignedAtalaOperation
import java.util.concurrent.CompletableFuture

public interface NodeExplorerApiAsync {

    @OptIn(PrismSdkInternal::class)
    public fun getScheduledOperations(operationsKind: AtalaOperationType? = null, authDetails: AuthDetails):
        CompletableFuture<List<SignedAtalaOperation>>

    public fun getWalletTransactions(
        transactionStatus: WalletTransactionStatus? = null,
        lastSeenTransactionId: String? = null,
        limit: Int = 50,
        authDetails: AuthDetails
    ): CompletableFuture<List<TransactionState>>

    public fun getWalletBalance(authDetails: AuthDetails): CompletableFuture<BigInteger>
}
