package io.iohk.atala.prism.api.node

import io.iohk.atala.prism.api.PrismPayload
import io.iohk.atala.prism.api.models.AtalaOperationId
import io.iohk.atala.prism.crypto.MerkleRoot
import io.iohk.atala.prism.crypto.Sha256Digest
import io.iohk.atala.prism.identity.CanonicalPrismDid
import io.iohk.atala.prism.identity.LongFormPrismDid
import io.iohk.atala.prism.identity.PrismKeyInformation
import io.iohk.atala.prism.protos.GrpcOptions
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.future.future
import java.util.concurrent.CompletableFuture

public class NodeAuthApiAsyncImpl(options: GrpcOptions) : NodeAuthApiAsync, NodePublicApiAsyncImpl(options) {
    private val nodeAuthApi = NodeAuthApiImpl(options)

    override fun createDid(
        payload: PrismPayload,
        did: LongFormPrismDid?,
        masterKeyId: String?
    ): CompletableFuture<AtalaOperationId> =
        GlobalScope.future { nodeAuthApi.createDid(payload, did, masterKeyId) }

    override fun updateDid(
        payload: PrismPayload,
        did: CanonicalPrismDid?,
        masterKeyId: String?,
        previousOperationHash: Sha256Digest?,
        keysToAdd: Array<PrismKeyInformation>?,
        keysToRevoke: Array<String>?
    ): CompletableFuture<AtalaOperationId> =
        GlobalScope.future {
            nodeAuthApi.updateDid(
                payload,
                did,
                masterKeyId,
                previousOperationHash,
                keysToAdd,
                keysToRevoke
            )
        }

    override fun issueCredentials(
        payload: PrismPayload,
        did: CanonicalPrismDid?,
        issuingKeyId: String?,
        merkleRoot: MerkleRoot?
    ): CompletableFuture<AtalaOperationId> =
        GlobalScope.future { nodeAuthApi.issueCredentials(payload, did, issuingKeyId, merkleRoot) }

    override fun revokeCredentials(
        payload: PrismPayload,
        did: CanonicalPrismDid?,
        revocationKeyId: String?,
        previousOperationHash: Sha256Digest?,
        batchId: String?,
        credentialsToRevoke: Array<Sha256Digest>?
    ): CompletableFuture<AtalaOperationId> =
        GlobalScope.future {
            nodeAuthApi.revokeCredentials(
                payload,
                did,
                revocationKeyId,
                previousOperationHash,
                batchId,
                credentialsToRevoke
            )
        }

    override fun deactivateDID(
        payload: PrismPayload,
        did: CanonicalPrismDid?,
        masterKeyId: String?,
        previousOperationHash: Sha256Digest?
    ): CompletableFuture<AtalaOperationId> =
        GlobalScope.future {
            nodeAuthApi.deactivateDID(
                payload,
                did,
                masterKeyId,
                previousOperationHash
            )
        }
}
