package io.iohk.atala.prism.api.node

import io.iohk.atala.prism.api.PrismPayload
import io.iohk.atala.prism.api.models.AtalaOperationId
import io.iohk.atala.prism.crypto.MerkleRoot
import io.iohk.atala.prism.crypto.Sha256Digest
import io.iohk.atala.prism.identity.CanonicalPrismDid
import io.iohk.atala.prism.identity.LongFormPrismDid
import io.iohk.atala.prism.identity.PrismKeyInformation
import java.util.concurrent.CompletableFuture

public interface NodeAuthApiAsync : NodePublicApiAsync {
    public fun createDid(
        payload: PrismPayload,
        did: LongFormPrismDid? = null,
        masterKeyId: String? = null
    ): CompletableFuture<AtalaOperationId>

    public fun updateDid(
        payload: PrismPayload,
        did: CanonicalPrismDid? = null,
        masterKeyId: String? = null,
        previousOperationHash: Sha256Digest? = null,
        keysToAdd: Array<PrismKeyInformation>? = null,
        keysToRevoke: Array<String>? = null
    ): CompletableFuture<AtalaOperationId>

    public fun issueCredentials(
        payload: PrismPayload,
        did: CanonicalPrismDid? = null,
        issuingKeyId: String? = null,
        merkleRoot: MerkleRoot? = null
    ): CompletableFuture<AtalaOperationId>

    public fun revokeCredentials(
        payload: PrismPayload,
        did: CanonicalPrismDid? = null,
        revocationKeyId: String? = null,
        previousOperationHash: Sha256Digest? = null,
        batchId: String? = null,
        credentialsToRevoke: Array<Sha256Digest>? = null
    ): CompletableFuture<AtalaOperationId>

    public fun deactivateDID(
        payload: PrismPayload,
        did: CanonicalPrismDid? = null,
        masterKeyId: String? = null,
        previousOperationHash: Sha256Digest? = null
    ): CompletableFuture<AtalaOperationId>
}
