package io.iohk.atala.prism.api.connector

import io.iohk.atala.prism.api.PrismPayload
import io.iohk.atala.prism.api.models.AtalaOperationId
import io.iohk.atala.prism.identity.LongFormPrismDid
import io.iohk.atala.prism.identity.PrismDid
import io.iohk.atala.prism.protos.GrpcOptions
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.future.future
import java.util.concurrent.CompletableFuture

/**
 * @suppress
 */
public open class ConnectorPublicApiAsyncImpl(options: GrpcOptions) : ConnectorPublicApiAsync {
    private val connectorPublicApi = ConnectorPublicApiImpl(options)

    override fun healthCheck(): CompletableFuture<Unit> =
        GlobalScope.future { connectorPublicApi.healthCheck() }

    override fun registerExistingDid(did: PrismDid, name: String, role: Role): CompletableFuture<AtalaOperationId> =
        GlobalScope.future { connectorPublicApi.registerExistingDid(did, name, role) }

    override fun registerNewDid(
        payload: PrismPayload,
        did: LongFormPrismDid?,
        masterKeyId: String?,
        name: String,
        role: Role
    ): CompletableFuture<AtalaOperationId> =
        GlobalScope.future { connectorPublicApi.registerNewDid(payload, did, name, name, role) }

    override fun getConnectionTokenInfo(token: String): CompletableFuture<ConnectorTokenInfo> =
        GlobalScope.future { connectorPublicApi.getConnectionTokenInfo(token) }
}
