package io.iohk.atala.prism.api.connector

import io.iohk.atala.prism.api.PrismPayload
import io.iohk.atala.prism.api.models.AtalaOperationId
import io.iohk.atala.prism.identity.LongFormPrismDid
import io.iohk.atala.prism.identity.PrismDid
import java.util.concurrent.CompletableFuture

/**
 * @suppress
 */
public interface ConnectorPublicApiAsync {
    public fun healthCheck(): CompletableFuture<Unit>
    public fun registerExistingDid(did: PrismDid, name: String, role: Role): CompletableFuture<AtalaOperationId>
    public fun registerNewDid(
        payload: PrismPayload,
        did: LongFormPrismDid?,
        masterKeyId: String?,
        name: String,
        role: Role
    ): CompletableFuture<AtalaOperationId>
    public fun getConnectionTokenInfo(token: String): CompletableFuture<ConnectorTokenInfo>
}
