package io.iohk.atala.prism.api.connector

import io.iohk.atala.prism.api.common.AuthDetails
import io.iohk.atala.prism.crypto.keys.ECPublicKey
import io.iohk.atala.prism.protos.GrpcOptions
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.future.future
import java.util.concurrent.CompletableFuture

/**
 * @suppress
 */
public open class ConnectorAuthApiAsyncImpl(options: GrpcOptions) : ConnectorAuthApiAsync {
    private val connectorAuthApi = ConnectorAuthApiImpl(options)

    override fun generateConnectionToken(count: Int, authDetails: AuthDetails): CompletableFuture<List<String>> =
        GlobalScope.future { connectorAuthApi.generateConnectionToken(count, authDetails) }

    override fun addConnectionFromToken(
        token: String,
        publicKey: ECPublicKey,
        authDetails: AuthDetails
    ): CompletableFuture<ConnectorConnectionInfo> =
        GlobalScope.future { connectorAuthApi.addConnectionFromToken(token, publicKey, authDetails) }

    override fun getConnectionByToken(
        token: String,
        authDetails: AuthDetails
    ): CompletableFuture<ConnectorConnectionReference?> =
        GlobalScope.future { connectorAuthApi.getConnectionByToken(token, authDetails) }
}
