package io.iohk.atala.prism.api.connector

import io.iohk.atala.prism.api.common.AuthDetails
import io.iohk.atala.prism.crypto.keys.ECPublicKey
import java.util.concurrent.CompletableFuture

/**
 * @suppress
 */
public interface ConnectorAuthApiAsync {
    public fun generateConnectionToken(count: Int, authDetails: AuthDetails): CompletableFuture<List<String>>
    public fun addConnectionFromToken(
        token: String,
        publicKey: ECPublicKey,
        authDetails: AuthDetails
    ): CompletableFuture<ConnectorConnectionInfo>
    public fun getConnectionByToken(
        token: String,
        authDetails: AuthDetails
    ): CompletableFuture<ConnectorConnectionReference?>
}
