package io.iohk.atala.prism.api

import io.iohk.atala.prism.credentials.PrismCredential
import io.iohk.atala.prism.crypto.MerkleInclusionProof
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.future.future
import java.util.concurrent.CompletableFuture

public class CredentialVerificationServiceAsync(private val credentialVerificationService: CredentialVerificationService) {
    public fun verify(
        signedCredential: PrismCredential,
        merkleInclusionProof: MerkleInclusionProof
    ): CompletableFuture<VerificationResult> =
        GlobalScope.future { credentialVerificationService.verify(signedCredential, merkleInclusionProof) }
}
