package io.iohk.atala.prism.api.models

public data class ProtocolVersion(val majorVersion: Int, val minorVersion: Int) {
    override fun toString(): String {
        return "$majorVersion.$minorVersion"
    }

    public companion object {
        public fun fromProto(protocolVersion: io.iohk.atala.prism.protos.ProtocolVersion): ProtocolVersion =
            ProtocolVersion(
                majorVersion = protocolVersion.majorVersion,
                minorVersion = protocolVersion.minorVersion
            )
    }
}
