package io.iohk.atala.prism.api.models

import com.benasher44.uuid.uuid4
import io.iohk.atala.prism.crypto.Sha256
import io.iohk.atala.prism.crypto.Sha256Digest
import io.iohk.atala.prism.crypto.util.BytesOps
import io.iohk.atala.prism.protos.SignedAtalaOperation
import pbandk.encodeToByteArray
import kotlin.js.JsExport

/**
 * This class represents an identifier of an operation submitted to PRISM Node.
 */
@JsExport
public data class AtalaOperationId(val digest: Sha256Digest) {
    public fun value(): ByteArray = digest.value

    public fun hexValue(): String = BytesOps.bytesToHex(value())

    public companion object {
        public fun of(atalaOperation: SignedAtalaOperation): AtalaOperationId {
            val hash = Sha256.compute(atalaOperation.encodeToByteArray())
            return AtalaOperationId(hash)
        }

        public fun random(): AtalaOperationId {
            val hash = Sha256.compute(uuid4().toString().encodeToByteArray())
            return AtalaOperationId(hash)
        }

        public fun fromHex(hex: String): AtalaOperationId {
            val hash = Sha256Digest.fromHex(hex)
            return AtalaOperationId(hash)
        }

        public fun fromBytes(bytes: ByteArray): AtalaOperationId {
            val hash = Sha256Digest.fromBytes(bytes)
            return AtalaOperationId(hash)
        }
    }
}
