package io.iohk.atala.prism.api.connector

import io.iohk.atala.prism.identity.PrismDid
import pbandk.wkt.Timestamp
import kotlin.js.JsExport

/**
 * @suppress
 */
@JsExport
public sealed class Role {
    public object ISSUER : Role()
    public object VERIFIER : Role()
    public class UNRECOGNIZED(public val value: Int) : Role()
}

/**
 * @suppress
 */
public data class ConnectorParticipantInfo(
    val name: String,
    val did: PrismDid,
    val logo: ByteArray
)

/**
 * @suppress
 */
public data class ConnectorTokenInfo(
    val creatorInfo: ConnectorParticipantInfo
)

/**
 * @suppress
 */
public data class ConnectorConnectionReference(
    val id: String,
    val token: String,
)

/**
 * @suppress
 */
public data class SentMessageReference(
    val id: String = "",
)

/**
 * @suppress
 */
public data class ConnectorConnectionInfo(
    val connectionReference: ConnectorConnectionReference,
    val created: Timestamp?,
    val participantInfo: ConnectorParticipantInfo
)
