package io.iohk.atala.prism.api.connector

import io.iohk.atala.prism.api.PrismPayload
import io.iohk.atala.prism.api.models.AtalaOperationId
import io.iohk.atala.prism.identity.LongFormPrismDid
import io.iohk.atala.prism.identity.PrismDid

/**
 * @suppress
 */
public interface ConnectorPublicApi {
    public suspend fun healthCheck()
    public suspend fun registerExistingDid(did: PrismDid, name: String, role: Role): AtalaOperationId
    public suspend fun registerNewDid(
        payload: PrismPayload,
        did: LongFormPrismDid?,
        masterKeyId: String?,
        name: String,
        role: Role
    ): AtalaOperationId

    public suspend fun getConnectionTokenInfo(token: String): ConnectorTokenInfo
}
