package io.iohk.atala.prism.api.connector

import io.iohk.atala.prism.api.common.AuthDetails
import io.iohk.atala.prism.crypto.keys.ECPublicKey
import io.iohk.atala.prism.protos.AtalaMessage

/**
 * @suppress
 */
public interface ConnectorAuthApi {
    public suspend fun generateConnectionToken(
        count: Int,
        authDetails: AuthDetails
    ): List<String>

    public suspend fun addConnectionFromToken(
        token: String,
        publicKey: ECPublicKey,
        authDetails: AuthDetails
    ): ConnectorConnectionInfo

    public suspend fun getConnectionByToken(
        token: String,
        authDetails: AuthDetails
    ): ConnectorConnectionReference?

    public suspend fun sendMessage(
        connectionId: String,
        message: AtalaMessage,
        id: String,
        authDetails: AuthDetails
    ): SentMessageReference
}
