package io.iohk.atala.prism.api.common

import com.benasher44.uuid.bytes
import com.benasher44.uuid.uuid4
import io.iohk.atala.prism.common.PrismSdkInternal
import io.iohk.atala.prism.crypto.EC
import io.iohk.atala.prism.crypto.keys.ECPrivateKey
import io.iohk.atala.prism.identity.LongFormPrismDid
import io.iohk.atala.prism.protos.PrismMetadata
import pbandk.Message
import pbandk.encodeToByteArray
import kotlin.js.JsExport

@JsExport
public data class AuthDetails(
    val did: LongFormPrismDid,
    val masterKeyId: String,
    val privateKey: ECPrivateKey
)

@PrismSdkInternal
public suspend fun <Request : Message, Response> authenticatedApiCall(
    request: Request,
    authDetails: AuthDetails,
    isCanonical: Boolean = true,
    apiCall: suspend (Request, PrismMetadata) -> Response
): Response {
    val nonce = uuid4().bytes
    return apiCall(
        request,
        PrismMetadata(
            if (isCanonical) authDetails.did.asCanonical().value
            else authDetails.did.value,
            authDetails.masterKeyId,
            EC.signBytes(nonce + request.encodeToByteArray(), authDetails.privateKey).getEncoded(),
            nonce
        )
    )
}
