package io.iohk.atala.prism.api

import com.benasher44.uuid.bytes
import com.benasher44.uuid.uuid4
import io.iohk.atala.prism.common.PrismSdkInternal
import io.iohk.atala.prism.crypto.EC
import io.iohk.atala.prism.crypto.keys.ECPrivateKey
import io.iohk.atala.prism.identity.PrismDid
import io.iohk.atala.prism.protos.PrismMetadata
import pbandk.encodeToByteArray
import kotlin.js.JsExport

@JsExport
@PrismSdkInternal
public object RequestUtils {
    public fun generateRequestMetadata(
        did: String,
        didPrivateKey: ECPrivateKey,
        request: pbandk.Message,
        nonce: ByteArray? = null
    ): PrismMetadata =
        generateBytesMetadata(did, didPrivateKey, request.encodeToByteArray(), nonce)

    public fun generateBytesMetadata(
        did: String,
        didPrivateKey: ECPrivateKey,
        bytes: ByteArray,
        nonce: ByteArray? = null
    ): PrismMetadata {
        val requestNonce = nonce ?: uuid4().bytes
        val didSignature = EC.signBytes(
            requestNonce + bytes,
            didPrivateKey
        )
        return PrismMetadata(
            did = did,
            didKeyId = PrismDid.DEFAULT_MASTER_KEY_ID, // NOTE: For now this is hardcoded as there are no other keys in the DIDs
            didSignature = didSignature.getEncoded(),
            requestNonce = requestNonce
        )
    }
}
