/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.spring.config;

import io.inversion.Engine;
import io.inversion.EngineServlet;
import io.inversion.utils.Path;
import java.util.ArrayList;
import javax.servlet.Servlet;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class InversionServletConfig {
    public InversionServletConfig() {
        System.out.println("InversionServletConfig()<>");
    }

    public static ServletRegistrationBean createDefaultInversionServlet(Engine engine) {
        EngineServlet servlet = new EngineServlet();
        servlet.setEngine(engine);
        String servletMapping = InversionServletConfig.buildServletMapping(engine);
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)servlet, new String[]{servletMapping});
        bean.setLoadOnStartup(1);
        return bean;
    }

    public static String buildServletMapping(Engine engine) {
        ArrayList<String> parts = new ArrayList<String>();
        boolean done = false;
        for (int i = 0; i < 100 && !done; ++i) {
            String part = null;
            for (Path path : engine.getAllIncludePaths()) {
                if (part == null) {
                    part = path.get(i);
                }
                if (part != null && path.isStatic(i) && part.equals(path.get(i))) continue;
                done = true;
                break;
            }
            if (part == null) break;
            if (done) continue;
            parts.add(part);
        }
        return (parts.size() > 0 ? "/" + new Path(parts) : "") + "/*";
    }

    public static ConfigurableServletWebServerFactory createDefaultServletContainer() {
        TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory();
        tomcat.addContextCustomizers(new TomcatContextCustomizer[]{context -> context.setAllowCasualMultipartParsing(true)});
        tomcat.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
            AbstractHttp11Protocol httpProtocol = (AbstractHttp11Protocol)connector.getProtocolHandler();
            httpProtocol.setCompressibleMimeType("text/html,text/xml,text/plain,text/css,text/javascript,application/javascript,application/json");
            httpProtocol.setCompression("1024");
        }});
        return tomcat;
    }

    @Bean
    public ServletRegistrationBean inversionServlet(@Autowired Engine engine) {
        return InversionServletConfig.createDefaultInversionServlet(engine);
    }

    @Bean
    public ConfigurableServletWebServerFactory servletContainer() {
        return InversionServletConfig.createDefaultServletContainer();
    }
}

