/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.spring.config;

import io.inversion.Api;
import io.inversion.Engine;
import io.inversion.utils.Config;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.StreamSupport;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.type.AnnotationMetadata;

public class InversionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
BeanFactoryAware {
    Environment environment = null;
    BeanFactory beanFactory = null;
    public static Api[] apis = null;

    public InversionRegistrar() {
        System.out.println("InversionRegistrar()<>");
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (apis != null && apis.length > 0) {
            ConfigurableBeanFactory config = (ConfigurableBeanFactory)beanFactory;
            for (Api api : apis) {
                String name = api.getName();
                config.registerSingleton(name, (Object)api);
            }
        }
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        GenericBeanDefinition bean = new GenericBeanDefinition();
        bean.setBeanClass(Engine.class);
        bean.setAutowireMode(3);
        bean.setDestroyMethodName("shutdown");
        registry.registerBeanDefinition("engine", (BeanDefinition)bean);
    }

    public void setEnvironment(Environment environment) {
        Configuration subConfig;
        int i;
        this.environment = environment;
        PropertiesConfiguration springConfig = new PropertiesConfiguration();
        MutablePropertySources sources = ((AbstractEnvironment)environment).getPropertySources();
        StreamSupport.stream(sources.spliterator(), false).filter(ps -> ps instanceof EnumerablePropertySource).map(ps -> ((EnumerablePropertySource)ps).getPropertyNames()).flatMap(Arrays::stream).distinct().filter(prop -> !prop.contains("credentials") && !prop.contains("password")).forEach(prop -> springConfig.setProperty(prop, (Object)environment.getProperty(prop)));
        CompositeConfiguration inversionConfig = Config.getConfiguration();
        ArrayList<Configuration> toAddBack = new ArrayList<Configuration>();
        for (i = 0; i < inversionConfig.getNumberOfConfigurations(); ++i) {
            subConfig = inversionConfig.getConfiguration(i);
            String source = subConfig.getProperty("source") + "";
            if (source.equals("null") || !(source = Utils.substringAfter((String)source, (String)"/")).startsWith("inversion") || !source.endsWith(".properties")) continue;
            --i;
            inversionConfig.removeConfiguration(subConfig);
            toAddBack.add(subConfig);
        }
        inversionConfig.addConfigurationFirst((Configuration)springConfig);
        for (i = toAddBack.size() - 1; i >= 0; --i) {
            subConfig = (Configuration)toAddBack.get(i);
            inversionConfig.addConfigurationFirst(subConfig);
        }
    }
}

