/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.spring.main;

import io.inversion.Api;
import io.inversion.spring.config.EnableInversion;
import io.inversion.spring.config.InversionRegistrar;
import io.inversion.utils.Utils;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.ApplicationContext;

@SpringBootApplication(exclude={DataSourceAutoConfiguration.class})
@EnableInversion
public class InversionMain {
    protected static ApplicationContext context = null;

    public static void main(String[] args) {
        InversionMain.run(args, null);
    }

    public static ApplicationContext run(Api ... apis) {
        return InversionMain.run(new String[0], apis);
    }

    public static ApplicationContext run(String[] args, Api[] apis) {
        try {
            if (context != null) {
                InversionMain.exit();
            }
            InversionRegistrar.apis = apis;
            context = SpringApplication.run(InversionMain.class, (String[])args);
        }
        catch (Throwable e) {
            e = Utils.getCause((Throwable)e);
            if (Utils.getStackTraceString((Throwable)e).contains("A child container failed during start")) {
                String msg = " README FOR HELP!!!!!!!";
                msg = msg + "\n";
                msg = msg + "\n It looks like you are getting a frustrating Tomcat startup error.";
                msg = msg + "\n";
                msg = msg + "\n This error may be casused if URL.setURLStreamHandlerFactory()";
                msg = msg + "\n is somehow called before Spring Boot starts Tomcat. ";
                msg = msg + "\n";
                msg = msg + "\n This seems to be a frustrating undocumented \"no no\" of Tomcat with ";
                msg = msg + "\n Spring Boot. Using H2 db before Spring Boot starts Tomcat seems to ";
                msg = msg + "\n be one known cause of this error.";
                msg = msg + "\n";
                msg = msg + "\n SOLUTION: Override Engine.startup0() and place all of your Api wiring";
                msg = msg + "\n and other setup code there.  That way Tomcat will load before ";
                msg = msg + "\n the part of your code that is causing this unintended side effect.";
                msg = msg + "\n\n\n";
                System.err.println(msg);
                throw new RuntimeException(msg, e);
            }
            e.printStackTrace();
            Utils.rethrow((Throwable)e);
        }
        return context;
    }

    public static void exit() {
        if (context != null) {
            SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        }
        context = null;
    }

    public ApplicationContext getContext() {
        return context;
    }
}

