/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.script;

import io.inversion.Action;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.script.velocity.LayoutDirective;
import io.inversion.script.velocity.SaveDirective;
import io.inversion.script.velocity.SwitchDirective;
import io.inversion.script.velocity.VelocityResourceLoader;
import io.inversion.utils.JSArray;
import io.inversion.utils.JSNode;
import io.inversion.utils.Path;
import io.inversion.utils.Utils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.jodah.expiringmap.ExpiringMap;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.implement.IncludeRelativePath;
import org.apache.velocity.context.Context;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptAction
extends Action<ScriptAction> {
    static final ThreadLocal<ScriptAction> scriptLocal = new ThreadLocal();
    static final ThreadLocal<Chain> chainLocal = new ThreadLocal();
    protected final Logger log = LoggerFactory.getLogger(ScriptAction.class);
    final Map<String, String> scriptTypes = new LinkedHashMap<String, String>();
    String scriptsCollection = "scripts";
    long cacheExpireSeconds = 1800L;
    Map<String, JSNode> CACHE;
    boolean inited = false;
    String scriptsDir = "/WEB-INF/scripts";
    VelocityEngine velocity = null;

    public ScriptAction() {
        this.scriptTypes.put("js", "javascript");
        this.scriptTypes.put("vm", "velocity");
    }

    public static JSNode findScript(String path) {
        String ext;
        if (path == null) {
            return null;
        }
        ScriptAction handler = scriptLocal.get();
        Chain chain = chainLocal.get();
        String string = ext = path.indexOf(".") > 0 ? path.substring(path.lastIndexOf(".") + 1).toLowerCase() : null;
        if (ext != null && !handler.scriptTypes.containsKey(ext)) {
            return null;
        }
        String scriptsDir = chain.getConfig("scriptsDir", handler.scriptsDir);
        String scriptsCollection = chain.getConfig("scriptsCollection", handler.scriptsCollection);
        ArrayList<String> paths = new ArrayList<String>();
        if (ext != null) {
            paths.add(path);
        } else {
            for (String string2 : handler.scriptTypes.keySet()) {
                paths.add(path + "." + string2);
            }
        }
        JSNode script = null;
        for (String p : paths) {
            ext = handler.ext(p);
            URL url = chain.getEngine().getResource(Utils.implode((String)"/", (Object[])new Object[]{scriptsDir, p}));
            if (url == null) continue;
            try {
                script = new JSNode(new Object[]{"type", handler.scriptTypes.get(ext), "script", Utils.read((InputStream)url.openStream())});
            }
            catch (IOException iOException) {}
            break;
        }
        if (script == null && !Utils.empty((Object[])new Object[]{scriptsCollection})) {
            JSArray dataArr;
            String string3 = chain.getRequest().getApiUrl() + scriptsCollection + "?name=" + path;
            Response r = chain.getEngine().get(string3);
            if (r.getStatusCode() == 200 && !(dataArr = r.getJson().getArray("data")).isEmpty()) {
                script = dataArr.getNode(0);
            }
        }
        handler.CACHE.put(path, script);
        return script;
    }

    synchronized void init() {
        if (!this.inited) {
            this.inited = true;
            if (this.cacheExpireSeconds > 0L) {
                this.CACHE = ExpiringMap.builder().maxSize(500).expiration(this.cacheExpireSeconds, TimeUnit.SECONDS).build();
            }
            this.velocity = new VelocityEngine();
            this.velocity.setProperty("resource.loader", (Object)"inversion");
            this.velocity.setProperty("inversion.resource.loader.class", (Object)VelocityResourceLoader.class.getName());
            this.velocity.setProperty("userdirective", (Object)(SwitchDirective.class.getName() + ", " + SaveDirective.class.getName() + ", " + LayoutDirective.class.getName()));
            this.velocity.init();
            try {
                Enumeration<URL> en = ScriptAction.class.getClassLoader().getResources("META-INF/truffle/language");
                while (en.hasMoreElements()) {
                    URL u = en.nextElement();
                    URLConnection connection = u.openConnection();
                    URI uri = ((JarURLConnection)connection).getJarFileURL().toURI();
                    try {
                        Paths.get(uri);
                    }
                    catch (FileSystemNotFoundException fsnfe) {
                        this.log.info("Init : Attempting to create file system for " + uri);
                        HashMap<String, String> env = new HashMap<String, String>();
                        env.put("create", "true");
                        FileSystems.newFileSystem(uri, env);
                    }
                }
            }
            catch (Exception e) {
                this.log.error("Error initializing the javascript language file system", (Throwable)e);
            }
        }
    }

    public void run(Request req, Response res) throws ApiException {
        LinkedHashMap<String, JSNode> scripts;
        scriptLocal.set(this);
        chainLocal.set(req.getChain());
        if (!this.inited) {
            this.init();
        }
        if ((scripts = this.findScripts(req)).size() > 0) {
            this.runScripts(req, res, scripts);
        }
    }

    void runScripts(Request req, Response res, LinkedHashMap<String, JSNode> scripts) throws ApiException {
        block19: {
            HashMap<String, org.graalvm.polyglot.Context> contexts = new HashMap<String, org.graalvm.polyglot.Context>();
            try {
                Object content = null;
                for (String path : scripts.keySet()) {
                    org.graalvm.polyglot.Context context;
                    JSNode script = scripts.get(path);
                    String type = script.getString("type");
                    String caseVar = null;
                    if (path.toLowerCase().endsWith("switch")) {
                        Path reqPath = req.getSubpath();
                        Path switchPath = new Path(new String[]{path});
                        if (reqPath.size() > 0) {
                            caseVar = reqPath.get(reqPath.size() - 1);
                            if (switchPath.size() > 1 && switchPath.get(switchPath.size() - 2).equalsIgnoreCase(caseVar)) {
                                caseVar = null;
                            }
                        }
                    }
                    if ("javascript".equals(type)) {
                        context = (org.graalvm.polyglot.Context)contexts.get("javascript");
                        if (context == null) {
                            context = org.graalvm.polyglot.Context.create((String[])new String[]{"js"});
                            contexts.put("javascript", context);
                            Value bindings = context.getBindings("js");
                            bindings.putMember("engine", (Object)req.getEngine());
                            bindings.putMember("api", (Object)req.getApi());
                            bindings.putMember("endpoint", (Object)req.getEndpoint());
                            bindings.putMember("action", (Object)this);
                            bindings.putMember("chain", (Object)req.getChain());
                            bindings.putMember("req", (Object)req);
                            bindings.putMember("res", (Object)res);
                            bindings.putMember("scriptJson", (Object)script.getString("script"));
                            bindings.putMember("case", (Object)caseVar);
                            bindings.putMember("util", (Object)new Util());
                            for (String key : req.getUrl().getParams().keySet()) {
                                if (bindings.hasMember(key)) continue;
                                bindings.putMember(key, (Object)req.getUrl().getParam(key));
                            }
                        }
                        context.getBindings("js").putMember("content", content);
                        context.eval("js", (CharSequence)script.getString("script"));
                        content = context.getBindings("js").getMember("content").asString();
                        continue;
                    }
                    if (!"velocity".equals(type)) continue;
                    context = (VelocityContext)contexts.get("velocity");
                    if (context == null) {
                        context = new VelocityContext();
                        contexts.put("velocity", context);
                        context.put("method", (Object)req.getMethod());
                        context.put("engine", (Object)req.getEngine());
                        context.put("api", (Object)req.getApi());
                        context.put("endpoint", (Object)req.getEndpoint());
                        context.put("action", (Object)this);
                        context.put("chain", (Object)req.getChain());
                        context.put("req", (Object)req);
                        context.put("res", (Object)res);
                        context.put("scriptJson", (Object)script);
                        context.put("case", (Object)caseVar);
                        context.put("util", (Object)new Util());
                        for (String key : req.getUrl().getParams().keySet()) {
                            if (context.containsKey(key)) continue;
                            context.put(key, (Object)req.getUrl().getParam(key));
                        }
                        EventCartridge ec = new EventCartridge();
                        ec.addEventHandler((EventHandler)new IncludeRelativePath());
                        ec.attachToContext((Context)context);
                    }
                    context.put("content", content);
                    Template template = this.velocity.getTemplate(path);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(baos));
                    template.merge((Context)context, (Writer)writer);
                    writer.flush();
                    writer.close();
                    content = baos.toString();
                    context.put("content", content);
                }
                if (content == null || Utils.empty((Object[])new Object[]{content})) break block19;
                boolean setText = true;
                if (((String)content).startsWith("{") || ((String)content).startsWith("[")) {
                    try {
                        JSNode obj = JSNode.parseJsonNode(content);
                        res.withJson(obj);
                        setText = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (setText) {
                    res.withText(((String)content).trim());
                }
            }
            catch (Exception ex) {
                throw ApiException.new500InternalServerError((Throwable)ex);
            }
            finally {
                for (Object context : contexts.values()) {
                    if (!(context instanceof org.graalvm.polyglot.Context)) continue;
                    ((org.graalvm.polyglot.Context)context).close();
                }
            }
        }
    }

    public LinkedHashMap<String, JSNode> findScripts(Request req) throws ApiException {
        String guess;
        HashMap<JSNode, String> paths = new HashMap<JSNode, String>();
        ArrayList<Object> scripts = new ArrayList<Object>();
        String subpath = req.getSubpath().toString();
        List parts = Utils.explode((String)"/", (String[])new String[]{subpath});
        JSNode script = null;
        String path = null;
        ArrayList<String> guesses = new ArrayList<String>();
        if (parts.size() > 1) {
            if (this.ext((String)parts.get(1)) == null) {
                guesses.add(Utils.implode((String)"/", (Object[])new Object[]{parts.get(0), "switch"}));
            }
            guesses.add(Utils.implode((String)"/", (Object[])new Object[]{parts.get(0), parts.get(1)}));
        }
        if (parts.size() == 0 || this.ext((String)parts.get(0)) == null) {
            if (parts.size() > 0) {
                guesses.add(Utils.implode((String)"/", (Object[])new Object[]{parts.get(0), "switch"}));
            }
            guesses.add("switch");
        }
        if (parts.size() == 1) {
            guesses.add((String)parts.get(0));
        }
        if (req.getResourceKey() != null) {
            guesses.add(req.getResourceKey());
        }
        Iterator iterator = guesses.iterator();
        while (iterator.hasNext() && (script = ScriptAction.findScript(path = (guess = (String)iterator.next()))) == null) {
        }
        if (script != null) {
            int i;
            scripts.add(script);
            paths.put(script, path);
            parts = Utils.explode((String)"/", (String[])new String[]{path});
            ArrayList<JSNode> settings = new ArrayList<JSNode>();
            for (i = 0; i < parts.size(); ++i) {
                String string = i == 0 ? "" : Utils.implode((String)"/", (Object[])new Object[]{parts.subList(0, i - 1)});
                path = Utils.implode((String)"/", (Object[])new Object[]{string, "settings"});
                script = ScriptAction.findScript(path);
                if (script == null) continue;
                settings.add(script);
            }
            if (settings.size() > 0) {
                scripts.addAll(0, settings);
                paths.put(script, path);
            }
            for (i = parts.size() - 1; i >= 0; --i) {
                String string = i == 0 ? "" : Utils.implode((String)"/", (Object[])new Object[]{parts.subList(0, i)});
                path = Utils.implode((String)"/", (Object[])new Object[]{string, "layout"});
                script = ScriptAction.findScript(path);
                if (script == null) continue;
                scripts.add(script);
                paths.put(script, path);
            }
        }
        LinkedHashMap<String, JSNode> ordered = new LinkedHashMap<String, JSNode>();
        for (JSNode jSNode : scripts) {
            ordered.put((String)paths.get(jSNode), jSNode);
        }
        return ordered;
    }

    String ext(String fileName) {
        String ext;
        if (fileName.indexOf(".") > 0 && this.scriptTypes.containsKey(ext = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase())) {
            return ext;
        }
        return null;
    }

    public String getScriptsCollection() {
        return this.scriptsCollection;
    }

    public void setScriptsCollection(String scriptsCollection) {
        this.scriptsCollection = scriptsCollection;
    }

    public String getScriptsDir() {
        return this.scriptsDir;
    }

    public ScriptAction withScriptsDir(String scriptsDir) {
        this.scriptsDir = scriptsDir;
        return this;
    }

    public long getCacheExpireSeconds() {
        return this.cacheExpireSeconds;
    }

    public void setCacheExpireSeconds(long cacheExpireSeconds) {
        this.cacheExpireSeconds = cacheExpireSeconds;
    }

    public ScriptAction withCacheExpireSeconds(long cacheExpireSeconds) {
        this.setCacheExpireSeconds(cacheExpireSeconds);
        return this;
    }

    public static class Util {
        public void throwApiException(String status, String message) {
            throw ApiException.new500InternalServerError((String)status, (Object[])new Object[]{message});
        }

        public void throwBadRequest(String message) {
            throw ApiException.new400BadRequest((String)message, (Object[])new Object[0]);
        }

        public void throwNotFound(String message) {
            throw ApiException.new404NotFound((String)message, (Object[])new Object[0]);
        }

        public void throwServerError(String message) {
            throw ApiException.new500InternalServerError((String)message, (Object[])new Object[0]);
        }

        public List<Object> list(Object obj) {
            ArrayList<Object> l = new ArrayList<Object>();
            if (obj instanceof Map) {
                l.addAll(((Map)obj).values());
            } else if (obj instanceof Collection) {
                l.addAll((Collection)obj);
            } else if (obj != null) {
                l.add(obj);
            }
            return l;
        }
    }
}

