/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.Bucket;
import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Results;
import io.inversion.rql.Term;
import io.inversion.s3.S3DbQuery;
import io.inversion.utils.Utils;
import java.util.List;
import java.util.Map;

public class S3Db
extends Db<S3Db> {
    protected String awsAccessKey = null;
    protected String awsSecretKey = null;
    protected String awsRegion = null;
    protected String bucket = null;
    protected String basePath = null;
    protected String includePaths = null;
    private AmazonS3 client = null;

    protected void doStartup(Api api) {
        AmazonS3 client = this.getS3Client();
        List bucketList = client.listBuckets();
        for (Bucket bucket : bucketList) {
            Collection coll = new Collection(bucket.getName());
            coll.withProperty("key", String.class.getName(), false);
            this.withCollection(coll);
        }
    }

    public Results doSelect(Collection table, List<Term> columnMappedTerms) throws ApiException {
        S3DbQuery query = new S3DbQuery(this, table, columnMappedTerms);
        return query.doSelect();
    }

    public List<String> doUpsert(Collection table, List<Map<String, Object>> rows) throws ApiException {
        return null;
    }

    public void delete(Collection table, List<Map<String, Object>> indexValues) throws ApiException {
    }

    public AmazonS3 getS3Client() {
        return this.getS3Client(this.awsRegion, this.awsAccessKey, this.awsSecretKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonS3 getS3Client(String awsRegion, String awsAccessKey, String awsSecretKey) {
        if (this.client == null) {
            S3Db s3Db = this;
            synchronized (s3Db) {
                if (this.client == null) {
                    AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
                    if (!Utils.empty((Object[])new Object[]{awsRegion})) {
                        builder.withRegion(awsRegion);
                    }
                    if (!Utils.empty((Object[])new Object[]{awsAccessKey}) && !Utils.empty((Object[])new Object[]{awsSecretKey})) {
                        BasicAWSCredentials creds = new BasicAWSCredentials(awsAccessKey, awsSecretKey);
                        builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)creds));
                    }
                    this.client = (AmazonS3)builder.build();
                }
            }
        }
        return this.client;
    }

    public S3Db withAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
        return this;
    }

    public S3Db withAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
        return this;
    }

    public S3Db withAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
        return this;
    }

    public S3Db withBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }
}

