/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.s3;

import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Results;
import io.inversion.rql.From;
import io.inversion.rql.Group;
import io.inversion.rql.Order;
import io.inversion.rql.Page;
import io.inversion.rql.Query;
import io.inversion.rql.Select;
import io.inversion.rql.Term;
import io.inversion.rql.Where;
import io.inversion.s3.S3Db;
import java.util.List;

public class S3DbQuery
extends Query<S3DbQuery, S3Db, Select<Select<Select, S3DbQuery>, S3DbQuery>, From<From<From, S3DbQuery>, S3DbQuery>, Where<Where<Where, S3DbQuery>, S3DbQuery>, Group<Group<Group, S3DbQuery>, S3DbQuery>, Order<Order<Order, S3DbQuery>, S3DbQuery>, Page<Page<Page, S3DbQuery>, S3DbQuery>> {
    public S3DbQuery(S3Db db, Collection table, List<Term> terms) {
        super((Db)db, table, terms, new String[0]);
        this.getWhere().clearFunctions();
        this.getWhere().withFunctions(new String[]{"eq", "sw"});
    }

    public Results doSelect() throws ApiException {
        ListObjectsRequest req = new ListObjectsRequest();
        req.setBucketName(this.getCollection().getTableName());
        req.setMaxKeys(Integer.valueOf(this.getPage().getLimit()));
        req.setDelimiter("/");
        String prefix = Chain.top().getRequest().getSubpath().toString();
        while (prefix.startsWith("/")) {
            prefix = prefix.substring(1);
        }
        while (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        req.setPrefix(prefix);
        ObjectListing listing = ((S3Db)this.getDb()).getS3Client().listObjects(req);
        Results results = new Results((Query)this);
        if (listing.isTruncated()) {
            results.withNext(Term.term(null, (String)"after", (Object[])new Object[]{listing.getNextMarker()}));
        }
        List directoryList = listing.getCommonPrefixes();
        List fileList = listing.getObjectSummaries();
        while (!directoryList.isEmpty()) {
            String directory = (String)directoryList.get(0);
            if (!fileList.isEmpty()) {
                S3ObjectSummary file = (S3ObjectSummary)fileList.get(0);
                if (directory.compareToIgnoreCase(file.getKey()) < 0) {
                    directoryList.remove(0);
                    continue;
                }
                fileList.remove(0);
                continue;
            }
            directoryList.remove(0);
        }
        while (!fileList.isEmpty()) {
            S3ObjectSummary s3ObjectSummary = (S3ObjectSummary)fileList.remove(0);
        }
        return results;
    }
}

