/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.s3;

import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Request;
import io.inversion.Results;
import io.inversion.Url;
import io.inversion.rql.From;
import io.inversion.rql.Group;
import io.inversion.rql.Order;
import io.inversion.rql.Page;
import io.inversion.rql.Query;
import io.inversion.rql.Select;
import io.inversion.rql.Term;
import io.inversion.rql.Where;
import io.inversion.s3.S3Db;
import io.inversion.utils.Path;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class S3DbQuery
extends Query<S3DbQuery, S3Db, Select<Select<Select, S3DbQuery>, S3DbQuery>, From<From<From, S3DbQuery>, S3DbQuery>, Where<Where<Where, S3DbQuery>, S3DbQuery>, Group<Group<Group, S3DbQuery>, S3DbQuery>, Order<Order<Order, S3DbQuery>, S3DbQuery>, Page<Page<Page, S3DbQuery>, S3DbQuery>> {
    Path securePrefix = null;

    public S3DbQuery(S3Db db, Collection table, Path securePrefix, List<Term> terms) {
        super((Db)db, table, terms, new String[0]);
        this.securePrefix = securePrefix;
        this.getWhere().clearFunctions();
        this.getWhere().withFunctions(new String[]{"eq", "sw"});
    }

    public Results doSelect() throws ApiException {
        Path prefix = new Path();
        if (this.securePrefix != null) {
            prefix.add(this.securePrefix.toString());
        }
        Request req = Chain.peek().getRequest();
        Path pathPrefix = req.getPath();
        Path epPath = req.getEndpointPath();
        if ((pathPrefix = pathPrefix.subpath(epPath.size(), pathPrefix.size())).size() >= 1) {
            pathPrefix = pathPrefix.subpath(1, pathPrefix.size());
        }
        prefix.add(pathPrefix.toString());
        ListObjectsRequest s3Req = new ListObjectsRequest();
        s3Req.setBucketName(this.getCollection().getTableName());
        s3Req.setMaxKeys(Integer.valueOf(this.getPage().getLimit()));
        if (prefix.size() > 0) {
            s3Req.setPrefix(prefix.toString() + "/");
        }
        s3Req.setDelimiter("/");
        System.out.println("prefix    = " + s3Req.getPrefix());
        System.out.println("delimiter = " + s3Req.getDelimiter());
        ObjectListing listing = ((S3Db)this.getDb()).getS3Client().listObjects(s3Req);
        Results results = new Results((Query)this);
        if (listing.isTruncated()) {
            results.withNext(Term.term(null, (String)"after", (Object[])new Object[]{listing.getNextMarker()}));
        }
        List directoryList = listing.getCommonPrefixes();
        List fileList = listing.getObjectSummaries();
        ArrayList<String> found = new ArrayList<String>();
        while (!directoryList.isEmpty()) {
            String directory = (String)directoryList.remove(0);
            found.add(directory);
        }
        while (!fileList.isEmpty()) {
            S3ObjectSummary file = (S3ObjectSummary)fileList.remove(0);
            found.add((String)file);
        }
        String removeSecure = null;
        if (this.securePrefix != null) {
            removeSecure = this.securePrefix.toString() + "/";
        }
        for (Object e : found) {
            String key;
            String string = key = e instanceof String ? (String)e : ((S3ObjectSummary)e).getKey();
            if (removeSecure != null) {
                key = key.substring(removeSecure.length());
            }
            Request root = Chain.peek().getRequest();
            Url url = root.getUrl().copy();
            url.clearParams();
            Path path = new Path(root.getServerPath());
            path.add(root.getEndpointPath().toString());
            path.add(root.getActionPath().first());
            path.add(key);
            url.withPath(path);
            LinkedHashMap row = Utils.asMap((Object[])new Object[]{"key", key, "href", url.toString()});
            results.withRow((Map)row);
        }
        return results;
    }
}

