/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.redis;

import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Results;
import io.inversion.rql.Term;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisDb
extends Db<RedisDb> {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected transient JedisPool jedis = null;
    protected String host = null;
    protected int port = 6379;
    protected int poolMin = 16;
    protected int poolMax = 128;
    protected boolean testOnBorrow = true;
    protected boolean testOnReturn = true;
    protected boolean testWhileIdle = true;
    protected int minEvictableIdleTimeMillis = 60000;
    protected int timeBetweenEvictionRunsMillis = 30000;
    protected int numTestsPerEvictionRun = 3;
    protected boolean blockWhenExhausted = true;
    protected String nocacheParam = "nocache";
    protected int readSocketTimeout = 2500;
    protected int ttl = 15552000;

    public Results doSelect(Collection table, List<Term> queryTerms) throws ApiException {
        return null;
    }

    public List<String> doUpsert(Collection table, List<Map<String, Object>> rows) throws ApiException {
        return null;
    }

    public void delete(Collection table, List<Map<String, Object>> indexValues) throws ApiException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Jedis getRedisClient() {
        if (this.jedis == null) {
            RedisDb redisDb = this;
            synchronized (redisDb) {
                if (this.jedis == null) {
                    JedisPoolConfig poolConfig = new JedisPoolConfig();
                    poolConfig.setMaxTotal(this.poolMax);
                    poolConfig.setMaxIdle(this.poolMax);
                    poolConfig.setMinIdle(this.poolMin);
                    poolConfig.setTestOnBorrow(this.testOnBorrow);
                    poolConfig.setTestOnReturn(this.testOnReturn);
                    poolConfig.setTestWhileIdle(this.testWhileIdle);
                    poolConfig.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis);
                    poolConfig.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis);
                    poolConfig.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
                    poolConfig.setBlockWhenExhausted(this.blockWhenExhausted);
                    this.jedis = new JedisPool((GenericObjectPoolConfig)poolConfig, this.host, this.port, this.readSocketTimeout);
                }
            }
        }
        return this.jedis.getResource();
    }

    public String getHost() {
        return this.host;
    }

    public RedisDb withHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public RedisDb withPort(int port) {
        this.port = port;
        return this;
    }

    public int getPoolMin() {
        return this.poolMin;
    }

    public RedisDb withPoolMin(int poolMin) {
        this.poolMin = poolMin;
        return this;
    }

    public int getPoolMax() {
        return this.poolMax;
    }

    public RedisDb withPoolMax(int poolMax) {
        this.poolMax = poolMax;
        return this;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public RedisDb withTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        return this;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public RedisDb withTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        return this;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public RedisDb withTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        return this;
    }

    public int getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public RedisDb withMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        return this;
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public RedisDb withTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        return this;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public RedisDb withNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
        return this;
    }

    public boolean isBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    public RedisDb withBlockWhenExhausted(boolean blockWhenExhausted) {
        this.blockWhenExhausted = blockWhenExhausted;
        return this;
    }

    public String getNocacheParam() {
        return this.nocacheParam;
    }

    public RedisDb withNocacheParam(String nocacheParam) {
        this.nocacheParam = nocacheParam;
        return this;
    }

    public int getReadSocketTimeout() {
        return this.readSocketTimeout;
    }

    public RedisDb withReadSocketTimeout(int readSocketTimeout) {
        this.readSocketTimeout = readSocketTimeout;
        return this;
    }

    public int getTtl() {
        return this.ttl;
    }

    public RedisDb withTtl(int ttl) {
        this.ttl = ttl;
        return this;
    }
}

