/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.redis;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inversion.User;
import io.inversion.action.security.AuthAction;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisAuthSessionCache
extends AuthAction.InMemorySessionDao {
    protected final Logger log = LoggerFactory.getLogger(RedisAuthSessionCache.class);
    protected final ObjectMapper om = new ObjectMapper();
    protected String redisHost = null;
    protected int redisPort = 6379;
    protected int redisPoolMin = 16;
    protected int redisPoolMax = 128;
    protected boolean redisTestOnBorrow = true;
    protected boolean redisTestOnReturn = true;
    protected boolean redisTestWhileIdle = true;
    protected int redisMinEvictableIdleTimeMillis = 60000;
    protected int redisTimeBetweenEvictionRunsMillis = 30000;
    protected int redisNumTestsPerEvictionRun = 3;
    protected boolean redisBlockWhenExhausted = true;
    protected int redisReadSocketTimeout = 2500;
    protected int redisTtl = 28800;
    protected String keyPrefix = "RedisAuthSess-";
    JedisPool jedisPool;

    public User doGet(String sessionKey) {
        return (User)this.execute(jedis -> {
            User user = null;
            String userJson = jedis.get(this.key(sessionKey));
            if (userJson != null) {
                jedis.expire(this.key(sessionKey), this.redisTtl);
                user = (User)this.om.readValue(userJson, User.class);
            }
            return user;
        });
    }

    public void doPut(String sessionKey, User user) {
        if (sessionKey != null && user != null) {
            this.execute(jedis -> {
                String userJson = this.om.writeValueAsString((Object)user);
                jedis.setex(this.key(sessionKey), this.redisTtl, userJson);
                return null;
            });
        }
    }

    public void doDelete(String sessionKey) {
        this.execute(jedis -> {
            jedis.del(this.key(sessionKey));
            return null;
        });
    }

    String key(String sessionKey) {
        return this.keyPrefix + sessionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object execute(JedisCallback jedisCallback) {
        Jedis jedis = null;
        Object returnVal = null;
        try {
            try {
                jedis = this.getJedis();
                returnVal = jedisCallback.doWithJedis(jedis);
            }
            catch (Exception ex) {
                this.log.warn("Error getting or using the Redis client", (Throwable)ex);
            }
        }
        finally {
            if (jedis != null) {
                try {
                    jedis.close();
                }
                catch (Exception ex) {
                    this.log.warn("Error closing redis connection", (Throwable)ex);
                }
            }
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Jedis getJedis() {
        if (this.jedisPool == null) {
            RedisAuthSessionCache redisAuthSessionCache = this;
            synchronized (redisAuthSessionCache) {
                JedisPoolConfig poolConfig = new JedisPoolConfig();
                poolConfig.setMaxTotal(this.redisPoolMax);
                poolConfig.setMaxIdle(this.redisPoolMax);
                poolConfig.setMinIdle(this.redisPoolMin);
                poolConfig.setTestOnBorrow(this.redisTestOnBorrow);
                poolConfig.setTestOnReturn(this.redisTestOnReturn);
                poolConfig.setTestWhileIdle(this.redisTestWhileIdle);
                poolConfig.setMinEvictableIdleTimeMillis((long)this.redisMinEvictableIdleTimeMillis);
                poolConfig.setTimeBetweenEvictionRunsMillis((long)this.redisTimeBetweenEvictionRunsMillis);
                poolConfig.setNumTestsPerEvictionRun(this.redisNumTestsPerEvictionRun);
                poolConfig.setBlockWhenExhausted(this.redisBlockWhenExhausted);
                this.jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, this.redisHost, this.redisPort, this.redisReadSocketTimeout);
            }
        }
        return this.jedisPool.getResource();
    }

    public void setRedisHost(String redisHost) {
        this.redisHost = redisHost;
    }

    public RedisAuthSessionCache withRedisHost(String redisHost) {
        this.setRedisHost(redisHost);
        return this;
    }

    public void setRedisPort(int redisPort) {
        this.redisPort = redisPort;
    }

    public RedisAuthSessionCache withRedisPort(int redisPort) {
        this.setRedisPort(redisPort);
        return this;
    }

    public void setRedisPoolMin(int redisPoolMin) {
        this.redisPoolMin = redisPoolMin;
    }

    public RedisAuthSessionCache withRedisPoolMin(int redisPoolMin) {
        this.setRedisPoolMin(redisPoolMin);
        return this;
    }

    public void setRedisPoolMax(int redisPoolMax) {
        this.redisPoolMax = redisPoolMax;
    }

    public RedisAuthSessionCache withRedisPoolMax(int redisPoolMax) {
        this.setRedisPoolMax(redisPoolMax);
        return this;
    }

    public void setRedisTestOnBorrow(boolean redisTestOnBorrow) {
        this.redisTestOnBorrow = redisTestOnBorrow;
    }

    public RedisAuthSessionCache withRedisTestOnBorrow(boolean redisTestOnBorrow) {
        this.setRedisTestOnBorrow(redisTestOnBorrow);
        return this;
    }

    public void setRedisTestOnReturn(boolean redisTestOnReturn) {
        this.redisTestOnReturn = redisTestOnReturn;
    }

    public RedisAuthSessionCache withRedisTestOnReturn(boolean redisTestOnReturn) {
        this.setRedisTestOnReturn(redisTestOnReturn);
        return this;
    }

    public void setRedisTestWhileIdle(boolean redisTestWhileIdle) {
        this.redisTestWhileIdle = redisTestWhileIdle;
    }

    public RedisAuthSessionCache withRedisTestWhileIdle(boolean redistTestWhileIdle) {
        this.setRedisTestWhileIdle(this.redisTestWhileIdle);
        return this;
    }

    public void setRedisMinEvictableIdleTimeMillis(int redisMinEvictableIdleTimeMillis) {
        this.redisMinEvictableIdleTimeMillis = redisMinEvictableIdleTimeMillis;
    }

    public RedisAuthSessionCache withRedisMinEvictableIdleTimeMillis(int redisMinEvictableIdleTimeMillis) {
        this.setRedisMinEvictableIdleTimeMillis(redisMinEvictableIdleTimeMillis);
        return this;
    }

    public void setRedisTimeBetweenEvictionRunsMillis(int redisTimeBetweenEvictionRunsMillis) {
        this.redisTimeBetweenEvictionRunsMillis = redisTimeBetweenEvictionRunsMillis;
    }

    public RedisAuthSessionCache withRedisTimeBetweenEvictionRunsMillis(int redisTimeBetweenEvictionRunsMillis) {
        this.setRedisTimeBetweenEvictionRunsMillis(redisTimeBetweenEvictionRunsMillis);
        return this;
    }

    public void setRedisNumTestsPerEvictionRun(int redisNumTestsPerEvictionRun) {
        this.redisNumTestsPerEvictionRun = redisNumTestsPerEvictionRun;
    }

    public RedisAuthSessionCache withRedisNumTestsPerEvictionRun(int redisNumTestsPerEvictionRun) {
        this.setRedisNumTestsPerEvictionRun(redisNumTestsPerEvictionRun);
        return this;
    }

    public void setRedisBlockWhenExhausted(boolean redisBlockWhenExhausted) {
        this.redisBlockWhenExhausted = redisBlockWhenExhausted;
    }

    public RedisAuthSessionCache withRedisBlockWhenExhausted(boolean redisBlockWhenExhausted) {
        this.setRedisBlockWhenExhausted(redisBlockWhenExhausted);
        return this;
    }

    public void setRedisReadSocketTimeout(int redisReadSocketTimeout) {
        this.redisReadSocketTimeout = redisReadSocketTimeout;
    }

    public RedisAuthSessionCache withRedisReadSocketTimeout(int redisReadSocketTimeout) {
        this.setRedisReadSocketTimeout(redisReadSocketTimeout);
        return this;
    }

    public void setRedisTtl(int redisTtl) {
        this.redisTtl = redisTtl;
    }

    public RedisAuthSessionCache withRedisTtl(int redisTtl) {
        this.setRedisTtl(redisTtl);
        return this;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public RedisAuthSessionCache withKeyPrefix(String keyPrefix) {
        this.setKeyPrefix(keyPrefix);
        return this;
    }

    static interface JedisCallback {
        public Object doWithJedis(Jedis var1) throws Exception;
    }
}

