/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.spring.config;

import io.inversion.Api;
import io.inversion.Engine;
import io.inversion.EngineServlet;
import io.inversion.Server;
import io.inversion.Url;
import io.inversion.spring.config.InversionRegistrar;
import io.inversion.utils.Path;
import jakarta.servlet.Servlet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.StreamSupport;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;

@Configuration
public class InversionConfig {
    @Bean
    public ServletRegistrationBean buildEngineServlet(@Autowired Engine engine, Api ... apis) {
        this.applyEnvironment(engine, InversionRegistrar.environment);
        for (int i = 0; apis != null && i < apis.length; ++i) {
            engine.withApi(apis[i]);
        }
        EngineServlet servlet = new EngineServlet();
        servlet.setEngine(engine);
        String servletMapping = InversionConfig.buildServletMapping(engine);
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)servlet, new String[]{servletMapping});
        bean.setLoadOnStartup(1);
        return bean;
    }

    protected void applyEnvironment(Engine engine, Environment environment) {
        PropertiesConfiguration springConfig = new PropertiesConfiguration();
        MutablePropertySources sources = ((AbstractEnvironment)environment).getPropertySources();
        StreamSupport.stream(sources.spliterator(), false).filter(ps -> ps instanceof EnumerablePropertySource).map(ps -> ((EnumerablePropertySource)ps).getPropertyNames()).flatMap(Arrays::stream).distinct().forEach(prop -> springConfig.setProperty(prop, (Object)environment.getProperty(prop)));
        CompositeConfiguration inversionConfig = engine.getConfig().getConfiguration();
        inversionConfig.addConfiguration((org.apache.commons.configuration2.Configuration)springConfig);
        System.out.println("  - config source : Spring Boot Configuration");
    }

    @Bean
    public ConfigurableServletWebServerFactory buildWebServerFactory() {
        TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory();
        tomcat.addContextCustomizers(new TomcatContextCustomizer[]{context -> context.setAllowCasualMultipartParsing(true)});
        tomcat.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> connector.setMaxPostSize(1024)});
        return tomcat;
    }

    public static String buildServletMapping(Engine engine) {
        ArrayList<String> parts = new ArrayList<String>();
        boolean done = false;
        ArrayList<Path> allServerPaths = new ArrayList<Path>();
        for (Api api : engine.getApis()) {
            for (Server server : api.getServers()) {
                for (Url url : server.getUrls()) {
                    allServerPaths.add(url.getPath());
                }
            }
        }
        for (int i = 0; i < 100 && !done; ++i) {
            String part = null;
            for (Path path : allServerPaths) {
                if (part == null) {
                    part = path.get(i);
                }
                if (part != null && path.isStatic(i) && part.equals(path.get(i))) continue;
                done = true;
                break;
            }
            if (part == null) break;
            if (done) continue;
            parts.add(part);
        }
        String path = (String)(parts.size() > 0 ? "/" + new Path(parts) : "") + "/*";
        return path;
    }
}

