/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.ApiException;
import io.inversion.Engine;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Upload;
import io.inversion.json.JSNode;
import io.inversion.utils.ListMap;
import io.inversion.utils.StreamBuffer;
import io.inversion.utils.Utils;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class EngineServlet
extends HttpServlet {
    Engine engine = null;

    public static String readBody(HttpServletRequest request) throws ApiException {
        if (request == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            Object inputStream = request.getInputStream();
            if (inputStream != null) {
                int bytesRead;
                if ("gzip".equalsIgnoreCase(request.getHeader("Content-Encoding"))) {
                    inputStream = new GZIPInputStream((InputStream)inputStream, 1024);
                }
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[128];
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            }
        }
        catch (Exception ex) {
            throw ApiException.new400BadRequest((Throwable)ex, (String)"Unable to read request body", (Object[])new Object[0]);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuilder.toString();
    }

    public void destroy() {
        this.engine.shutdown();
    }

    public void init(ServletConfig config) {
        this.engine.startup();
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void service(HttpServletRequest httpReq, HttpServletResponse httpResp) throws ServletException, IOException {
        EngineServletLocal.set(httpReq, httpResp);
        try {
            Object lower;
            String query;
            String method = httpReq.getMethod();
            Object urlstr = httpReq.getRequestURL().toString();
            if (!((String)urlstr).endsWith("/")) {
                urlstr = (String)urlstr + "/";
            }
            if (!Utils.empty((Object[])new Object[]{query = httpReq.getQueryString()})) {
                urlstr = (String)urlstr + "?" + query;
            }
            if (((String)(lower = urlstr)).equals("http://localhost") || ((String)lower).startsWith("http://localhost/") || ((String)lower).startsWith("http://localhost:") || ((String)lower).equals("https://localhost") || ((String)lower).startsWith("https://localhost/") || ((String)lower).startsWith("https://localhost:")) {
                urlstr = Pattern.compile("localhost", 2).matcher((CharSequence)urlstr).replaceFirst("127.0.0.1");
                httpResp.sendRedirect((String)urlstr);
                return;
            }
            ListMap headers = new ListMap();
            Enumeration headerEnum = httpReq.getHeaderNames();
            while (headerEnum.hasMoreElements()) {
                String key = (String)headerEnum.nextElement();
                Enumeration values = httpReq.getHeaders(key);
                while (values.hasMoreElements()) {
                    String val = (String)values.nextElement();
                    headers.put((Object)key, (Object)val);
                }
            }
            HashMap<String, String> params = new HashMap<String, String>();
            Enumeration paramsEnumer = httpReq.getParameterNames();
            while (paramsEnumer.hasMoreElements()) {
                String key = (String)paramsEnumer.nextElement();
                Object[] values = httpReq.getParameterValues(key);
                String value = values == null ? null : (values.length == 1 ? values[0] : Utils.implode((String)",", (Object[])values));
                params.put(key, value);
            }
            String body = EngineServlet.readBody(httpReq);
            if (body != null && body.startsWith("--") && body.indexOf("Content-Disposition") > 0) {
                throw ApiException.new400BadRequest((String)"Received invalid multipart content.", (Object[])new Object[0]);
            }
            Request req = new Request(method, (String)urlstr, body, params, headers);
            req.withRemoteAddr(httpReq.getRemoteAddr());
            req.withUploader(() -> {
                try {
                    ArrayList<Upload> uploads = new ArrayList<Upload>();
                    for (Part part : httpReq.getParts()) {
                        String partName = part.getName();
                        String fileName = part.getSubmittedFileName();
                        InputStream inputStream = part.getInputStream();
                        long fileSize = part.getSize();
                        String fileType = part.getContentType();
                        if (fileName == null || inputStream == null) continue;
                        uploads.add(new Upload(partName, fileName, fileSize, fileType, inputStream));
                    }
                    return uploads;
                }
                catch (Exception ex) {
                    Utils.rethrow((Throwable)ex);
                    return null;
                }
            });
            Response res = new Response();
            this.engine.service(req, res);
            this.writeResponse(req, res, httpResp);
        }
        catch (Throwable ex) {
            JSNode json = Engine.buildErrorJson((Throwable)ex);
            ServletOutputStream out = httpResp.getOutputStream();
            byte[] bytes = json.toString().getBytes(StandardCharsets.UTF_8);
            out.write(bytes);
            out.flush();
            out.close();
        }
    }

    void writeResponse(Request req, Response res, HttpServletResponse http) throws Exception {
        http.setStatus(res.getStatusCode());
        ServletOutputStream out = http.getOutputStream();
        ListMap headers = res.getHeaders();
        headers.keySet().forEach(key -> http.setHeader(key, Utils.implode((String)",", (Object[])new Object[]{res.getHeaders().get(key)})));
        if (!req.isMethod(new String[]{"OPTIONS"})) {
            String contentType = res.getContentType();
            http.setContentType(contentType);
            StreamBuffer buffer = res.getBody();
            if (buffer != null) {
                http.setContentLength(buffer.getLength());
                Utils.pipe((InputStream)buffer.getInputStream(), (OutputStream)out, (boolean)true, (boolean)false);
            }
        }
        out.flush();
        out.close();
    }

    static class EngineServletLocal {
        static final ThreadLocal<HttpServletRequest> request = new ThreadLocal();
        static final ThreadLocal<HttpServletResponse> response = new ThreadLocal();

        EngineServletLocal() {
        }

        public static void set(HttpServletRequest req, HttpServletResponse res) {
            request.set(req);
            response.set(res);
        }

        public static HttpServletRequest getRequest() {
            return request.get();
        }

        public static void setRequest(HttpServletRequest req) {
            request.set(req);
        }

        public static HttpServletResponse getResponse() {
            return response.get();
        }

        public static void setResponse(HttpServletResponse res) {
            response.set(res);
        }
    }
}

