/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.security.schemes;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.inversion.ApiException;
import io.inversion.Param;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.User;
import io.inversion.action.security.AuthScheme;
import io.inversion.action.security.schemes.HttpAuthScheme;
import io.inversion.json.JSList;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;
import io.inversion.json.JSParser;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BearerScheme
extends HttpAuthScheme {
    public static final String CONTEXT_KEY_API_NAME = "__API_NAME";
    protected final transient Logger log = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    protected Param.In in = Param.In.HEADER;
    protected String requestHeaderKey = "Authorization";
    protected String barerFormat = "JWT";
    protected String requiredTokenPrefix = "Bearer ";
    protected int ttl = 900000;
    protected SecretDao secretDao = null;

    public BearerScheme() {
        this.withHttpScheme(HttpAuthScheme.HttpScheme.bearer);
    }

    public String getBarerFormat() {
        return this.barerFormat;
    }

    public AuthScheme withBarerFormat(String barerFormat) {
        this.barerFormat = barerFormat;
        return this;
    }

    public User getUser(Request req, Response res) throws ApiException {
        String secret;
        String token = req.findParam(this.requestHeaderKey, new Param.In[]{this.in});
        if (token == null) {
            return null;
        }
        if (!(token = token.trim()).toLowerCase().startsWith(this.requiredTokenPrefix.toLowerCase())) {
            return null;
        }
        token = token.substring(this.requiredTokenPrefix.length()).trim();
        DecodedJWT jwt = null;
        Iterator<String> iterator = this.secretDao.getSecrets(req).iterator();
        while (iterator.hasNext() && (jwt = this.decodeJWT(token, secret = iterator.next())) == null) {
        }
        User user = null;
        if (jwt != null) {
            user = this.buildUser(jwt);
        }
        return user;
    }

    public User buildUser(DecodedJWT jwt) {
        User user = new User();
        String payload = jwt.getPayload();
        payload = new String(Base64.getDecoder().decode(payload.getBytes()));
        JSNode node = JSParser.asJSNode((String)payload);
        for (String key : node.keySet()) {
            Object value = node.get((Object)key);
            user.withClaim(key, value);
        }
        return user;
    }

    public String buildToken(Request req, User user) {
        List<String> secrets = this.secretDao.getSecrets(req);
        if (secrets.size() > 0) {
            return this.buildToken(user, secrets.get(0));
        }
        return null;
    }

    public String buildToken(User user, String secret) {
        try {
            JWTCreator.Builder builder = JWT.create();
            String jwt = null;
            long expires = System.currentTimeMillis() + (long)this.ttl;
            builder.withExpiresAt(new Date(expires));
            builder.withSubject(user.getSubject());
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)user);
            JSMap claims = JSParser.asJSMap((String)json);
            for (String name : claims.keySet()) {
                Object value = claims.get((Object)name);
                if (value == null) continue;
                if (value instanceof JSList) {
                    builder.withArrayClaim(name, (String[])((JSList)value).asList().toArray((Object[])new String[((JSList)value).size()]));
                    continue;
                }
                builder.withClaim(name, String.valueOf(value));
            }
            jwt = this.signJWT(builder, secret);
            return jwt;
        }
        catch (Exception ex) {
            throw ApiException.new500InternalServerError((String)"Error creating JWT", (Object[])new Object[]{ex.getMessage()});
        }
    }

    public String signJWT(JWTCreator.Builder builder, String secret) throws IllegalArgumentException, JWTCreationException, UnsupportedEncodingException {
        return builder.sign(Algorithm.HMAC256((String)secret));
    }

    public DecodedJWT decodeJWT(String token, String secret) {
        try {
            JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)secret)).acceptLeeway(1L).build();
            return verifier.verify(token);
        }
        catch (Exception ex) {
            this.log.info("Error decoding jwt:", (Object)ex.getMessage());
            return null;
        }
    }

    public SecretDao getSecretDao() {
        return this.secretDao;
    }

    public BearerScheme withSecretDao(SecretDao secretDao) {
        this.secretDao = secretDao;
        return this;
    }

    public String getRequiredTokenPrefix() {
        return this.requiredTokenPrefix;
    }

    public BearerScheme withRequiredTokenPrefix(String requiredTokenPrefix) {
        this.requiredTokenPrefix = requiredTokenPrefix;
        return this;
    }

    public static interface SecretDao {
        public List<String> getSecrets(Request var1);
    }

    public static enum In {
        header;

    }
}

