/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.jdbc;

import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Index;
import io.inversion.Property;
import io.inversion.Relationship;
import io.inversion.Results;
import io.inversion.jdbc.JdbcDb;
import io.inversion.jdbc.SqlTokenizer;
import io.inversion.query.From;
import io.inversion.query.Group;
import io.inversion.query.Order;
import io.inversion.query.Page;
import io.inversion.query.Projection;
import io.inversion.query.Query;
import io.inversion.query.Select;
import io.inversion.query.Where;
import io.inversion.rql.Term;
import io.inversion.utils.JdbcUtils;
import io.inversion.utils.Rows;
import io.inversion.utils.Utils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SqlQuery<D extends Db>
extends Query<SqlQuery, D, Select<Select<Select, SqlQuery>, SqlQuery>, From<From<From, SqlQuery>, SqlQuery>, Where<Where<Where, SqlQuery>, SqlQuery>, Group<Group<Group, SqlQuery>, SqlQuery>, Order<Order<Order, SqlQuery>, SqlQuery>, Page<Page<Page, SqlQuery>, SqlQuery>> {
    protected char stringQuote = (char)39;
    protected char columnQuote = (char)34;
    String type = null;
    LinkedHashMap<String, Term> joins;

    public SqlQuery(D db, Collection table, List<Term> terms) {
        super(db, table, terms, new String[]{"_query"});
        this.withDb((Db)db);
    }

    protected boolean addTerm(String token, Term term) {
        String name;
        if (term.hasToken(new String[]{"eq"}) && (name = term.getToken(0)).endsWith(".select")) {
            return true;
        }
        if (term.hasToken(new String[]{"join"})) {
            String key;
            if (this.joins == null) {
                this.joins = new LinkedHashMap();
            }
            if (!this.joins.containsKey(key = term.toString())) {
                this.joins.put(key, term);
            }
            return true;
        }
        return super.addTerm(token, term);
    }

    public Results doSelect() throws ApiException {
        JdbcDb db = (JdbcDb)this.getDb();
        String sql = this.getPreparedStmt();
        Results results = new Results((Query)this);
        List values = this.getColValues();
        Object debug = ((Object)((Object)this)).getClass().getSimpleName() + " " + this.getType() + ": " + sql + " args=" + this.getOriginalValues();
        debug = ((String)debug).replaceAll("\r", "");
        debug = ((String)debug).replaceAll("\n", " ");
        debug = ((String)debug).replaceAll(" +", " ");
        Chain.debug((String)debug, (Object[])new Object[0]);
        results.withTestQuery((String)debug);
        if (!this.isDryRun()) {
            Connection conn = db.getConnection();
            try {
                List sorts;
                Index pk;
                Rows rows = JdbcUtils.selectRows((Connection)conn, (String)sql, (Object[])new Object[]{values});
                results.withRows((List)rows);
                boolean usesAfter = false;
                if (!this.getPage().isPaginated() && rows.size() > 0 && this.collection != null && (pk = this.collection.getResourceIndex()) != null && pk.size() == 1 && (sorts = this.getOrder().getSorts()).size() > 0) {
                    String lastPk;
                    String pkCol = pk.getColumnName(0);
                    Order.Sort last = (Order.Sort)sorts.get(sorts.size() - 1);
                    if (last.getProperty().equalsIgnoreCase(pk.getColumnName(0)) && (lastPk = this.collection.encodeKeyFromColumnNames((Map)rows.get(rows.size() - 1))) != null) {
                        usesAfter = true;
                        if (last.isAsc()) {
                            results.withNext(Term.term(null, (String)"gt", (Object[])new Object[]{pk.getColumnName(0), lastPk}));
                        } else {
                            results.withNext(Term.term(null, (String)"lt", (Object[])new Object[]{pk.getColumnName(0), lastPk}));
                        }
                    }
                }
                if (!usesAfter) {
                    boolean needsPaging;
                    int foundRows = rows.size();
                    int limit = this.getPage().getLimit();
                    int page = this.getPage().getOffset();
                    boolean bl = needsPaging = page > 1 || foundRows == limit;
                    if (needsPaging && Chain.peek().get("foundRows") == null && Chain.first().getRequest().isMethod(new String[]{"GET"})) {
                        foundRows = rows.size() == 0 ? 0 : this.queryFoundRows(conn, sql, values);
                        Chain.peek().put("foundRows", (Object)foundRows);
                    }
                    results.withFoundRows(foundRows);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ApiException.new500InternalServerError((Throwable)ex);
            }
        }
        return results;
    }

    public String getPreparedStmt() {
        return this.toSql(true);
    }

    public String getDynamicStmt() {
        return this.toSql(false);
    }

    protected String toSql(boolean preparedStmt) {
        this.clearValues();
        Parts parts = new Parts();
        this.printInitialSelect(parts);
        this.printTermsSelect(parts, preparedStmt);
        this.printWhereClause(parts, this.getWhere().getFilters(), preparedStmt);
        this.printGroupClause(parts, this.getGroup().getGroupBy());
        this.printOrderClause(parts, this.getOrder());
        this.printLimitClause(parts, this.getPage().getOffset(), this.getPage().getLimit());
        String sql = this.printSql(parts);
        return sql;
    }

    protected String printSql(Parts parts) {
        Object buff = parts.select;
        buff = (String)buff + " \r\n" + parts.from;
        if (parts.where != null) {
            buff = (String)buff + " \r\n" + parts.where;
        }
        if (parts.select.toLowerCase().startsWith("select ")) {
            if (parts.group != null) {
                buff = (String)buff + " \r\n" + parts.group;
            }
            if (parts.order != null) {
                buff = (String)buff + " \r\n" + parts.order;
            }
            if (parts.limit != null) {
                buff = (String)buff + " \r\n" + parts.limit;
            }
        }
        Object sql = buff;
        return sql;
    }

    protected String printInitialSelect(Parts parts) {
        Object initialSelect = (String)this.find("_query", 0);
        if (Utils.empty((Object[])new Object[]{initialSelect})) {
            String subquery = this.getFrom().getSubquery();
            String alias = this.quoteCol(this.getFrom().getAlias());
            boolean distinct = this.getSelect().isDistinct();
            if (subquery != null) {
                initialSelect = " SELECT " + (distinct ? "DISTINCT " : "") + alias + ".* FROM (" + subquery + ")";
            } else {
                String table = this.getFrom().getTable();
                if (Utils.empty((Object[])new Object[]{table})) {
                    throw ApiException.new400BadRequest((String)"Your requested url '{}' could not be mapped to a table to query for operation {}", (Object[])new Object[]{Chain.peek().getRequest().getUrl(), Chain.peek().getRequest().getOp().getName()});
                }
                subquery = this.quoteCol(this.getFrom().getTable());
                initialSelect = " SELECT " + (distinct ? "DISTINCT " : "") + alias + ".* FROM " + subquery;
            }
            if (!subquery.equals(alias)) {
                initialSelect = (String)initialSelect + " AS " + alias;
            }
        }
        parts.withSql((String)initialSelect);
        return initialSelect;
    }

    protected String printTermsSelect(Parts parts, boolean preparedStmt) {
        StringBuilder cols = new StringBuilder();
        Projection projection = this.getSelect().getProjection();
        int i = 0;
        for (String column : projection.keySet()) {
            ++i;
            if ("*".equals(column)) continue;
            Term term = projection.get(column);
            if (term.hasToken(new String[]{"as"})) {
                Term function = term.getTerm(0);
                cols.append(" ").append(this.printTerm(function, null, preparedStmt));
                String colName = term.getToken(1);
                if (!Utils.empty((Object[])new Object[]{colName}) && !colName.contains("$$$ANON")) {
                    if (this.db == null || this.db.isType(new String[]{"mysql"})) {
                        cols.append(" AS ").append(this.asString(colName));
                    } else {
                        cols.append(" AS ").append(this.quoteCol(colName));
                    }
                }
            } else if (!term.getToken().contains(".")) {
                cols.append(" ").append(this.printCol(term.getToken()));
            }
            if (i == this.terms.size()) continue;
            cols.append(", ");
        }
        if (cols.length() > 0) {
            boolean restrictCols;
            boolean aggregate = this.find(new String[]{"sum", "min", "max", "count", "function", "aggregate", "distinct"}) != null;
            boolean bl = restrictCols = this.find(new String[]{"include"}) != null || aggregate;
            if (this.db == null || this.db.isType(new String[]{"mysql"})) {
                restrictCols = this.find(new String[]{"include"}) != null;
            }
            int star = parts.select.lastIndexOf("* ");
            if (restrictCols && star > 0) {
                int idx = parts.select.substring(0, star).indexOf(" ");
                String newSelect = parts.select.substring(0, idx) + cols + parts.select.substring(star + 1);
                parts.select = newSelect;
            } else {
                Object select = parts.select.trim();
                if (!((String)select).toLowerCase().endsWith("select")) {
                    select = (String)select + ", ";
                }
                parts.select = select = (String)select + cols;
            }
        }
        if (this.getSelect().isDistinct() && !parts.select.toLowerCase().contains("distinct")) {
            int idx = parts.select.toLowerCase().indexOf("select") + 6;
            parts.select = parts.select.substring(0, idx) + " DISTINCT " + parts.select.substring(idx);
        }
        if (this.getPage().isPaginated() && Chain.peek() != null && Chain.peek().get("foundRows") == null && "mysql".equalsIgnoreCase(this.getType()) && parts.select.toLowerCase().trim().startsWith("select")) {
            int idx = parts.select.toLowerCase().indexOf("select") + 6;
            parts.select = parts.select.substring(0, idx) + " SQL_CALC_FOUND_ROWS " + parts.select.substring(idx);
        }
        if (parts.select.trim().endsWith(",")) {
            parts.select = parts.select.trim();
            parts.select = parts.select.substring(0, parts.select.length() - 1) + " ";
        }
        return parts.select;
    }

    protected String printJoins(Parts parts, LinkedHashMap<String, Term> joins) {
        if (joins != null) {
            for (Map.Entry<String, Term> joinTerm : joins.entrySet()) {
                Term join = joinTerm.getValue();
                StringBuilder where = new StringBuilder();
                for (int j = 2; j < join.size(); j += 4) {
                    if (j > 2) {
                        where.append(" AND ");
                    }
                    where.append(this.quoteCol(join.getToken(j))).append(".").append(this.quoteCol(join.getToken(j + 1))).append(" = ").append(this.quoteCol(join.getToken(j + 2))).append(".").append(this.quoteCol(join.getToken(j + 3)));
                }
                if (where == null) continue;
                where = new StringBuilder("(" + where + ")");
                if (Utils.empty((Object[])new Object[]{parts.where})) {
                    parts.where = " WHERE " + where;
                    continue;
                }
                parts.where = parts.where + " AND " + where;
            }
        }
        return parts.where;
    }

    protected String printWhereClause(Parts parts, List<Term> terms, boolean preparedStmt) {
        for (Term term : terms) {
            String where = this.printTerm(term, null, preparedStmt);
            if (where == null) continue;
            if (Utils.empty((Object[])new Object[]{parts.where})) {
                parts.where = " WHERE " + where;
                continue;
            }
            parts.where = parts.where + " AND " + where;
        }
        return parts.where;
    }

    protected String printGroupClause(Parts parts, List<String> groupBy) {
        if (groupBy.size() > 0) {
            StringBuilder group = new StringBuilder(parts.group != null ? parts.group : "GROUP BY ");
            for (String column : groupBy) {
                if (!Utils.endsWith((CharSequence)group, (String)"GROUP BY ")) {
                    group.append(", ");
                }
                group.append(this.printCol(column));
            }
            parts.group = group.toString();
        }
        return parts.group;
    }

    protected String printOrderClause(Parts parts, Order order) {
        List<Order.Sort> sorts = order.getSorts();
        if (sorts.isEmpty()) {
            sorts = this.getDefaultSorts(parts);
            order.withSorts(sorts);
        }
        for (Order.Sort sort : sorts) {
            if (parts.order == null) {
                parts.order = "ORDER BY ";
            }
            if (!parts.order.endsWith("ORDER BY ")) {
                parts.order = parts.order + ", ";
            }
            parts.order = parts.order + this.printCol(sort.getProperty()) + (sort.isAsc() ? " ASC" : " DESC");
        }
        return parts.order;
    }

    protected List<Order.Sort> getDefaultSorts(Parts parts) {
        boolean hasPkCols;
        boolean aggregate;
        ArrayList<Order.Sort> sorts = new ArrayList<Order.Sort>();
        boolean wildcard = false;
        Projection columns = this.getSelect().getProjection();
        if (columns.size() == 1 && columns.containsKey("*")) {
            wildcard = true;
        }
        boolean bl = aggregate = this.getSelect().findAggregateTerms().size() > 0;
        if (aggregate) {
            return sorts;
        }
        boolean bl2 = hasPkCols = this.collection != null && this.collection.getResourceIndex() != null;
        if (this.collection != null) {
            for (String pkCol : this.collection.getResourceIndex().getColumnNames()) {
                if (wildcard || parts.select.contains(this.quoteCol(pkCol))) continue;
                hasPkCols = false;
                break;
            }
            if (hasPkCols) {
                for (String pkCol : this.collection.getResourceIndex().getColumnNames()) {
                    Order.Sort sort = new Order.Sort(pkCol, true);
                    sorts.add(sort);
                }
                return sorts;
            }
        }
        for (String col : this.getSelect().getIncludeColumns()) {
            sorts.add(new Order.Sort(col, true));
        }
        return sorts;
    }

    protected String printLimitClause(Parts parts, int offset, int limit) {
        Object s = null;
        if (limit >= 0 || offset >= 0) {
            if (this.db == null || this.getDb().isType(new String[]{"mysql"})) {
                s = "LIMIT ";
                if (offset > 0) {
                    s = (String)s + offset;
                }
                if (limit >= 0) {
                    if (!((String)s).endsWith("LIMIT ")) {
                        s = (String)s + ", ";
                    }
                    s = (String)s + limit;
                }
            } else if (this.getDb().isType(new String[]{"sqlserver"})) {
                s = "";
                if (offset >= 0) {
                    s = (String)s + " OFFSET " + offset + " ROWS ";
                }
                if (limit >= 0) {
                    s = (String)s + " FETCH NEXT " + limit + " ROWS ONLY ";
                }
            } else {
                s = "";
                if (limit >= 0) {
                    s = (String)s + " LIMIT " + limit;
                }
                if (offset >= 0) {
                    s = (String)s + " OFFSET " + offset;
                }
            }
        }
        parts.limit = s;
        return s;
    }

    protected int queryFoundRows(Connection conn, String sql, List values) throws Exception {
        int foundRows;
        if (this.db.isType(new String[]{"mysql"})) {
            sql = "SELECT FOUND_ROWS()";
            foundRows = (int)JdbcUtils.selectLong((Connection)conn, (String)sql, (Object[])new Object[0]);
        } else {
            if (((String)sql).indexOf("LIMIT ") > 0) {
                sql = ((String)sql).substring(0, ((String)sql).lastIndexOf("LIMIT "));
            }
            if (((String)sql).indexOf("OFFSET ") > 0) {
                sql = ((String)sql).substring(0, ((String)sql).lastIndexOf("OFFSET "));
            }
            if (((String)sql).indexOf("ORDER BY ") > 0) {
                sql = ((String)sql).substring(0, ((String)sql).lastIndexOf("ORDER BY "));
            }
            sql = "SELECT count(1) FROM ( " + (String)sql + " ) as q";
            foundRows = (int)JdbcUtils.selectLong((Connection)conn, (String)sql, (Object[])new Object[]{values});
        }
        return foundRows;
    }

    protected String printTerm(Term term, String col, boolean preparedStmt) {
        if (term.isLeaf()) {
            String token = term.getToken();
            String value = this.isCol(term) ? this.printCol(token) : (this.isBool(term) ? this.asBool(token) : (this.isNum(term) ? this.asNum(token) : this.asString(term)));
            return value;
        }
        for (Object child : term.getTerms()) {
            if (!this.isCol((Term)child)) continue;
            col = ((Term)child).token;
            break;
        }
        ArrayList<String> dynamicSqlChildText = new ArrayList<String>();
        for (Term t : term.getTerms()) {
            dynamicSqlChildText.add(this.printTerm(t, col, preparedStmt));
        }
        ArrayList<String> preparedStmtChildText = new ArrayList<String>(dynamicSqlChildText);
        if (preparedStmt) {
            for (int i = 0; i < term.size(); ++i) {
                String val;
                Term t = term.getTerm(i);
                if (!t.isLeaf() || (val = (String)preparedStmtChildText.get(i)).charAt(0) == this.columnQuote) continue;
                val = Utils.dequote((String)val);
                preparedStmtChildText.set(i, this.replace(term, t, i, col, val));
            }
        }
        return this.printExpression(term, dynamicSqlChildText, preparedStmtChildText);
    }

    protected String printExpression(Term term, List<String> dynamicSqlChildText, List<String> preparedStmtChildText) {
        String token = term.getToken();
        StringBuilder sql = new StringBuilder();
        if (term.hasToken(new String[]{"eq", "ne", "like", "w", "sw", "ew", "wo"})) {
            boolean negation = term.hasToken(new String[]{"ne", "nw", "wo"});
            if (term.size() > 2 || negation) {
                sql.append("(");
            }
            if (negation) {
                sql.append("NOT (");
            }
            String string0 = preparedStmtChildText.get(0);
            for (int i = 1; i < term.size(); ++i) {
                String stringI = preparedStmtChildText.get(i);
                if ("null".equalsIgnoreCase(stringI)) {
                    sql.append(string0).append(" IS NULL ");
                } else {
                    boolean wildcard;
                    boolean bl = wildcard = dynamicSqlChildText.get(i).indexOf(37) >= 0;
                    if (wildcard) {
                        if (this.getDb().isType(new String[]{"h2", "postgres", "redshift"})) {
                            sql.append(string0).append(" ILIKE ").append(stringI);
                        } else {
                            sql.append(string0).append(" LIKE ").append(stringI);
                            if (this.getDb().isType(new String[]{"sqlserver"}) && dynamicSqlChildText.get(i).indexOf(92) >= 0) {
                                sql.append(" {escape '\\'}");
                            }
                        }
                    } else {
                        sql.append(string0).append(" = ").append(stringI);
                    }
                }
                if (i >= term.size() - 1) continue;
                sql.append(" OR ");
            }
            if (term.size() > 2 || negation) {
                sql.append(")");
            }
            if (negation) {
                sql.append(")");
            }
        } else if ("nn".equalsIgnoreCase(token)) {
            sql.append(this.concatAll(" AND ", " IS NOT NULL", preparedStmtChildText));
        } else if ("emp".equalsIgnoreCase(token)) {
            sql.append("(").append(preparedStmtChildText.get(0)).append(" IS NULL OR ").append(preparedStmtChildText.get(0)).append(" = ").append(this.asString("")).append(")");
        } else if ("nemp".equalsIgnoreCase(token)) {
            sql.append("(").append(preparedStmtChildText.get(0)).append(" IS NOT NULL AND ").append(preparedStmtChildText.get(0)).append(" != ").append(this.asString("")).append(")");
        } else if ("n".equalsIgnoreCase(token)) {
            sql.append(this.concatAll(" AND ", " IS NULL", preparedStmtChildText));
        } else if ("lt".equalsIgnoreCase(token)) {
            sql.append(preparedStmtChildText.get(0)).append(" < ").append(preparedStmtChildText.get(1));
        } else if ("le".equalsIgnoreCase(token)) {
            sql.append(preparedStmtChildText.get(0)).append(" <= ").append(preparedStmtChildText.get(1));
        } else if ("gt".equalsIgnoreCase(token)) {
            sql.append(preparedStmtChildText.get(0)).append(" > ").append(preparedStmtChildText.get(1));
        } else if ("ge".equalsIgnoreCase(token)) {
            sql.append(preparedStmtChildText.get(0)).append(" >= ").append(preparedStmtChildText.get(1));
        } else if ("in".equalsIgnoreCase(token) || "out".equalsIgnoreCase(token)) {
            sql.append(preparedStmtChildText.get(0));
            if ("out".equalsIgnoreCase(token)) {
                sql.append(" NOT");
            }
            sql.append(" IN(");
            for (int i = 1; i < preparedStmtChildText.size(); ++i) {
                sql.append(preparedStmtChildText.get(i));
                if (i >= preparedStmtChildText.size() - 1) continue;
                sql.append(", ");
            }
            sql.append(")");
        } else if ("if".equalsIgnoreCase(token)) {
            if (this.db == null || this.db.isType(new String[]{"mysql"})) {
                sql.append("IF(").append(preparedStmtChildText.get(0)).append(", ").append(preparedStmtChildText.get(1)).append(", ").append(preparedStmtChildText.get(2)).append(")");
            } else {
                sql.append("CASE WHEN ").append(preparedStmtChildText.get(0)).append(" THEN ").append(preparedStmtChildText.get(1)).append(" ELSE ").append(preparedStmtChildText.get(2)).append(" END");
            }
        } else if ("and".equalsIgnoreCase(token) || "or".equalsIgnoreCase(token)) {
            sql.append("(");
            for (int i = 0; i < preparedStmtChildText.size(); ++i) {
                sql.append(preparedStmtChildText.get(i).trim());
                if (i >= preparedStmtChildText.size() - 1) continue;
                sql.append(" ").append(token.toUpperCase()).append(" ");
            }
            sql.append(")");
        } else if ("not".equalsIgnoreCase(token)) {
            sql.append("NOT (");
            for (int i = 0; i < preparedStmtChildText.size(); ++i) {
                sql.append(preparedStmtChildText.get(i).trim());
                if (i >= preparedStmtChildText.size() - 1) continue;
                sql.append(" ");
            }
            sql.append(")");
        } else if ("count".equalsIgnoreCase(token)) {
            String acol;
            String pt = this.printTableAlias() + ".*";
            if (pt.equals(acol = preparedStmtChildText.get(0))) {
                acol = "*";
            }
            String s = token.toUpperCase() + "(" + acol + ")";
            sql.append(s);
        } else if (!"distinct".equalsIgnoreCase(token)) {
            if ("sum".equalsIgnoreCase(token) || "min".equalsIgnoreCase(token) || "max".equalsIgnoreCase(token)) {
                String acol = preparedStmtChildText.get(0);
                String s = token.toUpperCase() + "(" + acol + ")";
                sql.append(s);
            } else if (Utils.in((Object)token.toLowerCase(), (Object[])new Object[]{"_exists", "_notexists"})) {
                if ("_notexists".equalsIgnoreCase(token)) {
                    sql.append("NOT ");
                }
                sql.append("EXISTS (SELECT 1 FROM ");
                String relName = term.getTerm(0).getTerm(0).getToken();
                relName = relName.substring(0, relName.indexOf("."));
                relName = relName.substring(relName.indexOf("_") + 1);
                Relationship rel = this.collection.getRelationship(relName);
                if (rel == null) {
                    throw ApiException.new400BadRequest((String)"Unable to find relationship for term '{}'", (Object[])new Object[]{term});
                }
                String relTbl = rel.getRelated().getTableName();
                String relAlias = "~~relTbl_" + relTbl;
                String lnkTbl = rel.getFk1Col1().getCollection().getTableName();
                String lnkAlias = "~~lnkTbl_" + lnkTbl;
                sql.append(this.quoteCol(relTbl)).append(" ").append(this.quoteCol(relAlias));
                if (rel.isManyToMany()) {
                    sql.append(", ").append(this.quoteCol(lnkTbl)).append(" ").append(this.quoteCol(lnkAlias));
                }
                sql.append(" WHERE ");
                Index fk1 = rel.getFkIndex1();
                if (rel.isManyToOne()) {
                    for (int i = 0; i < fk1.size(); ++i) {
                        Property prop = fk1.getProperty(i);
                        pkName = prop.getPk().getColumnName();
                        fkName = prop.getColumnName();
                        sql.append(this.printTableAlias()).append(".").append(this.quoteCol(fkName)).append(" = ").append(this.quoteCol(relAlias)).append(".").append(this.quoteCol(pkName));
                        if (i >= fk1.size() - 1) continue;
                        sql.append(" AND ");
                    }
                } else if (rel.isOneToMany()) {
                    for (int i = 0; i < fk1.size(); ++i) {
                        Property prop = fk1.getProperty(i);
                        pkName = prop.getPk().getColumnName();
                        fkName = prop.getColumnName();
                        sql.append(this.printTableAlias()).append(".").append(this.quoteCol(pkName)).append(" = ").append(this.quoteCol(relAlias)).append(".").append(this.quoteCol(fkName));
                        if (i >= fk1.size() - 1) continue;
                        sql.append(" AND ");
                    }
                } else if (rel.isManyToMany()) {
                    for (int i = 0; i < fk1.size(); ++i) {
                        Property prop = fk1.getProperty(i);
                        pkName = prop.getPk().getColumnName();
                        fkName = prop.getColumnName();
                        sql.append(this.printTableAlias()).append(".").append(this.quoteCol(pkName)).append(" = ").append(this.quoteCol(lnkAlias)).append(".").append(this.quoteCol(fkName));
                        sql.append(" AND ");
                    }
                    Index fk2 = rel.getFkIndex2();
                    for (int i = 0; i < fk2.size(); ++i) {
                        Property prop = fk2.getProperty(i);
                        String pkName = prop.getPk().getColumnName();
                        String fkName = prop.getColumnName();
                        sql.append(this.quoteCol(lnkAlias)).append(".").append(this.quoteCol(fkName)).append(" = ").append(this.quoteCol(relAlias)).append(".").append(this.quoteCol(pkName));
                        if (i >= fk2.size() - 1) continue;
                        sql.append(" AND ");
                    }
                }
                sql.append(" AND ");
                for (int i = 0; i < preparedStmtChildText.size(); ++i) {
                    sql.append(preparedStmtChildText.get(i));
                    if (i >= preparedStmtChildText.size() - 1) continue;
                    sql.append(" AND ");
                }
                sql.append(")");
            } else if ("miles".equalsIgnoreCase(token)) {
                sql.append("point(").append(preparedStmtChildText.get(0)).append(",").append(preparedStmtChildText.get(1)).append(") <@> point(").append(preparedStmtChildText.get(2)).append(",").append(preparedStmtChildText.get(3)).append(")");
            } else {
                throw new RuntimeException("Unable to parse: " + term);
            }
        }
        return sql.toString();
    }

    protected String replace(Term parent, Term leaf, int index, String col, String val) {
        if (val == null || val.trim().equalsIgnoreCase("null")) {
            return "NULL";
        }
        if (parent.hasToken(new String[]{"if"}) && index > 0) {
            if (this.isBool(leaf)) {
                return this.asBool(val);
            }
            if (this.isNum(leaf)) {
                return val;
            }
        }
        this.withColValue(col, val);
        return this.asVariableName(this.castValues.size() - 1);
    }

    protected String concatAll(String connector, String function, List strings) {
        StringBuilder buff = new StringBuilder(strings.size() > 1 ? "(" : "");
        for (int i = 0; i < strings.size(); ++i) {
            buff.append(strings.get(i)).append(function);
            if (i >= strings.size() - 1) continue;
            buff.append(connector);
        }
        if (strings.size() > 1) {
            buff.append(")");
        }
        return buff.toString();
    }

    protected boolean isCol(Term term) {
        if (!term.isLeaf()) {
            return false;
        }
        if (term.getQuote() == '\"') {
            return true;
        }
        if (term.getQuote() == '\'') {
            return false;
        }
        if (this.isBool(term)) {
            return false;
        }
        if (this.isNum(term)) {
            return false;
        }
        if (this.collection != null && this.collection.getProperty(term.getToken()) != null) {
            return true;
        }
        return term.getParent() != null && term.getParent().indexOf(term) == 0;
    }

    public String quoteCol(String str) {
        StringBuilder buff = new StringBuilder();
        String[] parts = str.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            if ("*".equals(parts[i])) {
                buff.append(parts[i]);
            } else {
                if (parts[i].startsWith("~~relTbl_")) {
                    String relName = parts[i];
                    Relationship rel = this.collection.getRelationship(relName = relName.substring(relName.indexOf("_") + 1));
                    if (rel != null) {
                        parts[i] = "~~relTbl_" + rel.getRelated().getTableName();
                    }
                }
                buff.append(this.columnQuote).append(parts[i]).append(this.columnQuote);
            }
            if (i >= parts.length - 1) continue;
            buff.append(".");
        }
        return buff.toString();
    }

    public String printTableAlias() {
        String tableName = this.getFrom().getAlias();
        if (tableName != null) {
            return this.quoteCol(tableName);
        }
        throw new ApiException("Unable to determine table name or alias.", new Object[0]);
    }

    public String printCol(String columnName) {
        if (!columnName.contains(".")) {
            return this.printTableAlias() + "." + this.quoteCol(columnName);
        }
        return this.quoteCol(columnName);
    }

    protected String asVariableName(int valuesPairIdx) {
        return "?";
    }

    protected String asString(String string) {
        return this.stringQuote + string + this.stringQuote;
    }

    protected String asString(Term term) {
        Object token = term.token;
        Term parent = term.getParent();
        if (parent != null && parent.hasToken(new String[]{"eq", "ne", "w", "sw", "ew", "like", "wo"})) {
            boolean wildcard;
            if (parent.hasToken(new String[]{"w"}) || parent.hasToken(new String[]{"wo"})) {
                if (!((String)token).startsWith("*")) {
                    token = "*" + (String)token;
                }
                if (!((String)token).endsWith("*")) {
                    token = (String)token + "*";
                }
            } else if (parent.hasToken(new String[]{"sw"}) && !((String)token).endsWith("*")) {
                token = (String)token + "*";
            } else if (parent.hasToken(new String[]{"ew"}) && !((String)token).startsWith("*")) {
                token = "*" + (String)token;
            }
            boolean bl = wildcard = ((String)token).indexOf(42) >= 0;
            if (wildcard) {
                token = ((String)token).replace("%", "\\%");
                token = ((String)token).replace("_", "\\_");
                token = ((String)token).replace('*', '%');
            }
        }
        return this.stringQuote + (String)token + this.stringQuote;
    }

    protected String asNum(String token) {
        if ("true".equalsIgnoreCase(token)) {
            return "1";
        }
        if ("false".equalsIgnoreCase(token)) {
            return "0";
        }
        return token;
    }

    protected boolean isNum(Term term) {
        if (!term.isLeaf() || term.isQuoted()) {
            return false;
        }
        String token = term.getToken();
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (Exception exception) {
            if ("true".equalsIgnoreCase(token)) {
                return true;
            }
            if ("false".equalsIgnoreCase(token)) {
                return true;
            }
            return "null".equalsIgnoreCase(token);
        }
    }

    protected boolean isBool(Term term) {
        if (!term.isLeaf() || term.isQuoted()) {
            return false;
        }
        String token = term.getToken();
        if ("true".equalsIgnoreCase(token)) {
            return true;
        }
        return "false".equalsIgnoreCase(token);
    }

    public String asBool(String token) {
        if ("true".equalsIgnoreCase(token) || "1".equals(token)) {
            return "true";
        }
        return "false";
    }

    public SqlQuery withDb(D db) {
        super.withDb(db);
        if (db.isType(new String[]{"mysql"})) {
            this.withColumnQuote('`');
        }
        return this;
    }

    public SqlQuery withType(String type) {
        this.type = type;
        return this;
    }

    public String getType() {
        if (this.db != null) {
            return this.db.getType();
        }
        return this.type;
    }

    public void withStringQuote(char stringQuote) {
        this.stringQuote = stringQuote;
    }

    public void withColumnQuote(char columnQuote) {
        this.columnQuote = columnQuote;
    }

    public static class Parts {
        public String select = null;
        public String from = null;
        public String where = null;
        public String group = null;
        public String order = null;
        public String limit = null;
        public List<Term> orderByTerms = new ArrayList<Term>();

        void withSql(String sql) {
            String clause;
            if (sql == null) {
                return;
            }
            sql = sql.trim();
            SqlTokenizer tok = new SqlTokenizer(sql);
            block17: while ((clause = tok.nextClause()) != null) {
                String token;
                switch (token = (clause.indexOf(" ") > 0 ? clause.substring(0, clause.indexOf(" ")) : clause).toLowerCase()) {
                    case "delete": 
                    case "select": {
                        this.select = clause;
                        continue block17;
                    }
                    case "from": {
                        this.from = clause;
                        continue block17;
                    }
                    case "where": {
                        this.where = clause;
                        continue block17;
                    }
                    case "group": {
                        this.group = clause;
                        continue block17;
                    }
                    case "order": {
                        this.order = clause;
                        continue block17;
                    }
                    case "limit": {
                        this.limit = clause;
                        continue block17;
                    }
                }
                throw new RuntimeException("Unable to parse: \"" + clause + "\" - \"" + sql + "\"");
            }
        }
    }
}

