/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.jdbc;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Property;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Results;
import io.inversion.jdbc.JdbcConnectionLocal;
import io.inversion.jdbc.SqlQuery;
import io.inversion.rql.Term;
import io.inversion.utils.JdbcUtils;
import io.inversion.utils.Utils;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDb
extends Db<JdbcDb> {
    static final Map<String, String> DEFAULT_DRIVERS = new HashMap<String, String>();
    static final Map<Db, DataSource> pools = new Hashtable<Db, DataSource>();
    protected final List<String> ddlUrls = new ArrayList<String>();
    protected char stringQuote = (char)39;
    protected char columnQuote = (char)34;
    protected String driver = null;
    protected String url = null;
    protected String user = null;
    protected String pass = null;
    protected int poolMax = 50;
    protected int idleConnectionTestPeriod = 3600;
    protected boolean autoCommit = false;
    protected boolean calcRowsFound = true;

    public JdbcDb() {
    }

    public JdbcDb(String name) {
        this.withName(name);
    }

    public JdbcDb(String name, String driver, String url, String user, String pass, String ... ddlUrls) {
        this.withName(name);
        this.withDriver(driver);
        this.withUrl(url);
        this.withUser(user);
        this.withPass(pass);
        this.withDdlUrl(ddlUrls);
    }

    public JdbcDb(String url, String user, String pass) {
        this.withUrl(url);
        this.withUser(user);
        this.withPass(pass);
    }

    protected void doStartup(Api api) {
        if (this.isType(new String[]{"mysql"})) {
            this.withColumnQuote('`');
        }
        super.doStartup(api);
        api.withApiListener(new Api.ApiListener(){

            public void onAfterRequest(Request req, Response res) {
                try {
                    JdbcConnectionLocal.commit();
                }
                catch (Exception ex) {
                    throw ApiException.new500InternalServerError((Throwable)ex, (String)"Error committing tansaction", (Object[])new Object[0]);
                }
            }

            public void onAfterError(Request req, Response res) {
                try {
                    JdbcConnectionLocal.rollback();
                }
                catch (Throwable t) {
                    JdbcDb.this.log.warn("Error rollowing back transaction.", t);
                }
            }

            public void onBeforeFinally(Request req, Response res) {
                try {
                    JdbcConnectionLocal.close();
                }
                catch (Throwable t) {
                    JdbcDb.this.log.warn("Error closing connections.", t);
                }
            }
        });
    }

    protected void doShutdown() {
        DataSource pool;
        if (this.isType(new String[]{"h2"}) && this.getUrl() != null) {
            try {
                String url = this.getUrl().toUpperCase();
                if (url.indexOf("MEM:") > 0 && url.indexOf("DB_CLOSE_DELAY=-1") > 0) {
                    JdbcUtils.execute((Connection)this.getConnection(), (String)"SHUTDOWN", (Object[])new Object[0]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((pool = pools.get((Object)this)) != null) {
            System.out.println("CLOSING CONNECTION POOL : " + this.getUrl());
            ((HikariDataSource)pool).close();
        }
    }

    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        String url = this.getUrl();
        String string = url = url != null ? url : this.getDriver();
        if (url != null) {
            if (url.contains("mysql")) {
                return "mysql";
            }
            if (url.contains("postgres")) {
                return "postgres";
            }
            if (url.contains("redshift")) {
                return "redshift";
            }
            if (url.contains("sqlserver")) {
                return "sqlserver";
            }
            if (url.contains("h2")) {
                return "h2";
            }
        }
        this.log.warn("Unable to determine db type. type='{}', driver='{}', url='{}'", new Object[]{this.type, this.driver, this.url});
        if (Chain.peek() != null) {
            Chain.peek().getResponse().debug("Unable to determine db type. type='{}', driver='{}', url='{}'", new Object[]{this.type, this.driver, this.url});
        }
        return "UNKNOWN";
    }

    public Results doSelect(Collection coll, List<Term> columnMappedTerms) throws ApiException {
        SqlQuery<JdbcDb> query = new SqlQuery<JdbcDb>(this, coll, columnMappedTerms);
        return query.doSelect();
    }

    public List<String> doUpsert(Collection table, List<Map<String, Object>> rows) throws ApiException {
        try {
            for (Map<String, Object> row : rows) {
                for (String key : new ArrayList<String>(row.keySet())) {
                    if (table.getPropertyByColumnName(key) != null) continue;
                    row.remove(key);
                }
            }
            List upserted = JdbcUtils.upsert((Connection)this.getConnection(), (String)table.getTableName(), (List)table.getResourceIndex().getColumnNames(), rows);
            return upserted.stream().map(arg_0 -> ((Collection)table).encodeKeyFromColumnNames(arg_0)).collect(Collectors.toList());
        }
        catch (Exception ex) {
            throw ApiException.new500InternalServerError((Throwable)ex);
        }
    }

    public List<String> doPatch(Collection table, List<Map<String, Object>> rows) throws ApiException {
        try {
            for (Map<String, Object> row : rows) {
                for (String key : new ArrayList<String>(row.keySet())) {
                    if (table.getPropertyByColumnName(key) != null) continue;
                    row.remove(key);
                }
            }
            ArrayList<String> resourceKeys = new ArrayList<String>();
            List updateCounts = JdbcUtils.update((Connection)this.getConnection(), (String)table.getTableName(), (List)table.getResourceIndex().getColumnNames(), rows);
            for (int i = 0; i < rows.size(); ++i) {
                Integer count = (Integer)updateCounts.get(i);
                if (count == null) {
                    count = 0;
                }
                if (count <= 0) continue;
                if (count == 1) {
                    resourceKeys.add(table.encodeKeyFromColumnNames(rows.get(i)));
                    continue;
                }
                throw new ApiException("A patch requested reported that it updated more than one row", new Object[0]);
            }
            return resourceKeys;
        }
        catch (Exception ex) {
            throw ApiException.new500InternalServerError((Throwable)ex);
        }
    }

    public void doDelete(Collection table, List<Map<String, Object>> columnMappedIndexValues) throws ApiException {
        try {
            if (columnMappedIndexValues.size() == 0) {
                return;
            }
            Map<String, Object> firstRow = columnMappedIndexValues.get(0);
            if (firstRow.size() == 1) {
                String keyCol = firstRow.keySet().iterator().next();
                ArrayList<Object> values = new ArrayList<Object>();
                for (Map<String, Object> resourceKey : columnMappedIndexValues) {
                    values.add(resourceKey.values().iterator().next());
                }
                Object sql = "";
                sql = (String)sql + " DELETE FROM " + this.quoteCol(table.getTableName());
                sql = (String)sql + " WHERE " + this.quoteCol(keyCol) + " IN (" + JdbcUtils.getQuestionMarkStr((int)columnMappedIndexValues.size()) + ")";
                JdbcUtils.execute((Connection)this.getConnection(), (String)sql, (Object[])values.toArray());
            } else {
                StringBuilder sql = new StringBuilder();
                sql.append(" DELETE FROM ").append(this.quoteCol(table.getTableName()));
                sql.append(" WHERE ");
                ArrayList<Object> values = new ArrayList<Object>();
                for (Map<String, Object> resourceKey : columnMappedIndexValues) {
                    if (values.size() > 0) {
                        sql.append(" OR ");
                    }
                    sql.append("(");
                    int i = 0;
                    for (String key : resourceKey.keySet()) {
                        if (++i > 1) {
                            sql.append("AND ");
                        }
                        sql.append(this.quoteCol(key)).append(" = ? ");
                        values.add(resourceKey.get(key));
                    }
                    sql.append(")");
                }
                JdbcUtils.execute((Connection)this.getConnection(), (String)sql.toString(), (Object[])values.toArray());
            }
        }
        catch (Exception ex) {
            throw ApiException.new500InternalServerError((Throwable)ex);
        }
    }

    public Connection getConnection() throws ApiException {
        return this.getConnection(true);
    }

    public Connection getConnection(boolean managed) throws ApiException {
        return this.getConnection0(managed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection0(boolean managed) throws ApiException {
        try {
            Connection conn;
            Connection connection = conn = !managed ? null : JdbcConnectionLocal.getConnection(this);
            if (conn == null) {
                DataSource pool = pools.get((Object)this);
                if (pool == null) {
                    JdbcDb jdbcDb = this;
                    synchronized (jdbcDb) {
                        pool = pools.get((Object)this);
                        if (pool == null) {
                            pool = this.createConnectionPool();
                        }
                        pools.put(this, pool);
                    }
                }
                conn = pool.getConnection();
                if (managed) {
                    conn.setAutoCommit(this.isAutoCommit());
                    JdbcConnectionLocal.putConnection(this, conn);
                }
            }
            return conn;
        }
        catch (Exception ex) {
            throw ApiException.new500InternalServerError((Throwable)ex, (String)"Unable to get DB connection", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected DataSource createConnectionPool() throws Exception {
        if (this.ddlUrls.size() > 0) {
            String driver = this.getDriver();
            if (driver != null) {
                Class.forName(driver);
            }
            Connection conn = null;
            try {
                String url = this.getUrl();
                conn = DriverManager.getConnection(url, this.getUser(), this.getPass());
                conn.setAutoCommit(false);
                for (String string : this.ddlUrls) {
                    void var5_6;
                    if (Utils.empty((Object[])new Object[]{string})) continue;
                    if (!string.contains(":/")) {
                        String string2 = "" + ((Object)((Object)this)).getClass().getClassLoader().getResource(string);
                    }
                    JdbcUtils.runSql((Connection)conn, (InputStream)new URL((String)var5_6).openStream());
                }
                conn.commit();
            }
            catch (Exception ex) {
                try {
                    this.log.warn("Error initializing db with supplied ddl.", (Throwable)ex);
                    if (conn != null) {
                        conn.rollback();
                    }
                    throw ex;
                }
                catch (Throwable throwable) {
                    JdbcUtils.close((Object[])new Object[]{conn});
                    throw throwable;
                }
            }
            JdbcUtils.close((Object[])new Object[]{conn});
        }
        HikariConfig config = new HikariConfig();
        String driver = this.getDriver();
        config.setDriverClassName(driver);
        config.setJdbcUrl(this.getUrl());
        config.setUsername(this.getUser());
        config.setPassword(this.getPass());
        config.setMaximumPoolSize(this.getPoolMax());
        if (this.isType(new String[]{"mysql"})) {
            config.setConnectionInitSql("SET @@SESSION.sql_mode= 'NO_ENGINE_SUBSTITUTION'");
        } else if (this.isType(new String[]{"sqlserver"})) {
            // empty if block
        }
        return new HikariDataSource(config);
    }

    public void buildCollections() throws ApiException {
        ResultSet rs;
        block22: {
            rs = null;
            if (this.isBootstrap()) break block22;
            Utils.close((Object[])new Object[]{rs});
            return;
        }
        try {
            Connection conn = this.getConnection();
            DatabaseMetaData dbmd = conn.getMetaData();
            HashMap<CallSite, String> types = new HashMap<CallSite, String>();
            for (Field field : Types.class.getFields()) {
                types.put((CallSite)((Object)("" + field.get(null))), field.getName());
            }
            ArrayList schemaGuesses = Utils.asList((Object[])new Object[]{"public", null});
            if (this.isType(new String[]{"sqlserver"})) {
                schemaGuesses.add(0, "dbo");
                String schema = this.getUrl();
                int idx = schema.toLowerCase().indexOf("databasename=");
                if (idx > -1) {
                    idx += "databasename=".length();
                }
                if (idx == -1 && (idx = schema.toLowerCase().indexOf("database=")) > -1) {
                    idx += "database=".length();
                }
                if (idx > 0) {
                    schema = schema.substring(idx);
                    schema = Utils.substringBefore((String)schema, (String)";");
                    schema = Utils.substringBefore((String)schema, (String)"&");
                    schemaGuesses.add(0, schema);
                }
            }
            boolean hasNext = false;
            for (String schema : schemaGuesses) {
                rs = dbmd.getTables(conn.getCatalog(), schema, "%", new String[]{"TABLE", "VIEW"});
                hasNext = rs.next();
                if (!hasNext) continue;
                break;
            }
            if (hasNext) {
                do {
                    Property column;
                    String tableCat = rs.getString("TABLE_CAT");
                    String tableSchem = rs.getString("TABLE_SCHEM");
                    String tableName = rs.getString("TABLE_NAME");
                    if (tableSchem.equalsIgnoreCase("sys") || tableSchem.equalsIgnoreCase("INFORMATION_SCHEMA") || this.excludeTable(tableName)) continue;
                    Collection collection = new Collection(tableName);
                    this.withCollection(collection);
                    ResultSet colsRs = dbmd.getColumns(tableCat, tableSchem, tableName, "%");
                    while (colsRs.next()) {
                        String colName = colsRs.getString("COLUMN_NAME");
                        String type = colsRs.getString("DATA_TYPE");
                        String colType = (String)types.get(type);
                        boolean nullable = colsRs.getInt("NULLABLE") == 1;
                        boolean autoincrement = Utils.in((Object)("" + colsRs.getObject("IS_AUTOINCREMENT")).toLowerCase(), (Object[])new Object[]{"yes", "true", "1"});
                        column = new Property(colName, colType, nullable);
                        if (autoincrement) {
                            column.withReadOnly(true);
                        }
                        collection.withProperties(new Property[]{column});
                    }
                    colsRs.close();
                    ResultSet indexMd = dbmd.getIndexInfo(conn.getCatalog(), null, tableName, false, false);
                    while (indexMd.next()) {
                        String idxName = indexMd.getString("INDEX_NAME");
                        String idxType = "INDEX";
                        String colName = indexMd.getString("COLUMN_NAME");
                        if (idxName == null || colName == null) continue;
                        int keySeq = indexMd.getInt("ORDINAL_POSITION");
                        String nonUnique = "" + indexMd.getObject("NON_UNIQUE");
                        boolean unique = !nonUnique.equals("true") && !nonUnique.equals("1");
                        collection.withIndex(idxName, idxType, unique, keySeq, colName);
                    }
                    indexMd.close();
                    ResultSet pkMd = dbmd.getPrimaryKeys(conn.getCatalog(), null, tableName);
                    while (pkMd.next()) {
                        String idxName = pkMd.getString("PK_NAME");
                        String idxType = "PRIMARY_KEY";
                        String colName = pkMd.getString("COLUMN_NAME");
                        column = collection.getProperty(colName);
                        int keySeq = pkMd.getInt("KEY_SEQ");
                        collection.withIndex(idxName, idxType, true, keySeq, colName);
                    }
                    pkMd.close();
                } while (rs.next());
            }
            if (rs != null) {
                rs.close();
            }
            if (!(hasNext = (rs = dbmd.getTables(conn.getCatalog(), "public", "%", new String[]{"TABLE"})).next())) {
                rs = dbmd.getTables(conn.getCatalog(), null, "%", new String[]{"TABLE"});
                hasNext = rs.next();
            }
            if (hasNext) {
                do {
                    String tableName;
                    if (this.excludeTable(tableName = rs.getString("TABLE_NAME"))) continue;
                    ResultSet keyMd = dbmd.getImportedKeys(conn.getCatalog(), null, tableName);
                    while (keyMd.next()) {
                        String fkName = keyMd.getString("FK_NAME");
                        String fkTableName = keyMd.getString("FKTABLE_NAME");
                        Collection coll = this.getCollectionByTableName(fkTableName);
                        if (coll == null) continue;
                        String fkColumnName = keyMd.getString("FKCOLUMN_NAME");
                        String pkTableName = keyMd.getString("PKTABLE_NAME");
                        String pkColumnName = keyMd.getString("PKCOLUMN_NAME");
                        Property fk = this.getProperty(fkTableName, fkColumnName);
                        Property pk = this.getProperty(pkTableName, pkColumnName);
                        fk.withPk(pk);
                        coll.withIndex(fkName, "FOREIGN_KEY", false, new String[]{fk.getColumnName()});
                    }
                    keyMd.close();
                } while (rs.next());
            }
            rs.close();
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                throw ApiException.new500InternalServerError((Throwable)ex);
            }
            catch (Throwable throwable) {
                Utils.close((Object[])new Object[]{rs});
                throw throwable;
            }
        }
        Utils.close((Object[])new Object[]{rs});
        super.buildCollections();
    }

    public JdbcDb withType(String type) {
        if ("mysql".equals(type)) {
            this.withStringQuote('`');
        }
        return (JdbcDb)super.withType(type);
    }

    public JdbcDb withConfig(String driver, String url, String user, String pass) {
        this.withDriver(driver);
        this.withUrl(url);
        this.withUser(user);
        this.withPass(pass);
        return this;
    }

    public String getDriver() {
        if (this.driver == null && this.url != null) {
            return DEFAULT_DRIVERS.get(this.getType());
        }
        return this.driver;
    }

    public JdbcDb withDriver(String driver) {
        this.driver = driver;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public JdbcDb withUrl(String url) {
        this.url = url;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public JdbcDb withUser(String user) {
        this.user = user;
        return this;
    }

    public String getPass() {
        return this.pass;
    }

    public JdbcDb withPass(String pass) {
        this.pass = pass;
        return this;
    }

    public int getPoolMax() {
        return this.poolMax;
    }

    public void setPoolMax(int poolMax) {
        this.poolMax = poolMax;
    }

    public int getIdleConnectionTestPeriod() {
        return this.idleConnectionTestPeriod;
    }

    public void setIdleConnectionTestPeriod(int idleConnectionTestPeriod) {
        this.idleConnectionTestPeriod = idleConnectionTestPeriod;
    }

    public JdbcDb withStringQuote(char stringQuote) {
        this.stringQuote = stringQuote;
        return this;
    }

    public JdbcDb withColumnQuote(char columnQuote) {
        this.columnQuote = columnQuote;
        return this;
    }

    public String quoteCol(String columnName) {
        return this.columnQuote + columnName + this.columnQuote;
    }

    public String quoteStr(String string) {
        return this.stringQuote + string + this.stringQuote;
    }

    public JdbcDb withDdlUrl(String ... ddlUrl) {
        for (int i = 0; ddlUrl != null && i < ddlUrl.length; ++i) {
            this.ddlUrls.add(ddlUrl[i]);
        }
        return this;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public JdbcDb withAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    static {
        DEFAULT_DRIVERS.put("h2", "org.h2.Driver");
        DEFAULT_DRIVERS.put("mysql", "com.mysql.cj.jdbc.Driver");
        DEFAULT_DRIVERS.put("postgres", "org.postgresql.Driver");
        DEFAULT_DRIVERS.put("sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        JdbcUtils.addSqlListener((JdbcUtils.SqlListener)new JdbcUtils.SqlListener(){
            Logger log = LoggerFactory.getLogger((String)JdbcDb.class.getName());

            public void onError(String method, String sql, Object args, Exception ex) {
                if (method != null && method.equals("selectRows")) {
                    this.log.error("SQL error in '" + method + "' [" + sql.replace("\r\n", "") + "] " + ex.getMessage());
                } else {
                    this.log.error("SQL error in '" + method + "' [" + sql.replace("\r\n", "") + "] " + ex.getMessage());
                }
            }

            public void beforeStmt(String method, String sql, Object args) {
            }

            public void afterStmt(String method, String sql, Object args, Exception ex, Object result) {
                Collection coll;
                Object debugPrefix = "JdbcDb: ";
                String debugType = "unknown";
                if (Chain.peek() != null && (coll = Chain.top().getRequest().getCollection()) != null && coll.getDb() != null) {
                    Db db = coll.getDb();
                    debugType = db.getType().toLowerCase();
                }
                debugPrefix = (String)debugPrefix + debugType;
                args = args != null && args.getClass().isArray() ? Arrays.asList((Object[])args) : args;
                sql = sql.replaceAll("\r", "");
                sql = sql.replaceAll("\n", " ");
                sql = sql.trim().replaceAll(" +", " ");
                StringBuilder buff = new StringBuilder();
                buff.append((String)debugPrefix).append(" -> '").append(sql).append("'").append(" args=").append(args).append(" error='").append(ex != null ? ex.getMessage() : "").append("'");
                String msg = buff.toString();
                Chain.debug((String)msg, (Object[])new Object[0]);
            }
        });
    }
}

