/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.client;

import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Url;
import io.inversion.json.JSNode;
import io.inversion.utils.ListMap;
import io.inversion.utils.Path;
import io.inversion.utils.StreamBuffer;
import io.inversion.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;

public class ApiClient {
    static final Log log = LogFactory.getLog(ApiClient.class);
    protected final ListMap<String, String> forcedHeaders = new ListMap();
    protected final List<RequestListener> requestListeners = new ArrayList<RequestListener>();
    protected final List<Consumer<Response>> responseListeners = new ArrayList<Consumer<Response>>();
    protected String name = null;
    protected String url = null;
    protected boolean forwardHeaders = true;
    protected final Set includeForwardHeaders = (Set)Utils.add(new TreeSet(String.CASE_INSENSITIVE_ORDER), (Object[])new Object[]{"authorization", "cookie", "x-forwarded-for", "x-forwarded-host", " x-forwarded-proto", "x-request-id", "x-correlation-id", "traceparent", "request-id", "trace-id", "x-ms-request-id", "x-ms-request-root-id", "request-context", "X-Amzn-Trace-Id"});
    protected final Set excludeForwardHeaders = (Set)Utils.add(new TreeSet(String.CASE_INSENSITIVE_ORDER), (Object[])new Object[]{"content-length", "content-type", "content-encoding", "content-language", "content-location", "content-md5", "host"});
    protected boolean forwardParams = false;
    protected final Set<String> includeParams = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    protected final Set<String> excludeParams = (Set)Utils.add(new TreeSet(String.CASE_INSENSITIVE_ORDER), (Object[])new Object[]{"explain"});
    protected boolean useCompression = true;
    protected int compressionMinSize = 1024;
    protected long maxMemoryBuffer = 102400L;
    protected Executor executor = null;
    protected int threadsMax = 5;
    protected int socketTimeout = 30000;
    protected int connectTimeout = 30000;
    protected int connectionRequestTimeout = 30000;
    public int maxConPerRoute = 10;
    public int maxConTotal = 50;
    public boolean evictExpiredConnections = true;
    public int evictIdleConnectionsAfterTimeMillis = -1;
    protected HttpClientBuilder httpClientBuilder = null;
    protected HttpClient httpClient = null;

    public ApiClient() {
    }

    public ApiClient(String name) {
        this();
        this.withName(name);
    }

    public FutureResponse get(String fullUrlOrRelativePath) {
        return this.get(fullUrlOrRelativePath, (String)null);
    }

    public FutureResponse get(String fullUrlOrRelativePath, String queryString) {
        return this.call("GET", fullUrlOrRelativePath, Utils.parseQueryString((String)queryString), null, null);
    }

    public FutureResponse get(String fullUrlOrRelativePath, Map<String, String> params) {
        return this.call("GET", fullUrlOrRelativePath, params, null, null);
    }

    public FutureResponse get(String fullUrlOrRelativePath, String ... queryStringNameValuePairs) {
        return this.call("GET", fullUrlOrRelativePath, Utils.addToMap(new HashMap(), (Object[])queryStringNameValuePairs), null, null);
    }

    public FutureResponse post(String fullUrlOrRelativePath, Object body) {
        return this.call("POST", fullUrlOrRelativePath, null, body, null);
    }

    public FutureResponse put(String fullUrlOrRelativePath, Object body) {
        return this.call("PUT", fullUrlOrRelativePath, null, body, null);
    }

    public FutureResponse patch(String fullUrlOrRelativePath, Object body) {
        return this.call("PATCH", fullUrlOrRelativePath, null, body, null);
    }

    public FutureResponse delete(String fullUrlOrRelativePath) {
        return this.call("DELETE", fullUrlOrRelativePath, null, null, null);
    }

    public FutureResponse call(String method, String fullUrlOrRelativePath, Map<String, String> params, Object body, ListMap<String, String> headers) {
        Request request = this.buildRequest(method, fullUrlOrRelativePath, params, body, headers);
        return this.call(request);
    }

    public FutureResponse call(Request request) {
        FutureResponse future = this.buildFuture(request);
        if (this.threadsMax < 1) {
            future.run();
        } else {
            this.submit(future);
        }
        return future;
    }

    public Request buildRequest(String method, String fullUrlOrRelativePath, Map<String, String> params, Object body, ListMap<String, String> headers) {
        Map origionalParams;
        Request originalInboundRequest;
        Object chain;
        String url = this.buildUrl(fullUrlOrRelativePath);
        String queryString = Utils.substringAfter((String)url, (String)"?");
        if (!Utils.empty((Object[])new Object[]{queryString})) {
            url = Utils.substringBefore((String)url, (String)"?");
            LinkedHashMap newParams = Utils.parseQueryString((String)queryString);
            if (params != null) {
                newParams.putAll(params);
            }
            params = newParams;
        }
        String bodyStr = null;
        if (body != null) {
            if (body instanceof String) {
                bodyStr = (String)body;
            }
            if (body instanceof JSNode) {
                bodyStr = ((JSNode)body).toString();
            } else {
                body = bodyStr;
            }
        }
        Request request = new Request(method, url, body == null ? null : body.toString(), (Map)params, headers);
        if (this.forwardHeaders && (chain = Chain.first()) != null) {
            originalInboundRequest = chain.getRequest();
            for (String key : originalInboundRequest.getHeaders().keySet()) {
                if (!this.shouldForwardHeader(key) || request.getHeader(key) != null) continue;
                for (String value : originalInboundRequest.getAllHeaders(key)) {
                    request.addHeader(key, value);
                }
            }
        }
        if (this.forcedHeaders.size() > 0) {
            chain = this.forcedHeaders.keySet().iterator();
            while (chain.hasNext()) {
                String key = (String)chain.next();
                request.removeHeader(key);
                for (String value : this.forcedHeaders.get((Object)key)) {
                    request.addHeader(key, value);
                }
            }
        }
        if (this.forwardParams && (chain = Chain.first()) != null && (origionalParams = new Url((originalInboundRequest = chain.getRequest()).getUrl().getOriginal()).getParams()).size() > 0) {
            for (String key : origionalParams.keySet()) {
                if (!this.shouldForwardParam(key) || request.getUrl().getParam(key) != null) continue;
                request.getUrl().withParam(key, (String)origionalParams.get(key));
            }
        }
        return request;
    }

    FutureResponse buildFuture(Request request) {
        FutureResponse future = new FutureResponse(request){

            @Override
            public void run() {
                Response response = ApiClient.this.doRequest(this.request);
                response.withEndAt(System.currentTimeMillis());
                this.setResponse(response);
            }
        };
        return future;
    }

    protected Response doRequest(Request request) {
        return this.doRequest0(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    Response doRequest0(Request request) {
        String m = request.getMethod();
        Object req = null;
        String url = request.getUrl().toString();
        Response response = new Response(url);
        response.withJson((JSNode)null);
        response.withRequest(request);
        for (RequestListener l : this.requestListeners) {
            Response response2 = l.onRequest(request);
            if (response2 == null) continue;
            if (response2.getUrl() == null) {
                response2.withUrl(url);
            }
            if (response2.getRequest() == null) {
                response2.withRequest(request);
            }
            return response2;
        }
        try {
            HttpClient h = this.getHttpClient();
            response.debug("--request header------", new Object[0]);
            response.debug(m + " " + url, new Object[0]);
            if ("post".equalsIgnoreCase(m)) {
                req = new HttpPost(url);
            }
            if ("put".equalsIgnoreCase(m)) {
                req = new HttpPut(url);
            } else if ("get".equalsIgnoreCase(m)) {
                req = new HttpGet(url);
            } else if ("delete".equalsIgnoreCase(m)) {
                req = request.getBody() != null ? new HttpDeleteWithBody(url) : new HttpDelete(url);
            } else if ("patch".equalsIgnoreCase(m)) {
                req = new HttpPatch(url);
            }
            for (String key : request.getHeaders().keySet()) {
                List values = request.getAllHeaders(key);
                for (String value : values) {
                    req.setHeader(key, value);
                    response.debug(key, new Object[]{value});
                }
            }
            if (request.getBody() != null && req instanceof HttpEntityEnclosingRequestBase) {
                void var8_15;
                response.debug("\r\n--request body--------", new Object[0]);
                byte[] byArray = request.getBody().getBytes(StandardCharsets.UTF_8);
                if (this.useCompression && byArray.length >= this.compressionMinSize) {
                    req.setHeader("Content-Encoding", "gzip");
                    ByteArrayOutputStream obj = new ByteArrayOutputStream();
                    GZIPOutputStream gzip = new GZIPOutputStream(obj);
                    gzip.write(byArray);
                    gzip.flush();
                    gzip.close();
                    byte[] byArray2 = obj.toByteArray();
                }
                ((HttpEntityEnclosingRequestBase)req).setEntity((HttpEntity)new ByteArrayEntity((byte[])var8_15));
            }
            if (Utils.empty((Object[])new Object[]{request.getHeader("Accept-Encoding")})) {
                req.setHeader("Accept-Encoding", "gzip");
            }
            HttpResponse hr = h.execute((HttpUriRequest)req);
            response.withStatusMesg(hr.getStatusLine().toString());
            response.withStatusCode(hr.getStatusLine().getStatusCode());
            response.debug("-response headers -----", new Object[0]);
            response.debug("status: " + response.getStatus(), new Object[0]);
            for (Header header : hr.getAllHeaders()) {
                response.debug("\r\n" + header.getName() + ": " + header.getValue(), new Object[0]);
                response.withHeader(header.getName(), header.getValue());
            }
            HttpEntity httpEntity = hr.getEntity();
            if (httpEntity != null) {
                InputStream is = httpEntity.getContent();
                StreamBuffer tempBuffer = new StreamBuffer();
                tempBuffer.withBufferSize(this.getMaxMemoryBuffer());
                Utils.pipe((InputStream)is, (OutputStream)tempBuffer);
                response.withBody(tempBuffer);
                long expectedLength = httpEntity.getContentLength();
                if (expectedLength > 0L && (long)tempBuffer.getLength() != expectedLength) {
                    throw new ApiException("Content-Length header does not match received payload size.", new Object[0]);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            response.withError((Throwable)ex);
            response.withStatus("500 Internal Server Error");
        }
        finally {
            if (req != null) {
                try {
                    req.releaseConnection();
                }
                catch (Exception ex) {
                    log.info((Object)"Exception trying to release the request connection", (Throwable)ex);
                }
            }
        }
        response.dump();
        return response;
    }

    public ApiClient onRequest(RequestListener requestListener) {
        this.requestListeners.add(requestListener);
        return this;
    }

    public ApiClient onResponse(Consumer<Response> responseListener) {
        this.responseListeners.add(responseListener);
        return this;
    }

    synchronized void submit(FutureResponse future) {
        this.getExecutor().submit(future);
    }

    String buildUrl(String callerSuppliedFullUrlOrRelativePath) {
        Object url = callerSuppliedFullUrlOrRelativePath;
        if (url == null || !((String)url).startsWith("http://") && !((String)url).startsWith("https://")) {
            String prefix;
            url = url != null ? url : "";
            String string = prefix = this.url != null ? this.url : Utils.getSysEnvProp((String)(this.getName() + ".url"));
            if (!Utils.empty((Object[])new Object[]{prefix})) {
                url = ((String)url).length() > 0 && !((String)url).startsWith("/") && !prefix.endsWith("/") ? prefix + "/" + (String)url : prefix + (String)url;
            }
        }
        if (url == null) {
            throw ApiException.new500InternalServerError((String)"Unable to determine url for ApiClient.buildUrl().  Either pass the desired url in on your call or set configuration property {}.url=${url}.", (Object[])new Object[]{this.getName()});
        }
        if (!((String)url).startsWith("http://") && !((String)url).startsWith("https://")) {
            throw ApiException.new500InternalServerError((String)"The destination URL must start with 'http://' or 'https://', received '{}'", (Object[])new Object[]{url});
        }
        Request parentRequest = null;
        Chain chain = Chain.peek();
        if (chain != null) {
            parentRequest = chain.getRequest();
        }
        if (parentRequest != null) {
            url = this.replaceVars(parentRequest, (String)url);
        }
        if (((String)url).endsWith("/")) {
            url = ((String)url).substring(0, ((String)url).length() - 1);
        }
        return url;
    }

    public String replaceVars(Request parentRequest, String url) {
        String protocol = ((String)url).substring(0, ((String)url).indexOf(":") + 3);
        url = ((String)url).substring(((String)url).indexOf(":") + 3);
        String query = null;
        int queryIdx = ((String)url).indexOf("?");
        if (queryIdx > -1) {
            query = ((String)url).substring(((String)url).indexOf("?") + 1);
            url = ((String)url).substring(0, ((String)url).indexOf("?"));
        }
        String host = null;
        int slashIdx = ((String)url).indexOf("/");
        int colonIdx = ((String)url).indexOf(":");
        if (slashIdx < 0 && colonIdx < 0) {
            host = url;
            url = "";
        } else if (slashIdx > 0 && colonIdx < 0) {
            host = ((String)url).substring(0, slashIdx);
            url = ((String)url).substring(slashIdx + 1);
        } else if (colonIdx > 0 && slashIdx < 0) {
            host = url;
            url = "";
        } else if (colonIdx > 0 && slashIdx > 0 && colonIdx < slashIdx) {
            host = ((String)url).substring(0, slashIdx);
            url = ((String)url).substring(slashIdx);
        } else if (colonIdx > 0 && slashIdx > 0 && slashIdx < colonIdx) {
            host = ((String)url).substring(0, slashIdx + 1);
            url = ((String)url).substring(slashIdx + 1);
        }
        String path = url;
        host = this.replaceVars(parentRequest, new Path(new String[]{host.replace(".", "/")}), false).toString().replace("/", ".");
        String string = path = path == null ? null : this.replaceVars(parentRequest, new Path(new String[]{path}), true).toString();
        if (query != null) {
            // empty if block
        }
        url = protocol + host + (String)(path != null ? "/" + path : "") + (String)(query != null ? "?" + query : "");
        return url;
    }

    Path replaceVars(Request request, Path path, boolean allowOptionals) {
        path = path.copy();
        boolean isOptional = false;
        for (int i = 0; i < path.size(); ++i) {
            boolean bl = isOptional = isOptional || path.isOptional(i);
            if (!path.isVar(i)) continue;
            String value = request.getUrl().getParam(path.getVarName(i));
            if (value != null) {
                path.set(i, value);
                continue;
            }
            if (isOptional) {
                if (!allowOptionals) {
                    throw ApiException.new500InternalServerError((String)"Optionals are not allowed in this variable substitution.", (Object[])new Object[0]);
                }
                path = path.subpath(0, i);
                break;
            }
            throw ApiException.new500InternalServerError((String)"You have a non optional unbound variable in your ApiClient configuration.", (Object[])new Object[0]);
        }
        return path;
    }

    public ApiClient withUrl(String url) {
        this.url = url;
        return this;
    }

    public ListMap<String, String> getForcedHeaders() {
        return this.forcedHeaders;
    }

    public ApiClient withForcedHeader(String name, String value) {
        this.forcedHeaders.put((Object)name, (Object)value);
        return this;
    }

    public ApiClient withForcedHeaders(String ... headers) {
        for (int i = 0; i < headers.length - 1; i += 2) {
            this.withForcedHeader(headers[i], headers[i + 1]);
        }
        return this;
    }

    public ApiClient withForwardedHeaders(boolean forwardHeaders) {
        this.forwardHeaders = forwardHeaders;
        return this;
    }

    public ApiClient withForwardedParams(boolean forwardParams) {
        this.forwardParams = forwardParams;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ApiClient withName(String name) {
        this.name = name;
        return this;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public ApiClient withUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
        return this;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public ApiClient withCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
        return this;
    }

    public ApiClient withHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public ApiClient withSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ApiClient withConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public ApiClient withConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        return this;
    }

    public int getMaxConPerRoute() {
        return this.maxConPerRoute;
    }

    public ApiClient withMaxConPerRoute(int maxConPerRoute) {
        this.maxConPerRoute = maxConPerRoute;
        return this;
    }

    public int getMaxConTotal() {
        return this.maxConTotal;
    }

    public ApiClient withMaxConTotal(int maxConTotal) {
        this.maxConTotal = maxConTotal;
        return this;
    }

    public boolean isEvictExpiredConnections() {
        return this.evictExpiredConnections;
    }

    public ApiClient withEvictExpiredConnections(boolean evictExpiredConnections) {
        this.evictExpiredConnections = evictExpiredConnections;
        return this;
    }

    public int getEvictIdleConnectionsAfterTimeMillis() {
        return this.evictIdleConnectionsAfterTimeMillis;
    }

    public ApiClient withEvictIdleConnectionsAfterTimeMillis(int evictIdleConnectionsAfterTimeMillis) {
        this.evictIdleConnectionsAfterTimeMillis = evictIdleConnectionsAfterTimeMillis;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            ApiClient apiClient = this;
            synchronized (apiClient) {
                if (this.httpClient == null) {
                    try {
                        this.httpClient = this.buildHttpClient(this.getHttpClientBuilder());
                    }
                    catch (Exception ex) {
                        Utils.rethrow((Throwable)ex);
                    }
                }
            }
        }
        return this.httpClient;
    }

    protected synchronized HttpClient buildHttpClient(HttpClientBuilder builder) throws Exception {
        return builder.build();
    }

    public ApiClient withHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClientBuilder getHttpClientBuilder() {
        if (this.httpClientBuilder == null) {
            ApiClient apiClient = this;
            synchronized (apiClient) {
                if (this.httpClientBuilder == null) {
                    this.httpClientBuilder = this.buildDefaultHttpClientBuilder();
                }
            }
        }
        return this.httpClientBuilder;
    }

    public synchronized HttpClientBuilder buildDefaultHttpClientBuilder() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setMaxConnTotal(this.maxConTotal);
        httpClientBuilder.setMaxConnPerRoute(this.maxConPerRoute);
        if (this.evictExpiredConnections) {
            httpClientBuilder.evictExpiredConnections();
        }
        if (this.evictIdleConnectionsAfterTimeMillis > 0) {
            httpClientBuilder.evictIdleConnections((long)this.evictIdleConnectionsAfterTimeMillis, TimeUnit.MILLISECONDS);
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.connectionRequestTimeout).build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        return httpClientBuilder;
    }

    public ApiClient withExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor getExecutor() {
        if (this.executor == null) {
            ApiClient apiClient = this;
            synchronized (apiClient) {
                if (this.executor == null) {
                    this.executor = this.buildExecutor();
                }
            }
        }
        return this.executor;
    }

    protected synchronized Executor buildExecutor() {
        return new Executor().withThreadsMax(this.threadsMax);
    }

    public boolean isForwardHeaders() {
        return this.forwardHeaders;
    }

    protected boolean shouldForwardHeader(String headerKey) {
        if (headerKey == null) {
            return false;
        }
        headerKey = headerKey.trim();
        return this.forwardHeaders && (this.includeForwardHeaders.size() == 0 || this.includeForwardHeaders.contains(headerKey)) && !this.excludeForwardHeaders.contains(headerKey);
    }

    public ApiClient withForwardHeaders(boolean forwardHeaders) {
        this.forwardHeaders = forwardHeaders;
        return this;
    }

    public Set<String> getIncludeForwardHeaders() {
        return new HashSet<String>(this.includeForwardHeaders);
    }

    public ApiClient withIncludeForwardHeaders(String ... headerKeys) {
        for (int i = 0; headerKeys != null && i < headerKeys.length; ++i) {
            this.includeForwardHeaders.add(headerKeys[i]);
        }
        return this;
    }

    public ApiClient removeIncludeForwardHeader(String headerKey) {
        if (headerKey != null) {
            this.includeForwardHeaders.remove(headerKey);
        }
        return this;
    }

    public Set getExcludeForwardHeaders() {
        return new HashSet(this.excludeForwardHeaders);
    }

    public ApiClient withExcludeForwardHeaders(String ... headerKeys) {
        for (int i = 0; headerKeys != null && i < headerKeys.length; ++i) {
            this.excludeForwardHeaders.add(headerKeys[i]);
        }
        return this;
    }

    public ApiClient removeExcludeForwardHeader(String headerKey) {
        if (headerKey != null) {
            this.excludeForwardHeaders.remove(headerKey);
        }
        return this;
    }

    public boolean isForwardParams() {
        return this.forwardParams;
    }

    protected boolean shouldForwardParam(String param) {
        return this.forwardParams && !param.startsWith("_") && !param.equalsIgnoreCase("explain") && !param.equalsIgnoreCase("debug") && (this.includeParams.size() == 0 || this.includeParams.contains(param)) && !this.excludeParams.contains(param);
    }

    public ApiClient withForwardParams(boolean forwardParams) {
        this.forwardParams = forwardParams;
        return this;
    }

    public Set getIncludeParams() {
        return new HashSet<String>(this.includeParams);
    }

    public ApiClient withIncludeParams(String ... paramNames) {
        for (int i = 0; paramNames != null && i < paramNames.length; ++i) {
            this.includeParams.add(paramNames[i]);
        }
        return this;
    }

    public ApiClient removeIncludeParam(String param) {
        if (param != null) {
            this.includeParams.remove(param);
        }
        return this;
    }

    public Set getExcludeParams() {
        return new HashSet<String>(this.excludeParams);
    }

    public ApiClient withExcludeParams(String ... paramNames) {
        for (int i = 0; paramNames != null && i < paramNames.length; ++i) {
            this.excludeParams.add(paramNames[i]);
        }
        return this;
    }

    public ApiClient removeExcludeParam(String param) {
        if (param != null) {
            this.excludeParams.remove(param);
        }
        return this;
    }

    public long getMaxMemoryBuffer() {
        return this.maxMemoryBuffer;
    }

    public ApiClient withMaxMemoryBuffer(long maxMemoryBuffer) {
        this.maxMemoryBuffer = maxMemoryBuffer;
        return this;
    }

    public int getThreadsMax() {
        return this.threadsMax;
    }

    public ApiClient withThreadsMax(int threadsMax) {
        this.threadsMax = threadsMax;
        if (this.executor != null) {
            this.executor.withThreadsMax(threadsMax);
        }
        return this;
    }

    public abstract class FutureResponse
    implements RunnableFuture<Response> {
        final List<Consumer<Response>> successListeners = new ArrayList<Consumer<Response>>();
        final List<Consumer<Response>> failureListeners = new ArrayList<Consumer<Response>>();
        final List<Consumer<Response>> responseListeners = new ArrayList<Consumer<Response>>();
        final Request request;
        Response response = null;

        FutureResponse(Request request) {
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FutureResponse onSuccess(Consumer<Response> handler) {
            boolean done;
            FutureResponse futureResponse = this;
            synchronized (futureResponse) {
                done = this.isDone();
                if (!done) {
                    this.successListeners.add(handler);
                }
            }
            if (done && this.isSuccess()) {
                try {
                    handler.accept(this.response);
                }
                catch (Throwable ex) {
                    log.error((Object)"Error handling onSuccess", ex);
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FutureResponse onFailure(Consumer<Response> handler) {
            boolean done;
            FutureResponse futureResponse = this;
            synchronized (futureResponse) {
                done = this.isDone();
                if (!done) {
                    this.failureListeners.add(handler);
                }
            }
            if (done && !this.isSuccess()) {
                try {
                    handler.accept(this.response);
                }
                catch (Throwable ex) {
                    log.error((Object)"Error handling onFailure", ex);
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FutureResponse onResponse(Consumer<Response> handler) {
            boolean done;
            FutureResponse futureResponse = this;
            synchronized (futureResponse) {
                done = this.isDone();
                if (!done) {
                    this.responseListeners.add(handler);
                }
            }
            if (done) {
                try {
                    handler.accept(this.response);
                }
                catch (Throwable ex) {
                    log.error((Object)"Error handling onResponse", ex);
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setResponse(Response response) {
            FutureResponse futureResponse = this;
            synchronized (futureResponse) {
                this.response = response;
                for (Consumer<Response> h : ApiClient.this.responseListeners) {
                    h.accept(response);
                }
                if (this.isSuccess()) {
                    for (Consumer<Response> h : this.successListeners) {
                        try {
                            h.accept(response);
                        }
                        catch (Throwable ex) {
                            log.error((Object)"Error handling success callbacks in setResponse", ex);
                        }
                    }
                } else {
                    for (Consumer<Response> h : this.failureListeners) {
                        try {
                            h.accept(response);
                        }
                        catch (Throwable ex) {
                            log.error((Object)"Error handling failure callbacks in setResponse", ex);
                        }
                    }
                }
                for (Consumer<Response> h : this.responseListeners) {
                    try {
                        h.accept(response);
                    }
                    catch (Throwable ex) {
                        log.error((Object)"Error handling callbacks in setResponse", ex);
                    }
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response get() {
            while (this.response == null) {
                FutureResponse futureResponse = this;
                synchronized (futureResponse) {
                    if (this.response == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            return this.response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response get(long timeout, TimeUnit unit) throws TimeoutException {
            long start = System.currentTimeMillis();
            while (this.response == null) {
                FutureResponse futureResponse = this;
                synchronized (futureResponse) {
                    if (this.response == null) {
                        try {
                            timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
                            if ((timeout -= System.currentTimeMillis() - start) < 1L) {
                                break;
                            }
                            this.wait(timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            return this.response;
        }

        public boolean isSuccess() {
            return this.response != null && this.response.isSuccess();
        }

        public Request getRequest() {
            return this.request;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean cancel(boolean arg0) {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.response != null;
        }
    }

    public static class Executor {
        final LinkedList<RunnableFuture> queue = new LinkedList();
        final Vector<Thread> threads = new Vector();
        final String threadPrefix = "executor";
        protected int threadsMin = 1;
        protected int threadsMax = 5;
        protected int queueMax = 500;

        public synchronized Future submit(final Runnable task) {
            return this.submit(new RunnableFuture(){
                boolean started = false;
                boolean canceled = false;
                boolean done = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (this.canceled || this.done) {
                            return;
                        }
                        this.started = true;
                        task.run();
                    }
                    finally {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            this.done = true;
                            this.notifyAll();
                        }
                    }
                }

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    this.canceled = true;
                    return !this.started;
                }

                @Override
                public boolean isCancelled() {
                    return this.canceled;
                }

                @Override
                public boolean isDone() {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object get() throws InterruptedException, ExecutionException {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        while (!this.done) {
                            this.wait();
                        }
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    1 var4_3 = this;
                    synchronized (var4_3) {
                        while (!this.done) {
                            this.wait(unit.toMillis(timeout));
                        }
                    }
                    return null;
                }
            });
        }

        public synchronized RunnableFuture submit(RunnableFuture task) {
            if (this.getThreadsMax() < 1) {
                task.run();
            } else {
                this.put(task);
                this.checkStartThread();
            }
            return task;
        }

        synchronized boolean checkStartThread() {
            if (this.queue.size() > 0 && this.threads.size() < this.threadsMax) {
                Thread t = new Thread(this::processQueue, "executor worker");
                t.setDaemon(true);
                this.threads.add(t);
                t.start();
                return true;
            }
            return false;
        }

        synchronized boolean checkEndThread() {
            if (this.queue.size() == 0 && this.threads.size() > this.threadsMin) {
                this.threads.remove(Thread.currentThread());
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int queued() {
            LinkedList<RunnableFuture> linkedList = this.queue;
            synchronized (linkedList) {
                return this.queue.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(RunnableFuture task) {
            LinkedList<RunnableFuture> linkedList = this.queue;
            synchronized (linkedList) {
                while (this.queue.size() >= this.queueMax) {
                    try {
                        this.queue.wait();
                    }
                    catch (Exception exception) {}
                }
                this.queue.add(task);
                this.queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RunnableFuture take() {
            RunnableFuture t;
            LinkedList<RunnableFuture> linkedList = this.queue;
            synchronized (linkedList) {
                while (this.queue.size() == 0) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                t = this.queue.removeFirst();
                this.queue.notifyAll();
            }
            return t;
        }

        void processQueue() {
            try {
                while (!this.checkEndThread()) {
                    do {
                        RunnableFuture task = this.take();
                        task.run();
                    } while (this.queue.size() > 0);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public int getThreadsMin() {
            return this.threadsMin;
        }

        public Executor withThreadsMin(int threadsMin) {
            this.threadsMin = threadsMin;
            return this;
        }

        public int getThreadsMax() {
            return this.threadsMax;
        }

        public Executor withThreadsMax(int threadsMax) {
            this.threadsMax = threadsMax;
            return this;
        }

        public int getQueueMax() {
            return this.queueMax;
        }

        public Executor withQueueMax(int queueMax) {
            this.queueMax = queueMax;
            return this;
        }
    }

    static class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        static final String methodName = "DELETE";

        public HttpDeleteWithBody(String url) {
            this.setURI(URI.create(url));
        }

        public String getMethod() {
            return methodName;
        }
    }

    public static interface RequestListener {
        public Response onRequest(Request var1);
    }
}

