/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.cosmosdb;

import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.FeedResponse;
import com.microsoft.azure.documentdb.PartitionKey;
import com.microsoft.azure.documentdb.SqlParameter;
import com.microsoft.azure.documentdb.SqlParameterCollection;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Index;
import io.inversion.Results;
import io.inversion.cosmosdb.CosmosDb;
import io.inversion.jdbc.SqlQuery;
import io.inversion.json.JSMap;
import io.inversion.json.JSParser;
import io.inversion.query.Order;
import io.inversion.query.Query;
import io.inversion.query.Where;
import io.inversion.rql.Term;
import io.inversion.utils.KeyValue;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CosmosSqlQuery
extends SqlQuery<CosmosDb> {
    public CosmosSqlQuery(CosmosDb db, Collection table, List<Term> terms) {
        super((Db)db, table, terms);
    }

    protected Where createWhere() {
        return new Where((Query)this){

            protected Term transform(Term parent) {
                if (parent.hasToken(new String[]{"like"})) {
                    String text = parent.getToken(1);
                    int idx = text.indexOf("*");
                    if (idx != 0 && idx != text.length() - 1 || idx != text.lastIndexOf("*")) {
                        throw ApiException.new400BadRequest((String)"The 'like' RQL operator for CosmosDb expects a single wildcard at the beginning OR the end of a value.  CosmosDb does not really support 'like' but compatible 'like' statements are turned into 'sw' or 'ew' statements that are supported.", (Object[])new Object[0]);
                    }
                    if (idx == 0) {
                        parent.withToken("ew");
                        parent.getTerm(1).withToken(text.substring(1));
                    } else {
                        parent.withToken("sw");
                        parent.getTerm(1).withToken(text.substring(0, text.length() - 1));
                    }
                } else if (parent.hasToken(new String[]{"w", "wo"})) {
                    throw ApiException.new400BadRequest((String)"CosmosDb supports 'sw' and 'ew' but not 'w' or 'wo' functions.", (Object[])new Object[0]);
                }
                return super.transform(parent);
            }
        };
    }

    public Results doSelect() throws ApiException {
        Results results = new Results((Query)this);
        CosmosDb db = (CosmosDb)this.getDb();
        String collectionUri = db.getCollectionUri(this.collection);
        String sql = this.getPreparedStmt();
        sql = sql.replaceAll("\r", "");
        sql = sql.replaceAll("\n", " ");
        SqlParameterCollection params = new SqlParameterCollection();
        for (int i = 0; i < this.castValues.size(); ++i) {
            KeyValue kv = (KeyValue)this.castValues.get(i);
            String varName = this.asVariableName(i);
            params.add(new SqlParameter(varName, kv.getValue()));
        }
        SqlQuerySpec querySpec = new SqlQuerySpec(sql, params);
        FeedOptions options = new FeedOptions();
        Object partKey = null;
        Index partKeyIdx = this.collection.getIndexByType("PartitionKey");
        if (partKeyIdx != null) {
            String partKeyCol = partKeyIdx.getProperty(0).getColumnName();
            Term partKeyTerm = this.findTerm(partKeyCol, new String[]{"eq"});
            if (partKeyTerm == null) {
                partKeyCol = partKeyIdx.getProperty(0).getColumnName();
                partKeyTerm = this.findTerm(partKeyCol, new String[]{"eq"});
            }
            if (partKeyTerm != null && partKeyTerm.getParent() == null) {
                partKey = partKeyTerm.getToken(1);
            } else if ("id".equalsIgnoreCase(partKeyCol)) {
                partKey = Chain.top().getRequest().getResourceKey();
            }
        }
        boolean partKeyMissing = false;
        if (partKey != null) {
            partKey = ((CosmosDb)this.getDb()).castJsonInput(partKeyIdx.getProperty(0), partKey);
            options.setEnableCrossPartitionQuery(Boolean.valueOf(false));
            options.setPartitionKey(new PartitionKey(partKey));
        } else {
            if (this.getDb() != null && !((CosmosDb)this.getDb()).isAllowCrossPartitionQueries()) {
                partKeyMissing = true;
            }
            options.setEnableCrossPartitionQuery(Boolean.valueOf(true));
        }
        Object debug = "CosmosDb: SqlQuerySpec=" + querySpec.toJson() + " FeedOptions={enableCrossPartitionQuery=" + (partKey == null) + "}";
        debug = ((String)debug).replaceAll("\r", "");
        debug = ((String)debug).replaceAll("\n", " ");
        debug = ((String)debug).replaceAll(" +", " ");
        Chain.debug((String)debug, (Object[])new Object[0]);
        results.withTestQuery((String)debug);
        System.out.println((String)debug);
        if (partKeyMissing) {
            throw ApiException.new400BadRequest((String)"CosmosSqlQuery.allowCrossPartitionQueries is false.", (Object[])new Object[0]);
        }
        if (!this.isDryRun()) {
            FeedResponse queryResults;
            DocumentClient cosmos = db.getDocumentClient();
            try {
                queryResults = cosmos.queryDocuments(collectionUri, querySpec, options);
            }
            catch (Exception ex) {
                throw ApiException.new500InternalServerError((String)Utils.getCause((Throwable)ex).getMessage(), (Object[])new Object[0]);
            }
            for (Document doc : queryResults.getQueryIterable()) {
                String json = doc.toJson();
                JSMap node = JSParser.asJSMap((String)json);
                for (String key : node.keySet()) {
                    if (!key.startsWith("_")) continue;
                    node.remove((Object)key);
                }
                node.sort();
                results.withRow((Map)node);
            }
        }
        return results;
    }

    protected String toSql(boolean preparedStmt) {
        String sql = super.toSql(preparedStmt);
        sql = sql.replace(this.columnQuote + this.collection.getTableName() + this.columnQuote + ".*", "*");
        String regex = this.columnQuote + this.collection.getTableName() + this.columnQuote + "\\." + this.columnQuote + "([^" + this.columnQuote + "]*)" + this.columnQuote;
        sql = sql.replaceAll(regex, this.collection.getTableName() + "[\"$1\"]");
        sql = sql.replace(this.columnQuote + this.collection.getTableName() + this.columnQuote, this.collection.getTableName());
        return sql;
    }

    protected List<Order.Sort> getDefaultSorts(SqlQuery.Parts parts) {
        return (List)Utils.add(new ArrayList(), (Object[])new Object[]{new Order.Sort("id", true)});
    }

    protected String printLimitClause(SqlQuery.Parts parts, int offset, int limit) {
        if (offset < 0) {
            offset = 0;
        }
        if (limit <= 0) {
            limit = 100;
        }
        String clause = "OFFSET " + offset + " LIMIT " + limit;
        parts.limit = clause;
        return clause;
    }

    protected String asVariableName(int valuesPairIdx) {
        KeyValue kv = (KeyValue)this.castValues.get(valuesPairIdx);
        return "@" + kv.getKey() + (valuesPairIdx + 1);
    }

    protected String asString(Term term) {
        String string = super.asString(term);
        System.out.println("String:" + string);
        Term parent = term.getParent();
        if (parent != null && string.indexOf("%") > 0 && parent.hasToken(new String[]{"sw", "ew"})) {
            string = string.replace("%", "");
        }
        return string;
    }

    protected String printExpression(Term term, List<String> dynamicSqlChildText, List<String> preparedStmtChildText) {
        String token = term.getToken();
        StringBuilder sql = new StringBuilder();
        if ("n".equalsIgnoreCase(token)) {
            sql.append(" IS_NULL (");
            for (int i = 0; i < preparedStmtChildText.size(); ++i) {
                sql.append(preparedStmtChildText.get(i).trim());
                if (i >= preparedStmtChildText.size() - 1) continue;
                sql.append(" ");
            }
            sql.append(")");
        } else if ("nn".equals(token)) {
            sql.append(preparedStmtChildText.get(0)).append(" <> null");
        } else if ("sw".equalsIgnoreCase(token)) {
            sql.append(" STARTSWITH (");
            for (int i = 0; i < preparedStmtChildText.size(); ++i) {
                String val = preparedStmtChildText.get(i);
                sql.append(val);
                if (i >= preparedStmtChildText.size() - 1) continue;
                sql.append(", ");
            }
            sql.append(")");
        } else if ("ew".equalsIgnoreCase(token)) {
            sql.append(" ENDSWITH (");
            for (int i = 0; i < preparedStmtChildText.size(); ++i) {
                String val = preparedStmtChildText.get(i);
                sql.append(val);
                if (i >= preparedStmtChildText.size() - 1) continue;
                sql.append(", ");
            }
            sql.append(")");
        } else {
            return super.printExpression(term, dynamicSqlChildText, preparedStmtChildText);
        }
        return sql.toString();
    }
}

