/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.Bucket;
import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Param;
import io.inversion.Results;
import io.inversion.User;
import io.inversion.rql.Term;
import io.inversion.s3.S3DbQuery;
import io.inversion.utils.Path;
import io.inversion.utils.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class S3Db
extends Db<S3Db> {
    protected String awsAccessKey = null;
    protected String awsSecretKey = null;
    protected String awsRegion = null;
    protected String buckets = null;
    private transient AmazonS3 client = null;
    protected Map<String, String> bucketPrefixes = new HashMap<String, String>();

    public S3Db() {
    }

    public S3Db(String name, String ... includeOn) {
        this.withName(name);
        for (int i = 0; includeOn != null && i < includeOn.length; ++i) {
            this.withIncludeOn(new String[]{includeOn[i]});
        }
    }

    protected void doStartup(Api api) {
        AmazonS3 client = this.getS3Client();
        if (this.buckets != null) {
            String[] buckets;
            for (String bucket : buckets = this.buckets.split(",")) {
                String[] parts = bucket.split("\\|");
                String name = parts.length > 1 ? parts[1] : bucket;
                String prefix = parts.length > 2 ? parts[2] : null;
                bucket = parts[0];
                if (prefix != null) {
                    this.bucketPrefixes.put(name, prefix);
                }
                Collection coll = new Collection(name).withTableName(bucket);
                coll.withProperty("key", String.class.getName(), false);
                coll.withProperty("href", String.class.getName(), false);
                coll.withIndex(coll.getName() + "Pk", "RESOURCE_KEY", true, new String[]{"key"});
                this.withCollection(coll);
            }
        } else {
            List bucketList = client.listBuckets();
            for (Bucket bucket : bucketList) {
                Collection coll = new Collection(bucket.getName());
                coll.withProperty("key", String.class.getName(), false);
                coll.withProperty("href", String.class.getName(), false);
                coll.withIndex(coll.getName() + "Pk", "RESOURCE_KEY", true, new String[]{"key"});
                this.withCollection(coll);
            }
        }
    }

    public Results doSelect(Collection collection, List<Term> columnMappedTerms) throws ApiException {
        String str = this.bucketPrefixes.get(collection.getName());
        Path prefix = null;
        if (str != null) {
            prefix = new Path(new String[]{str});
            for (int i = 0; i < prefix.size(); ++i) {
                if (!prefix.isVar(i)) continue;
                String var = prefix.getVarName(i);
                String value = null;
                User user = Chain.getUser();
                if (user != null) {
                    value = (String)user.getClaim(var);
                }
                if (value == null) {
                    value = Chain.top().getRequest().findParam(var, new Param.In[]{Param.In.HOST, Param.In.SERVER_PATH, Param.In.PATH});
                }
                if (value != null) {
                    prefix.set(i, value);
                    continue;
                }
                throw ApiException.new400BadRequest((String)"Unable to determine value for '{}'", (Object[])new Object[]{var});
            }
        }
        S3DbQuery query = new S3DbQuery(this, collection, prefix, columnMappedTerms);
        return query.doSelect();
    }

    public List<String> doUpsert(Collection table, List<Map<String, Object>> rows) throws ApiException {
        return null;
    }

    public void doDelete(Collection table, List<Map<String, Object>> indexValues) throws ApiException {
    }

    public AmazonS3 getS3Client() {
        return this.getS3Client(this.awsRegion, this.awsAccessKey, this.awsSecretKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonS3 getS3Client(String awsRegion, String awsAccessKey, String awsSecretKey) {
        if (this.client == null) {
            S3Db s3Db = this;
            synchronized (s3Db) {
                if (this.client == null) {
                    AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
                    if (!Utils.empty((Object[])new Object[]{awsRegion})) {
                        builder.withRegion(awsRegion);
                    }
                    if (!Utils.empty((Object[])new Object[]{awsAccessKey}) && !Utils.empty((Object[])new Object[]{awsSecretKey})) {
                        BasicAWSCredentials creds = new BasicAWSCredentials(awsAccessKey, awsSecretKey);
                        builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)creds));
                    }
                    this.client = (AmazonS3)builder.build();
                }
            }
        }
        return this.client;
    }

    public S3Db withAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
        return this;
    }

    public S3Db withAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
        return this;
    }

    public S3Db withAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
        return this;
    }
}

