/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import io.inversion.Action;
import io.inversion.ApiException;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Upload;
import io.inversion.json.JSList;
import io.inversion.json.JSMap;
import io.inversion.utils.LimitInputStream;
import io.inversion.utils.Path;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.CountingInputStream;

public class S3UploadAction
extends Action<S3UploadAction> {
    protected String s3AccessKey = null;
    protected String s3SecretKey = null;
    protected String s3AwsRegion = null;
    protected String s3Bucket = null;
    protected String s3BasePath = "uploads";
    protected String s3DatePath = "yyyy/MM/dd";
    protected long maxUploadLength = 102400000L;
    protected AmazonS3 s3Client = null;
    protected String allowedCharactersRegex = "^[\\. \\(\\)\\'a-zA-Z0-9_-]*$";

    private static String getHash(MessageDigest digest) throws IOException {
        byte[] md5sum = digest.digest();
        BigInteger bigInt = new BigInteger(1, md5sum);
        StringBuilder output = new StringBuilder(bigInt.toString(16));
        while (output.length() < 32) {
            output.insert(0, "0");
        }
        return output.toString();
    }

    public void run(Request req, Response res) throws ApiException {
        try {
            boolean fileInUrl;
            List uploads = req.getUploads();
            boolean bl = fileInUrl = req.getUrl().getParam("file") != null;
            if (uploads.size() > 1 && fileInUrl) {
                throw ApiException.new400BadRequest((String)"You can not include a file name in your url if you post more than a single file.", (Object[])new Object[0]);
            }
            JSList arr = new JSList(new Object[0]);
            for (Upload upload : uploads) {
                S3File file = this.saveFile(req, upload);
                JSMap json = new JSMap();
                json.put("url", (Object)file.url);
                json.put("path", (Object)file.path);
                json.put("hash", (Object)file.hash);
                json.put("bytes", (Object)file.bytes);
                arr.add((Object)json);
            }
            if (uploads.size() > 0) {
                if (fileInUrl) {
                    req.withJson(arr.getMap((Object)0).copy());
                    res.withJson(arr.getMap((Object)0).copy());
                } else {
                    req.withJson(arr.copy());
                    res.withJson(arr.copy());
                }
            }
        }
        catch (Exception ex) {
            throw ApiException.new500InternalServerError((Throwable)ex);
        }
    }

    protected void onFileUploaded(Request req, Response resp, Upload upload, S3File file) {
        JSMap json = new JSMap();
        json.put("url", (Object)file.url);
        json.put("path", (Object)file.path);
        json.put("hash", (Object)file.hash);
        json.put("bytes", (Object)file.bytes);
        req.withJson(json.copy());
        resp.withJson(json.copy());
    }

    protected S3File saveFile(Request req, Upload upload) throws ApiException {
        AmazonS3 s3 = this.buildS3Client();
        String bucket = this.s3Bucket;
        String path = this.buildPath(req, upload);
        return this.uploadFile(bucket, path, upload.getInputStream(), upload.getFileSize());
    }

    protected S3File uploadFile(String bucket, String key, InputStream in, long size) throws ApiException {
        return this.uploadFile(bucket, key, in, size, null, null);
    }

    protected S3File uploadFile(String bucket, String key, InputStream in, long size, Map<String, String> metadataProps, Map<String, String> tags) throws ApiException {
        try {
            long limit;
            long l = limit = size > 0L ? size : this.maxUploadLength;
            if (limit > this.maxUploadLength) {
                throw ApiException.new400BadRequest((String)"Your upload size is larger that maximum allowed size.", (Object[])new Object[0]);
            }
            in = size > 0L ? new LimitInputStream(in, size, true) : new LimitInputStream(in, limit, false);
            ObjectMetadata metadata = new ObjectMetadata();
            if (tags != null) {
                tags.keySet().forEach(tag -> metadata.setHeader(tag, tags.get(tag)));
            }
            if (metadataProps != null) {
                metadata.setUserMetadata(metadataProps);
            }
            CountingInputStream countIn = new CountingInputStream(in);
            DigestInputStream digestIn = new DigestInputStream((InputStream)countIn, MessageDigest.getInstance("SHA-256"));
            PutObjectResult s3Resp = this.getS3Client().putObject(new PutObjectRequest(bucket, key, (InputStream)digestIn, metadata));
            String hash = this.byteToHexString(digestIn.getMessageDigest().digest());
            long bytes = countIn.getByteCount();
            S3File file = new S3File();
            file.url = "http://" + bucket + ".s3.amazonaws.com/" + key;
            file.path = key;
            file.hash = hash;
            file.bytes = bytes;
            return file;
        }
        catch (Exception ex) {
            if (ex instanceof ApiException) {
                throw (ApiException)ex;
            }
            throw ApiException.new500InternalServerError((Throwable)ex);
        }
    }

    public String byteToHexString(byte[] input) {
        Object output = "";
        for (int i = 0; i < input.length; ++i) {
            output = (String)output + String.format("%02x", input[i]);
        }
        return output;
    }

    private String buildPath(Request request, Upload upload) {
        String urlFileName = request.getUrl().getParam("file");
        Path path = request.getPath().copy();
        if (urlFileName == null) {
            path.add(upload.getFileName());
        }
        if (!this.isValidPath(path)) {
            throw ApiException.new400BadRequest((String)"The supplied file path is contains invalid characters", (Object[])new Object[0]);
        }
        return path.toString();
    }

    protected boolean isValidPath(Path path) {
        if (path == null || path.size() == 0) {
            return false;
        }
        for (String part : path.parts()) {
            if (!part.matches(this.allowedCharactersRegex)) {
                return false;
            }
            if (!(part = part.replaceAll("[.]+", ".")).equals(".")) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonS3 getS3Client() {
        if (this.s3Client == null) {
            S3UploadAction s3UploadAction = this;
            synchronized (s3UploadAction) {
                if (this.s3Client == null) {
                    this.s3Client = this.buildS3Client();
                }
            }
        }
        return this.s3Client;
    }

    public S3UploadAction withS3Client(AmazonS3 s3Client) {
        this.s3Client = s3Client;
        return this;
    }

    private AmazonS3 buildS3Client() {
        AmazonS3ClientBuilder builder;
        String accessKey = this.s3AccessKey;
        String secretKey = this.s3SecretKey;
        String awsRegion = this.s3AwsRegion;
        if (accessKey != null) {
            BasicAWSCredentials creds = new BasicAWSCredentials(accessKey, secretKey);
            builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)creds));
        } else {
            builder = AmazonS3ClientBuilder.standard();
        }
        if (awsRegion != null) {
            builder.withRegion(awsRegion);
        }
        return (AmazonS3)builder.build();
    }

    class S3File {
        String url;
        String path;
        String hash;
        long bytes;
        String type;

        S3File() {
        }
    }
}

