/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;
import io.inversion.json.JSParser;
import io.inversion.utils.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

public class EchoRequestStreamHandler
implements RequestStreamHandler {
    public void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
        JSMap responseBody = new JSMap();
        JSMap responseJson = new JSMap();
        responseJson.put((Object)"isBase64Encoded", (Object)false);
        responseJson.put((Object)"statusCode", (Object)"200");
        responseJson.put((Object)"headers", (Object)new JSMap(new Object[]{"Access-Control-Allow-Origin", "*"}));
        try {
            String input = Utils.read((InputStream)new BufferedInputStream(inputStream));
            context.getLogger().log(input);
            JSNode request = JSParser.asJSNode((String)input);
            responseBody.put((Object)"request", (Object)request);
        }
        catch (Exception ex) {
            responseBody.put((Object)"error", (Object)Utils.getShortCause((Throwable)ex));
        }
        responseJson.put((Object)"body", (Object)responseBody.toString());
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        writer.write(responseJson.toString());
        writer.close();
    }
}

