/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import io.inversion.Api;
import io.inversion.Engine;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Url;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;
import io.inversion.json.JSParser;
import io.inversion.utils.ListMap;
import io.inversion.utils.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class AwsApiGatewayLambdaRequestStreamHandler
implements RequestStreamHandler {
    protected Engine engine = null;
    protected Api api = null;
    boolean debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
        block15: {
            Exception ex;
            JSMap responseBody;
            String input;
            block16: {
                input = Utils.read((InputStream)new BufferedInputStream(inputStream));
                responseBody = new JSMap();
                JSMap config = null;
                ex = null;
                try {
                    JSNode jsonParams;
                    JSNode json = JSParser.asJSNode((String)input);
                    this.debug("Request Event");
                    this.debug(json.toString(false));
                    String method = json.getString((Object)"httpMethod");
                    String host = (String)json.find("headers.Host");
                    String path = (String)json.find("requestContext.path");
                    Url url = new Url("http://" + host + path);
                    String profile = path != null ? (String)Utils.explode((String)"/", (String[])new String[]{path}).get(0) : "";
                    String proxyPath = (String)json.find("pathParameters.proxy");
                    proxyPath = proxyPath != null ? proxyPath : "";
                    String pathStr = Utils.implode((String)"/", (Object[])new Object[]{path});
                    String proxyStr = Utils.implode((String)"/", (Object[])new Object[]{proxyPath});
                    String servletPath = "";
                    if (pathStr.length() > proxyStr.length()) {
                        servletPath = pathStr.substring(0, pathStr.length() - proxyStr.length());
                    }
                    config = new JSMap(new Object[]{"method", method, "host", host, "path", path, "url", url.toString(), "profile", profile, "proxyPath", proxyPath, "servletPath", servletPath});
                    if (this.engine == null) {
                        AwsApiGatewayLambdaRequestStreamHandler awsApiGatewayLambdaRequestStreamHandler = this;
                        synchronized (awsApiGatewayLambdaRequestStreamHandler) {
                            if (this.engine == null) {
                                this.engine = this.buildEngine(profile, servletPath);
                                this.engine.startup();
                            }
                        }
                    }
                    ListMap headers = new ListMap();
                    JSMap jsonHeaders = json.getMap((Object)"headers");
                    if (jsonHeaders != null) {
                        headers.putAll((Map)headers);
                    }
                    Map params = (jsonParams = json.getNode((Object)"queryStringParameters")) == null ? new HashMap() : (Map)jsonParams;
                    String body = json.getString((Object)"body");
                    if (method.equals("POST") && body != null) {
                        LinkedHashMap postParams = Utils.parseQueryString((String)body);
                        params.putAll(postParams);
                    }
                    Request req = new Request(method, url.toString(), body, params, headers);
                    Response res = new Response();
                    this.engine.service(req, res);
                    if (outputStream != null) {
                        this.writeResponse(res, outputStream);
                    }
                    if (ex == null) break block15;
                    if (config == null) break block16;
                }
                catch (Exception e1) {
                    block17: {
                        try {
                            ex = e1;
                            if (ex == null) break block15;
                            if (config == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (ex != null) {
                                if (config != null) {
                                    responseBody.put((Object)"config", config);
                                }
                                responseBody.put((Object)"error", (Object)Utils.getShortCause((Throwable)ex));
                                responseBody.put((Object)"request", (Object)JSParser.asJSNode((String)input));
                                JSMap responseJson = new JSMap();
                                responseJson.put((Object)"isBase64Encoded", (Object)false);
                                responseJson.put((Object)"statusCode", (Object)"500");
                                responseJson.put((Object)"headers", (Object)new JSMap(new Object[]{"Access-Control-Allow-Origin", "*"}));
                                responseJson.put((Object)"body", (Object)responseBody.toString());
                                OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
                                writer.write(responseJson.toString());
                                writer.close();
                            }
                            throw throwable;
                        }
                        responseBody.put((Object)"config", config);
                    }
                    responseBody.put((Object)"error", (Object)Utils.getShortCause((Throwable)ex));
                    responseBody.put((Object)"request", (Object)JSParser.asJSNode((String)input));
                    JSMap responseJson = new JSMap();
                    responseJson.put((Object)"isBase64Encoded", (Object)false);
                    responseJson.put((Object)"statusCode", (Object)"500");
                    responseJson.put((Object)"headers", (Object)new JSMap(new Object[]{"Access-Control-Allow-Origin", "*"}));
                    responseJson.put((Object)"body", (Object)responseBody.toString());
                    OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
                    writer.write(responseJson.toString());
                    writer.close();
                }
                responseBody.put((Object)"config", (Object)config);
            }
            responseBody.put((Object)"error", (Object)Utils.getShortCause((Throwable)ex));
            responseBody.put((Object)"request", (Object)JSParser.asJSNode((String)input));
            JSMap responseJson = new JSMap();
            responseJson.put((Object)"isBase64Encoded", (Object)false);
            responseJson.put((Object)"statusCode", (Object)"500");
            responseJson.put((Object)"headers", (Object)new JSMap(new Object[]{"Access-Control-Allow-Origin", "*"}));
            responseJson.put((Object)"body", (Object)responseBody.toString());
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
            writer.write(responseJson.toString());
            writer.close();
        }
    }

    protected Engine buildEngine(String configProfile, String servletPath) {
        System.out.println("TODO FIX ME: " + servletPath);
        System.out.println("TODO FIX ME: " + configProfile);
        Engine engine = new Engine();
        engine.withConfigProfile(configProfile);
        if (this.api == null) {
            this.api = this.buildApi(engine);
        }
        if (this.api != null) {
            engine.withApi(this.api);
        }
        return engine;
    }

    protected Api buildApi(Engine engine) {
        System.out.println("You can override buildApi(engine) to wire up your api in code: " + engine);
        return null;
    }

    protected void writeResponse(Response res, OutputStream outputStream) throws IOException {
    }

    public void debug(String msg) {
        if (this.isDebug()) {
            System.out.println(msg);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public Api getApi() {
        return this.api;
    }

    public void setApi(Api api) {
        this.api = api;
    }
}

