/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.dynamodb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.BatchGetItemOutcome;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.QueryOutcome;
import com.amazonaws.services.dynamodbv2.document.ScanOutcome;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.TableKeysAndAttributes;
import com.amazonaws.services.dynamodbv2.document.spec.BatchGetItemSpec;
import com.amazonaws.services.dynamodbv2.document.spec.GetItemSpec;
import com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Index;
import io.inversion.Property;
import io.inversion.Results;
import io.inversion.dynamodb.DynamoDb;
import io.inversion.query.From;
import io.inversion.query.Group;
import io.inversion.query.Order;
import io.inversion.query.Page;
import io.inversion.query.Projection;
import io.inversion.query.Query;
import io.inversion.query.Select;
import io.inversion.query.Where;
import io.inversion.rql.Term;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DynamoDbQuery
extends Query<DynamoDbQuery, DynamoDb, Select<Select<Select, DynamoDbQuery>, DynamoDbQuery>, From<From<From, DynamoDbQuery>, DynamoDbQuery>, Where<Where<Where, DynamoDbQuery>, DynamoDbQuery>, Group<Group<Group, DynamoDbQuery>, DynamoDbQuery>, Order<Order<Order, DynamoDbQuery>, DynamoDbQuery>, Page<Page<Page, DynamoDbQuery>, DynamoDbQuery>> {
    public static final Map<String, String> OPERATOR_MAP = new HashMap<String, String>();
    public static final Map<String, String> FUNCTION_MAP = new HashMap<String, String>();
    Table dynamoTable = null;
    Index index;
    Term partKey = null;
    Term sortKey = null;

    public DynamoDbQuery() {
    }

    public DynamoDbQuery(DynamoDb db, Collection table, List<Term> terms) {
        super((Db)db, table, terms, new String[0]);
    }

    protected Where createWhere() {
        Where where = new Where(this){

            protected boolean isInvalidColumn(Collection collection, String column) {
                boolean invalid = column.startsWith("_") || !column.matches("^[a-zA-Z0-9_]+$");
                return invalid;
            }
        };
        where.withFunctions(new String[]{"_key", "eq", "ne", "gt", "ge", "lt", "le", "w", "wo", "sw", "nn", "n", "emp", "nemp", "in", "out", "and", "or", "not", "attribute_not_exists", "attribute_exists"});
        return where;
    }

    protected boolean addTerm(String token, Term term) {
        String val;
        int firstWc;
        this.index = null;
        if (term.hasToken(new String[]{"n", "nn", "emp", "nemp"})) {
            if (term.size() > 1) {
                throw ApiException.new400BadRequest((String)"The n() and nn() functions only take one column name arg.", (Object[])new Object[0]);
            }
            if (term.hasToken(new String[]{"n", "emp"})) {
                Term eqNull = Term.term((Term)term.getParent(), (String)"eq", (Object[])new Object[]{term.getTerm(0), "null"});
                Term attrNotExists = Term.term(null, (String)"attribute_not_exists", (Object[])new Object[]{term.getTerm(0)});
                term = Term.term((Term)term.getParent(), (String)"or", (Object[])new Object[]{attrNotExists, eqNull});
            } else if (term.hasToken(new String[]{"nn", "nemp"})) {
                Term neNull = Term.term((Term)term.getParent(), (String)"ne", (Object[])new Object[]{term.getTerm(0), "null"});
                Term attrExists = Term.term(null, (String)"attribute_exists", (Object[])new Object[]{term.getTerm(0)});
                term = Term.term((Term)term.getParent(), (String)"and", (Object[])new Object[]{attrExists, neNull});
            }
        }
        if (term.hasToken(new String[]{"like"}) && (firstWc = (val = term.getToken(1)).indexOf("*")) > -1) {
            int wcCount = val.length() - val.replace("*", "").length();
            int lastWc = val.lastIndexOf("*");
            if (wcCount > 2 || wcCount == 1 && firstWc != val.length() - 1 || wcCount == 2 && (firstWc != 0 || lastWc != val.length() - 1)) {
                throw ApiException.new400BadRequest((String)"DynamoDb only supports a 'value*' or '*value*' wildcard formats which are equivalant to the 'sw' and 'w' operators.", (Object[])new Object[0]);
            }
            boolean sw = firstWc == val.length() - 1;
            val = val.replace("*", "");
            term.getTerm(1).withToken(val);
            if (sw) {
                term.withToken("sw");
            } else {
                term.withToken("w");
            }
        }
        if (term.hasToken(new String[]{"sw"})) {
            for (val = term.getTerm(1).getToken(); val != null && val.endsWith("*"); val = val.substring(0, val.length() - 1)) {
            }
            term.getTerm(1).withToken(val);
        }
        if (term.hasToken(new String[]{"wo"})) {
            term.withToken("w");
            term = Term.term(null, (String)"not", (Object[])new Object[]{term});
        }
        return super.addTerm(token, term);
    }

    public Table getDynamoTable() {
        return this.dynamoTable;
    }

    public DynamoDbQuery withDynamoTable(Table dynamoTable) {
        this.dynamoTable = dynamoTable;
        return this;
    }

    public Results doSelect() throws ApiException {
        Results.LAST_QUERY = null;
        try {
            return this.doSelect0();
        }
        catch (Exception ex) {
            if (Results.LAST_QUERY != null) {
                System.out.println("Error after query: " + Results.LAST_QUERY);
                System.out.println(ex.getMessage());
            }
            Utils.rethrow((Throwable)ex);
            return null;
        }
    }

    protected Results doSelect0() throws Exception {
        Projection proj;
        String type;
        Results results = this.doSelect1();
        if (results.size() > 0 && this.index != null && !(type = this.index.getType()).equalsIgnoreCase("primary") && (proj = this.index.getProjection()) != null) {
            HashSet<String> includeColumns = new HashSet<String>(this.getSelect().getIncludeColumns());
            if (includeColumns.size() == 0) {
                for (Property p : this.collection.getProperties()) {
                    includeColumns.add(p.getColumnName());
                }
            }
            HashSet<String> projectionColumns = new HashSet<String>();
            for (String column : proj.keySet()) {
                projectionColumns.add(column);
            }
            boolean columnsCovered = true;
            for (String includeCol : includeColumns) {
                if (projectionColumns.contains(includeCol)) continue;
                columnsCovered = false;
                break;
            }
            if (!columnsCovered) {
                results.withRows(this.batchGet(results.getRows()));
            }
        }
        return results;
    }

    List<Map<String, Object>> batchGet(List<Map<String, Object>> rows) {
        LinkedHashMap<String, Map> found = new LinkedHashMap<String, Map>();
        AmazonDynamoDB dynamoClient = ((DynamoDb)this.db).getDynamoClient();
        DynamoDB dynamoDb = new DynamoDB(dynamoClient);
        Index primaryIdx = this.collection.getResourceIndex();
        BatchGetItemSpec spec = new BatchGetItemSpec();
        TableKeysAndAttributes tk = new TableKeysAndAttributes(this.collection.getTableName());
        for (Map<String, Object> row : rows) {
            PrimaryKey pk = new PrimaryKey();
            for (Property prop : primaryIdx.getProperties()) {
                pk.addComponent(prop.getColumnName(), row.get(prop.getColumnName()));
            }
            tk.addPrimaryKey(pk);
            spec.withTableKeyAndAttributes(new TableKeysAndAttributes[]{tk});
        }
        BatchGetItemOutcome out = dynamoDb.batchGetItem(new TableKeysAndAttributes[]{tk});
        List items = (List)out.getTableItems().get(this.collection.getTableName());
        for (Item item : items) {
            Map map = item.asMap();
            String key = this.collection.encodeKeyFromColumnNames(map);
            found.put(key, map);
        }
        KeysAndAttributes unprocessed = (KeysAndAttributes)out.getUnprocessedKeys().get(this.collection.getTableName());
        if (unprocessed != null) {
            throw ApiException.new500InternalServerError((String)"Unable to retrieve all items", (Object[])new Object[0]);
        }
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : rows) {
            String key = this.collection.encodeKeyFromColumnNames(row);
            results.add((Map)found.get(key));
        }
        return results;
    }

    protected Results doSelect1() throws Exception {
        com.amazonaws.services.dynamodbv2.document.Index dynamoIndex = null;
        Results result = new Results((Query)this);
        Object spec = this.getSelectSpec();
        Index index = this.calcIndex();
        if (!this.isDryRun() && index != null && index != this.collection.getIndex("Primary Index")) {
            dynamoIndex = this.dynamoTable.getIndex(index.getName());
        }
        if (spec instanceof GetItemSpec) {
            Item item;
            GetItemSpec gis = (GetItemSpec)spec;
            StringBuilder debug = new StringBuilder("DynamoDb: ").append("GetItemSpec").append((String)(index != null ? ":'" + index.getName() + "'" : ""));
            debug.append(" key: ").append(gis.getKeyComponents());
            result.withTestQuery(debug.toString());
            Chain.debug((String)debug.toString(), (Object[])new Object[0]);
            if (!this.isDryRun() && (item = this.dynamoTable.getItem(gis)) != null) {
                result.withRow(item.asMap());
            }
        } else if (spec instanceof QuerySpec) {
            QuerySpec qs = (QuerySpec)spec;
            StringBuilder debug = new StringBuilder("DynamoDb: ").append("QuerySpec").append((String)(index != null ? ":'" + index.getName() + "'" : ""));
            if (qs.getMaxResultSize() != 100) {
                debug.append(" maxResultSize=").append(qs.getMaxResultSize());
            }
            if (qs.getNameMap() != null) {
                debug.append(" nameMap=").append(qs.getNameMap());
            }
            if (qs.getValueMap() != null) {
                debug.append(" valueMap=").append(qs.getValueMap());
            }
            if (qs.getFilterExpression() != null) {
                debug.append(" filterExpression='").append(qs.getFilterExpression()).append("'");
            }
            if (qs.getProjectionExpression() != null) {
                debug.append(" projectionExpression='").append(qs.getProjectionExpression()).append("'");
            }
            if (qs.getExclusiveStartKey() != null) {
                debug.append(" exclusiveStartKey='").append(qs.getExclusiveStartKey());
            }
            if (qs.getKeyConditionExpression() != null) {
                debug.append(" keyConditionExpression='").append(qs.getKeyConditionExpression()).append("'");
            }
            if (!this.getOrder().isAsc(0)) {
                debug.append(" scanIndexForward=false");
            }
            result.withTestQuery(debug.toString());
            Chain.debug((String)debug.toString(), (Object[])new Object[0]);
            if (!this.isDryRun()) {
                com.amazonaws.services.dynamodbv2.document.Index queryApi = dynamoIndex != null ? dynamoIndex : this.dynamoTable;
                ItemCollection queryResult = queryApi.query(qs);
                for (Item item : queryResult) {
                    result.withRow(item.asMap());
                }
                result.withNext(this.after(index, ((QueryOutcome)queryResult.getLastLowLevelResult()).getQueryResult().getLastEvaluatedKey()));
            }
        } else if (spec instanceof ScanSpec) {
            ScanSpec ss = (ScanSpec)spec;
            StringBuilder debug = new StringBuilder("DynamoDb: ").append("ScanSpec").append((String)(index != null ? ":'" + index.getName() + "'" : ""));
            if (ss.getMaxResultSize() != 100) {
                debug.append(" maxResultSize=").append(ss.getMaxResultSize());
            }
            if (ss.getNameMap() != null) {
                debug.append(" nameMap=").append(ss.getNameMap());
            }
            if (ss.getValueMap() != null) {
                debug.append(" valueMap=").append(ss.getValueMap());
            }
            if (ss.getFilterExpression() != null) {
                debug.append(" filterExpression='").append(ss.getFilterExpression()).append("'");
            }
            if (ss.getProjectionExpression() != null) {
                debug.append(" projectionExpression='").append(ss.getProjectionExpression()).append("'");
            }
            if (ss.getExclusiveStartKey() != null) {
                debug.append(" exclusiveStartKey='").append(ss.getExclusiveStartKey());
            }
            result.withTestQuery(debug.toString());
            Chain.debug((String)debug.toString(), (Object[])new Object[0]);
            if (!this.isDryRun()) {
                com.amazonaws.services.dynamodbv2.document.Index scanApi = dynamoIndex != null ? dynamoIndex : this.dynamoTable;
                ItemCollection scanResult = scanApi.scan(ss);
                for (Item item : scanResult) {
                    result.withRow(item.asMap());
                }
                result.withNext(this.after(index, ((ScanOutcome)scanResult.getLastLowLevelResult()).getScanResult().getLastEvaluatedKey()));
            }
        }
        return result;
    }

    protected List<Term> after(Index index, Map<String, AttributeValue> attrs) {
        if (attrs == null) {
            return Collections.EMPTY_LIST;
        }
        Term after = Term.term(null, (String)"after", (Object[])new Object[0]);
        if (index != null) {
            after.withTerm(Term.term((Term)after, (String)index.getColumnName(0), (Object[])new Object[0]));
            after.withTerm(Term.term((Term)after, (String)this.getValue(attrs.get(index.getColumnName(0))).toString(), (Object[])new Object[0]));
            if (index.getColumnName(1) != null) {
                after.withTerm(Term.term((Term)after, (String)index.getColumnName(1), (Object[])new Object[0]));
                after.withTerm(Term.term((Term)after, (String)this.getValue(attrs.get(index.getColumnName(1))).toString(), (Object[])new Object[0]));
            }
        } else {
            for (String key : attrs.keySet()) {
                after.withTerm(Term.term((Term)after, (String)key, (Object[])new Object[0]));
                after.withTerm(Term.term((Term)after, (String)this.getValue(attrs.get(key)).toString(), (Object[])new Object[0]));
            }
        }
        return Utils.asList((Object[])new Object[]{after});
    }

    protected Object getValue(AttributeValue v) {
        if (v.getS() != null) {
            return v.getS();
        }
        if (v.getN() != null) {
            return v.getN();
        }
        if (v.getB() != null) {
            return v.getB();
        }
        if (v.getSS() != null) {
            return v.getSS();
        }
        if (v.getNS() != null) {
            return v.getNS();
        }
        if (v.getBS() != null) {
            return v.getBS();
        }
        if (v.getM() != null) {
            return v.getM();
        }
        if (v.getL() != null) {
            return v.getL();
        }
        if (v.getNULL() != null) {
            return v.getNULL();
        }
        if (v.getBOOL() != null) {
            return v.getBOOL();
        }
        throw ApiException.new500InternalServerError((String)"Unable to get value from AttributeValue: {}", (Object[])new Object[]{v});
    }

    protected Index calcIndex() {
        String sortBy = this.order.getProperty(0);
        Term after = this.getPage().getAfter();
        if (after != null) {
            String afterHashKeyCol = this.getCollection().getProperty(after.getToken(0)).getColumnName();
            String afterSortKeyCol = after.size() > 2 ? this.getCollection().getProperty(after.getToken(2)).getColumnName() : null;
            for (Index idx : this.collection.getIndexes()) {
                if (!Utils.equal((Object)idx.getColumnName(0), (Object)afterHashKeyCol) || !Utils.equal((Object)idx.getColumnName(1), (Object)afterSortKeyCol)) continue;
                this.index = idx;
                this.partKey = this.findTerm(afterHashKeyCol, new String[]{"eq"});
                if (this.partKey == null) continue;
                if (afterSortKeyCol == null) break;
                this.sortKey = this.findTerm(afterSortKeyCol, new String[]{"eq"});
                if (this.sortKey != null) break;
                this.sortKey = this.findTerm(afterSortKeyCol, new String[]{"gt", "ne", "gt", "ge", "lt", "le", "sw", "ew", "in", "out", "n", "nn"});
                if (this.sortKey == null || !Utils.in((Object)this.sortKey.getToken(), (Object[])new Object[]{"in", "out"})) break;
                this.partKey = null;
                this.sortKey = null;
            }
            if (sortBy != null && !sortBy.equalsIgnoreCase(afterSortKeyCol)) {
                throw ApiException.new400BadRequest((String)"The requested sort key does not match the supplied 'after' continuation token.", (Object[])new Object[0]);
            }
        }
        if (this.index == null) {
            Index foundIndex = null;
            Term foundPartKey = null;
            Term foundSortKey = null;
            Iterator iterator = this.getCollection().getIndexes().iterator();
            while (iterator.hasNext()) {
                Term sortKey;
                Term partKey;
                Index idx;
                Index index = idx = (Index)iterator.next();
                String partCol = index.getColumnName(0);
                String sortCol = index.getColumnName(1);
                if (sortBy != null && !sortBy.equalsIgnoreCase(sortCol) || (partKey = this.findTerm(partCol, new String[]{"eq"})) == null && sortBy == null || (sortKey = this.findTerm(sortCol, new String[]{"eq"})) == null && (sortKey = this.findTerm(sortCol, new String[]{"gt", "ne", "gt", "ge", "lt", "le", "sw", "ew", "in", "out", "n", "nn"})) != null && Utils.in((Object)sortKey.getToken(), (Object[])new Object[]{"in", "out"})) continue;
                boolean use = false;
                if (foundPartKey == null && partKey != null) {
                    use = true;
                } else if (sortKey == null && foundSortKey != null) {
                    use = false;
                } else if (foundIndex == null || sortKey != null && foundSortKey == null || sortKey != null && sortKey.hasToken(new String[]{"eq"}) && !foundSortKey.hasToken(new String[]{"eq"})) {
                    use = true;
                }
                if (!use) continue;
                foundIndex = index;
                foundPartKey = partKey;
                foundSortKey = sortKey;
            }
            if (sortBy != null && foundIndex == null) {
                throw ApiException.new400BadRequest((String)"Unable to find valid index to query.  The requested sort field '{}' must be the sort key of the primary index, the sort key of a global secondary index, or a local secondary secondary index.", (Object[])new Object[]{sortBy});
            }
            if (foundPartKey == null && sortBy != null && !this.order.isAsc(0)) {
                throw ApiException.new400BadRequest((String)"Unable to find valid index to query.  A descending sort on '{}' is only possible when a partition key value is supplied.", (Object[])new Object[]{sortBy});
            }
            this.index = foundIndex;
            this.partKey = foundPartKey;
            this.sortKey = foundSortKey;
        }
        return this.index;
    }

    Term findSortKeyTerm(String sortCol) {
        Term sortKey = this.findTerm(sortCol, new String[0]);
        if (sortKey != null && !Utils.in((Object)sortKey.getToken(), (Object[])new Object[]{"eq", "gt", "ne", "gt", "ge", "lt", "le", "sw"})) {
            return null;
        }
        return sortKey;
    }

    public Term getPartKey() {
        if (this.index == null) {
            this.calcIndex();
        }
        return this.partKey;
    }

    public Term getSortKey() {
        if (this.index == null) {
            this.calcIndex();
        }
        return this.sortKey;
    }

    public Object getSelectSpec() {
        HashMap nameMap = new HashMap();
        HashMap valueMap = new HashMap();
        StringBuilder keyExpr = new StringBuilder();
        StringBuilder filterExpr = new StringBuilder();
        Index index = this.calcIndex();
        if (index != null && Utils.equal((Object)"Primary Index", (Object)index.getName()) && this.partKey != null && this.sortKey != null && this.sortKey.hasToken(new String[]{"eq"}) && this.sortKey.getTerm(1).isLeaf()) {
            String partKeyCol = this.partKey.getToken(0);
            String type = this.collection.getProperty(partKeyCol).getType();
            DynamoDb cfr_ignored_0 = (DynamoDb)this.getDb();
            Object partKeyVal = DynamoDb.castJsonInput((String)type, (Object)this.partKey.getToken(1));
            String sortKeyCol = this.sortKey.getToken(0);
            DynamoDb cfr_ignored_1 = (DynamoDb)this.getDb();
            Object sortKeyVal = DynamoDb.castJsonInput((String)this.collection.getProperty(sortKeyCol).getType(), (Object)this.sortKey.getToken(1));
            return new GetItemSpec().withPrimaryKey(partKeyCol, partKeyVal, sortKeyCol, sortKeyVal);
        }
        if (this.partKey != null) {
            this.toString(keyExpr, this.partKey, nameMap, valueMap);
        }
        if (this.sortKey != null) {
            this.toString(keyExpr, this.sortKey, nameMap, valueMap);
        }
        for (Term term : this.getWhere().getTerms()) {
            if (term == this.partKey || term == this.sortKey) continue;
            this.toString(filterExpr, term, nameMap, valueMap);
        }
        boolean doQuery = this.partKey != null && this.partKey.getTerm(1).isLeaf();
        int pageSize = this.getPage().getPageSize();
        String projectionExpression = null;
        List columns = this.getSelect().getIncludeColumns();
        if (columns.size() > 0) {
            projectionExpression = Utils.implode((String)",", (Object[])new Object[]{columns});
        }
        if (doQuery) {
            QuerySpec querySpec = new QuerySpec();
            querySpec.withMaxResultSize(pageSize);
            querySpec.withScanIndexForward(this.getOrder().isAsc(0));
            Term after = this.getPage().getAfter();
            if (after != null) {
                Object sortValue;
                Property afterSortKeyCol;
                Property afterHashKeyCol = this.getCollection().getProperty(after.getToken(0));
                Property property = afterSortKeyCol = after.size() > 2 ? this.getCollection().getProperty(after.getToken(2)) : null;
                if (afterHashKeyCol == null || after.size() > 2 && afterSortKeyCol == null) {
                    throw ApiException.new400BadRequest((String)"Invalid column in 'after' key: {}", (Object[])new Object[]{after});
                }
                Object hashValue = ((DynamoDb)this.db).castJsonInput(afterHashKeyCol, after.getToken(1));
                Object object = sortValue = afterSortKeyCol != null ? ((DynamoDb)this.db).castJsonInput(afterSortKeyCol, after.getToken(3)) : null;
                if (afterSortKeyCol != null) {
                    querySpec.withExclusiveStartKey(afterHashKeyCol.getColumnName(), hashValue, afterSortKeyCol.getColumnName(), sortValue);
                } else {
                    querySpec.withExclusiveStartKey(afterHashKeyCol.getColumnName(), hashValue);
                }
            }
            if (!Utils.empty((Object[])new Object[]{projectionExpression})) {
                querySpec.withProjectionExpression(projectionExpression);
            }
            if (keyExpr.length() > 0) {
                querySpec.withKeyConditionExpression(keyExpr.toString());
            }
            if (filterExpr.length() > 0) {
                querySpec.withFilterExpression(filterExpr.toString());
            }
            if (nameMap.size() > 0) {
                querySpec.withNameMap(nameMap);
            }
            if (valueMap.size() > 0) {
                querySpec.withValueMap(valueMap);
            }
            return querySpec;
        }
        ScanSpec scanSpec = new ScanSpec();
        scanSpec.withMaxResultSize(pageSize);
        Term after = this.getPage().getAfter();
        if (after != null) {
            Object sortValue;
            Property afterSortKeyCol;
            Property afterHashKeyCol = this.getCollection().getProperty(after.getToken(0));
            Property property = afterSortKeyCol = after.size() > 2 ? this.getCollection().getProperty(after.getToken(2)) : null;
            if (afterHashKeyCol == null || after.size() > 2 && afterSortKeyCol == null) {
                throw ApiException.new400BadRequest((String)"Invalid column in 'after' key: {}", (Object[])new Object[0]);
            }
            Object hashValue = ((DynamoDb)this.db).castJsonInput(afterHashKeyCol, after.getToken(1));
            Object object = sortValue = afterSortKeyCol != null ? ((DynamoDb)this.db).castJsonInput(afterSortKeyCol, after.getToken(3)) : null;
            if (afterSortKeyCol != null) {
                scanSpec.withExclusiveStartKey(afterHashKeyCol.getColumnName(), hashValue, afterSortKeyCol.getColumnName(), sortValue);
            } else {
                scanSpec.withExclusiveStartKey(afterHashKeyCol.getColumnName(), hashValue);
            }
        }
        if (!Utils.empty((Object[])new Object[]{projectionExpression})) {
            scanSpec.withProjectionExpression(projectionExpression);
        }
        if (filterExpr.length() > 0) {
            scanSpec.withFilterExpression(filterExpr.toString());
        }
        if (nameMap.size() > 0) {
            scanSpec.withNameMap(nameMap);
        }
        if (valueMap.size() > 0) {
            scanSpec.withValueMap(valueMap);
        }
        return scanSpec;
    }

    String toString(StringBuilder buff, Term term, Map nameMap, Map valueMap) {
        this.space(buff);
        String lc = term.getToken().toLowerCase();
        String op = OPERATOR_MAP.get(lc);
        String func = FUNCTION_MAP.get(lc);
        if (term.hasToken(new String[]{"not"})) {
            if (buff.length() > 0) {
                this.space(buff).append("and ");
            }
            buff.append("(NOT ").append(this.toString(new StringBuilder(), term.getTerm(0), nameMap, valueMap)).append(")");
        } else if (term.hasToken(new String[]{"and", "or"})) {
            buff.append("(");
            for (int i = 0; i < term.getNumTerms(); ++i) {
                buff.append(this.toString(new StringBuilder(), term.getTerm(i), nameMap, valueMap));
                if (i >= term.getNumTerms() - 1) continue;
                this.space(buff).append(term.getToken()).append(" ");
            }
            buff.append(")");
        } else if (term.hasToken(new String[]{"in", "out"})) {
            String col = term.getToken(0);
            String nameKey = "#var" + (nameMap.size() + 1);
            nameMap.put(nameKey, col);
            if (buff.length() > 0) {
                this.space(buff).append("and ");
            }
            buff.append("(");
            buff.append(term.hasToken(new String[]{"out"}) ? "NOT " : "");
            buff.append(nameKey).append(" IN (");
            for (int i = 1; i < term.size(); ++i) {
                if (i > 1) {
                    buff.append(", ");
                }
                buff.append(this.toString(new StringBuilder(), term.getTerm(i), nameMap, valueMap));
            }
            buff.append("))");
        } else if (op != null) {
            String col = term.getToken(0);
            String nameKey = "#var" + (nameMap.size() + 1);
            nameMap.put(nameKey, col);
            String expr = this.toString(new StringBuilder(), term.getTerm(1), nameMap, valueMap);
            if (buff.length() > 0) {
                this.space(buff).append("and ");
            }
            buff.append("(").append(nameKey).append(" ").append(op).append(" ").append(expr).append(")");
        } else if (func != null) {
            if (buff.length() > 0) {
                this.space(buff).append("and ");
            }
            String col = term.getToken(0);
            String nameKey = "#var" + (nameMap.size() + 1);
            nameMap.put(nameKey, col);
            if (term.size() > 1) {
                String expr = this.toString(new StringBuilder(), term.getTerm(1), nameMap, valueMap);
                this.space(buff).append(func).append("(").append(nameKey).append(",").append(expr).append(")");
            } else {
                this.space(buff).append(func).append("(").append(nameKey).append(")");
            }
        } else if (term.isLeaf()) {
            String colName = term.getParent().getToken(0);
            Property col = this.collection.getProperty(colName);
            Object value = ((DynamoDb)this.db).castJsonInput(col, term.getToken());
            if ("null".equalsIgnoreCase("" + value)) {
                value = null;
            }
            String key = ":val" + (valueMap.size() + 1);
            valueMap.put(key, value);
            this.space(buff).append(key);
        }
        return buff.toString();
    }

    StringBuilder space(StringBuilder buff) {
        if (buff.length() > 0 && buff.charAt(buff.length() - 1) != ' ') {
            buff.append(' ');
        }
        return buff;
    }

    static {
        OPERATOR_MAP.put("eq", "=");
        OPERATOR_MAP.put("ne", "<>");
        OPERATOR_MAP.put("gt", ">");
        OPERATOR_MAP.put("ge", ">=");
        OPERATOR_MAP.put("lt", "<");
        OPERATOR_MAP.put("le", "<=");
        FUNCTION_MAP.put("w", "contains");
        FUNCTION_MAP.put("sw", "begins_with");
        FUNCTION_MAP.put("attribute_not_exists", "attribute_not_exists");
        FUNCTION_MAP.put("attribute_exists", "attribute_exists");
    }
}

