/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.dynamodb;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.spec.UpdateItemSpec;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionSizeLimitExceededException;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LimitExceededException;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputExceededException;
import com.amazonaws.services.dynamodbv2.model.RequestLimitExceededException;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Index;
import io.inversion.Property;
import io.inversion.Results;
import io.inversion.dynamodb.DynamoDbQuery;
import io.inversion.rql.Term;
import io.inversion.utils.Utils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class DynamoDb<T extends DynamoDb>
extends Db<T> {
    public static final String PRIMARY_INDEX_NAME = "Primary Index";
    public static final String PRIMARY_INDEX_TYPE = "primary";
    public static final String LOCAL_SECONDARY_INDEX_TYPE = "localsecondary";
    public static final String GLOBAL_SECONDARY_INDEX_TYPE = "globalsecondary";
    protected final int batchMax = 20;
    protected String awsAccessKey = null;
    protected String awsSecretKey = null;
    protected String awsRegion = "us-east-1";
    protected String awsEndpoint = null;
    protected transient AmazonDynamoDB dynamoClient = null;

    public DynamoDb() {
        this.withType("dynamodb");
    }

    public DynamoDb(String name, String includeTables) {
        this();
        this.withName(name);
        this.withIncludeTables(new String[]{includeTables});
    }

    public static Index findIndexByName(Collection coll, String name) {
        if (coll != null && coll.getIndexes() != null) {
            for (Index index : coll.getIndexes()) {
                if (!index.getName().equals(name)) continue;
                return index;
            }
        }
        return null;
    }

    protected static String getTypeStringFromObject(Object obj) {
        if (obj instanceof Number) {
            return "N";
        }
        if (obj instanceof Boolean) {
            return "BOOL";
        }
        return "S";
    }

    public static AmazonDynamoDB buildDynamoClient(String awsRegion, String awsAccessKey, String awsSecretKey, String awsEndpoint) {
        AmazonDynamoDBClientBuilder builder = AmazonDynamoDBClientBuilder.standard();
        if (!Utils.empty((Object[])new Object[]{awsRegion})) {
            if (!Utils.empty((Object[])new Object[]{awsEndpoint})) {
                AwsClientBuilder.EndpointConfiguration endpointConfig = new AwsClientBuilder.EndpointConfiguration(awsEndpoint, awsRegion);
                builder.withEndpointConfiguration(endpointConfig);
            } else {
                builder.withRegion(awsRegion);
            }
        }
        if (!Utils.empty((Object[])new Object[]{awsAccessKey}) && !Utils.empty((Object[])new Object[]{awsSecretKey})) {
            BasicAWSCredentials creds = new BasicAWSCredentials(awsAccessKey, awsSecretKey);
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)creds));
        }
        AmazonDynamoDB dynamoClient = (AmazonDynamoDB)builder.build();
        return dynamoClient;
    }

    public Results doSelect(Collection table, List<Term> columnMappedTerms) throws ApiException {
        return (Results)this.run(() -> this.doSelect0(table, columnMappedTerms));
    }

    public Results doSelect0(Collection table, List<Term> columnMappedTerms) throws ApiException {
        DynamoDbQuery query = new DynamoDbQuery(this, table, columnMappedTerms).withDynamoTable(this.getDynamoTable(table));
        Results result = query.doSelect();
        return result;
    }

    public List<String> doUpsert(Collection collection, List<Map<String, Object>> rows) throws ApiException {
        ArrayList<String> keys = new ArrayList<String>();
        AmazonDynamoDB dynamoClient = this.getDynamoClient();
        DynamoDB dynamoDb = new DynamoDB(dynamoClient);
        Table table = dynamoDb.getTable(collection.getTableName());
        ArrayList updates = new ArrayList();
        for (int i = 0; i < rows.size(); ++i) {
            Map<String, Object> row = rows.get(i);
            String key = collection.encodeKeyFromColumnNames(row);
            keys.add(key);
            UpdateItemSpec spec = this.buildUpdateItemSpec(collection, row);
            table.updateItem(spec);
        }
        return keys;
    }

    protected UpdateItemSpec buildUpdateItemSpec(Collection collection, Map<String, Object> row) {
        Index idx = collection.getResourceIndex();
        LinkedHashSet keyProps = new LinkedHashSet(idx.getColumnNames());
        LinkedHashMap<String, Object> keyMap = new LinkedHashMap<String, Object>();
        PrimaryKey primaryKey = new PrimaryKey();
        for (String col : idx.getColumnNames()) {
            primaryKey.addComponent(col, row.get(col));
            keyMap.put(col, row.get(col));
        }
        LinkedHashMap<CallSite, String> nameMap = new LinkedHashMap<CallSite, String>();
        LinkedHashMap<CallSite, Object> valueMap = new LinkedHashMap<CallSite, Object>();
        StringBuilder addExpression = null;
        StringBuilder setExpression = null;
        StringBuilder removeExpression = null;
        StringBuilder conditionExpression = null;
        for (Property property : collection.getProperties()) {
            if (property.isRevisionColumn()) {
                if (addExpression == null) {
                    addExpression = new StringBuilder("ADD ");
                } else {
                    addExpression.append(", ");
                }
                String varName = "#var" + nameMap.size();
                nameMap.put((CallSite)((Object)varName), property.getColumnName());
                String valName = ":val" + valueMap.size();
                valueMap.put((CallSite)((Object)valName), 1);
                addExpression.append(varName).append(" ").append(valName);
                continue;
            }
            if (!property.isTimestampColumn()) continue;
            try {
                long now = System.currentTimeMillis();
                Object str = row.get(property.getColumnName());
                if (str != null) {
                    long ts = Long.parseLong(str.toString());
                    if (Math.abs(ts - now) <= 100L) continue;
                    row.put(property.getColumnName(), now);
                    continue;
                }
                row.put(property.getColumnName(), now);
            }
            catch (Exception ex) {
                throw ApiException.new400BadRequest((String)"Your {} field is setup as a timestamp field but is not a the right format.  It should be epoc time or simply left blank to have it auto updated.", (Object[])new Object[0]);
            }
        }
        for (String string : row.keySet()) {
            String varName;
            if (keyProps.contains(string)) continue;
            Object value = row.get(string);
            Property property = collection.getPropertyByColumnName(string);
            if (property != null && property.isRevisionColumn()) {
                Object rev = row.get(string);
                if (rev == null) continue;
                if (conditionExpression == null) {
                    conditionExpression = new StringBuilder();
                } else {
                    conditionExpression.append(" AND ");
                }
                String varName2 = "#var" + nameMap.size();
                nameMap.put((CallSite)((Object)varName2), string);
                String valName = ":val" + valueMap.size();
                valueMap.put((CallSite)((Object)valName), value);
                conditionExpression.append("(");
                conditionExpression.append("attribute_not_exists(").append(varName2).append(") OR ").append(varName2).append(" = ").append(valName);
                conditionExpression.append(")");
                continue;
            }
            if (value != null) {
                varName = "#var" + nameMap.size();
                nameMap.put((CallSite)((Object)varName), string);
                String valName = ":val" + valueMap.size();
                valueMap.put((CallSite)((Object)valName), value);
                if (setExpression == null) {
                    setExpression = new StringBuilder("SET ");
                } else {
                    setExpression.append(", ");
                }
                setExpression.append(varName).append(" = ").append(valName);
                continue;
            }
            varName = "#var" + nameMap.size();
            nameMap.put((CallSite)((Object)varName), string);
            if (removeExpression == null) {
                removeExpression = new StringBuilder("REMOVE ");
            } else {
                removeExpression.append(", ");
            }
            removeExpression.append(varName);
        }
        Object updateExpression = "";
        if (setExpression != null) {
            updateExpression = setExpression.toString();
        }
        if (removeExpression != null) {
            updateExpression = (String)updateExpression + " " + removeExpression.toString();
        }
        if (addExpression != null) {
            updateExpression = (String)updateExpression + " " + addExpression;
        }
        updateExpression = ((String)updateExpression).trim();
        UpdateItemSpec updateItemSpec = new UpdateItemSpec();
        updateItemSpec.withPrimaryKey(primaryKey);
        if (!Utils.empty((Object[])new Object[]{updateExpression})) {
            updateItemSpec.withUpdateExpression((String)updateExpression);
        }
        if (!Utils.empty((Object[])new Object[]{conditionExpression})) {
            updateItemSpec.withConditionExpression(conditionExpression.toString());
        }
        if (nameMap.size() > 0) {
            updateItemSpec.withNameMap(nameMap);
        }
        if (valueMap.size() > 0) {
            updateItemSpec.withValueMap(valueMap);
        }
        StringBuilder debug = new StringBuilder("DynamoDb: UpdateItemSpec");
        debug.append(" key = ").append(keyMap);
        debug.append(" updateExpression=").append((String)updateExpression);
        if (!Utils.empty((Object[])new Object[]{conditionExpression})) {
            debug.append(" conditionExpression=").append((CharSequence)conditionExpression);
        }
        debug.append(" nameMap=").append(nameMap);
        debug.append(" valueMap=").append(valueMap);
        String out = debug.toString();
        out.replace("\r\n", "\n");
        out.replace("\n", " ");
        Chain.debug((String)out, (Object[])new Object[0]);
        System.out.println(out);
        return updateItemSpec;
    }

    public void doDelete(Collection table, List<Map<String, Object>> indexValues) throws ApiException {
        for (Map<String, Object> row : indexValues) {
            this.deleteRow(table, row);
        }
    }

    public Object run(Callable statement) {
        try {
            return statement.call();
        }
        catch (ConditionalCheckFailedException ex) {
            throw new ApiException((Throwable)null, "409 Conflict", "A submitted resource is out of date and could not be updated.  Please refresh your copy before submitting again.", new Object[0]);
        }
        catch (ItemCollectionSizeLimitExceededException ex) {
            throw new ApiException((Throwable)null, "507 Conflict", "Collection size exceeded", new Object[0]);
        }
        catch (LimitExceededException ex) {
            throw new ApiException((Throwable)null, "429 Too Many Requests", "Too many requests.", new Object[0]);
        }
        catch (ProvisionedThroughputExceededException ex) {
            throw new ApiException((Throwable)null, "429 Too Many Requests", "Too many requests.", new Object[0]);
        }
        catch (RequestLimitExceededException ex) {
            throw new ApiException((Throwable)null, "429 Too Many Requests", "Too many requests.", new Object[0]);
        }
        catch (AmazonServiceException ase) {
            String errorCode = ase.getErrorCode();
            if ("ValidationException".equalsIgnoreCase(errorCode)) {
                throw ApiException.new400BadRequest((String)ase.getMessage(), (Object[])new Object[0]);
            }
            throw new ApiException((Throwable)null, "500 Internal Server Error", "Could not complete operation. Error Message: , HTTP Status: {}, AWS Error Code: {}, Error Type: {}, Request ID: {}", new Object[0]);
        }
        catch (AmazonClientException ace) {
            throw new ApiException("500 Internal Server Error", new Object[]{"Internal error occurred communicating with DynamoDB. Error Message: {}", ace.getMessage()});
        }
        catch (Exception ex) {
            throw new ApiException((Throwable)ex);
        }
    }

    public void deleteRow(Collection table, Map<String, Object> row) throws ApiException {
        Table dynamo = this.getDynamoTable(table);
        Index pk = table.getResourceIndex();
        if (pk.size() == 1) {
            dynamo.deleteItem(pk.getProperty(0).getColumnName(), row.get(pk.getProperty(0).getColumnName()));
        } else if (pk.size() == 2) {
            dynamo.deleteItem(pk.getProperty(0).getColumnName(), row.get(pk.getProperty(0).getColumnName()), pk.getProperty(1).getColumnName(), row.get(pk.getProperty(1).getColumnName()));
        } else {
            throw ApiException.new400BadRequest((String)"A dynamo delete must have a hash key and an optional sortKey and that is it: '{}'", (Object[])new Object[]{row});
        }
    }

    public void configDb() throws ApiException {
        for (String tableName : this.includeTables.keySet()) {
            List collectionNames = Utils.explode((String)",", (String[])new String[]{(String)this.includeTables.get(tableName)});
            for (String collectionName : collectionNames) {
                this.withCollection(this.buildCollection(tableName, collectionName));
            }
        }
    }

    protected Collection buildCollection(String tableName, String collectionName) {
        Projection projection;
        AmazonDynamoDB dynamoClient = this.getDynamoClient();
        Collection coll = new Collection(collectionName);
        coll.withTableName(tableName);
        DynamoDB dynamoDB = new DynamoDB(dynamoClient);
        Table dynamoTable = dynamoDB.getTable(tableName);
        TableDescription tableDescription = dynamoTable.describe();
        for (AttributeDefinition attr : tableDescription.getAttributeDefinitions()) {
            coll.withProperty(attr.getAttributeName(), attr.getAttributeType(), true);
        }
        List keySchema = tableDescription.getKeySchema();
        Index primaryIndex = this.addTableIndex(PRIMARY_INDEX_TYPE, PRIMARY_INDEX_NAME, keySchema, coll, true, null, null);
        if (tableDescription.getGlobalSecondaryIndexes() != null) {
            for (GlobalSecondaryIndexDescription indexDesc : tableDescription.getGlobalSecondaryIndexes()) {
                projection = indexDesc.getProjection();
                this.addTableIndex(GLOBAL_SECONDARY_INDEX_TYPE, indexDesc.getIndexName(), indexDesc.getKeySchema(), coll, false, projection, primaryIndex);
            }
        }
        if (tableDescription.getLocalSecondaryIndexes() != null) {
            for (GlobalSecondaryIndexDescription indexDesc : tableDescription.getLocalSecondaryIndexes()) {
                projection = indexDesc.getProjection();
                this.addTableIndex(LOCAL_SECONDARY_INDEX_TYPE, indexDesc.getIndexName(), indexDesc.getKeySchema(), coll, false, projection, primaryIndex);
            }
        }
        return coll;
    }

    protected Index addTableIndex(String type, String indexName, List<KeySchemaElement> keySchemaList, Collection collection, boolean unique, Projection projection, Index primaryIndex) {
        Index index = new Index(indexName, type, unique, new Property[0]);
        for (KeySchemaElement keySchemaElement : keySchemaList) {
            Property property = collection.getProperty(keySchemaElement.getAttributeName());
            index.withProperties(new Property[]{property});
            property.withColumnName(keySchemaElement.getAttributeName());
        }
        if (projection != null) {
            io.inversion.query.Projection invProj = new io.inversion.query.Projection();
            invProj.withType(projection.getProjectionType());
            for (Property prop : primaryIndex.getProperties()) {
                invProj.add(prop.getColumnName());
            }
            for (KeySchemaElement keyInfo : keySchemaList) {
                Property property = collection.getProperty(keyInfo.getAttributeName());
                invProj.add(property.getColumnName());
            }
            List list = projection.getNonKeyAttributes();
            if (list != null) {
                for (String name : list) {
                    Property property = collection.getProperty(name);
                    invProj.add(property.getColumnName());
                }
            }
            index.withProjection(invProj);
        }
        collection.withIndexes(new Index[]{index});
        return index;
    }

    public Table getDynamoTable(Collection table) {
        return this.getDynamoTable(table.getTableName());
    }

    public Table getDynamoTable(String tableName) {
        return new DynamoDB(this.getDynamoClient()).getTable(tableName);
    }

    public DynamoDb withAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
        return this;
    }

    public DynamoDb withAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
        return this;
    }

    public DynamoDb withAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
        return this;
    }

    public DynamoDb withAwsEndpoint(String awsEndpoint) {
        this.awsEndpoint = awsEndpoint;
        return this;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " - " + this.getName() + " - " + this.getCollections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonDynamoDB getDynamoClient() {
        if (this.dynamoClient == null) {
            DynamoDb dynamoDb = this;
            synchronized (dynamoDb) {
                if (this.dynamoClient == null) {
                    this.dynamoClient = DynamoDb.buildDynamoClient(this.awsRegion, this.awsAccessKey, this.awsSecretKey, this.awsEndpoint);
                }
            }
        }
        return this.dynamoClient;
    }
}

