/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import io.inversion.utils.JSNode;
import io.inversion.utils.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

public class EchoRequestStreamHandler
implements RequestStreamHandler {
    public void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
        JSNode responseBody = new JSNode();
        JSNode responseJson = new JSNode();
        responseJson.put("isBase64Encoded", (Object)false);
        responseJson.put("statusCode", (Object)"200");
        responseJson.put("headers", (Object)new JSNode(new Object[]{"Access-Control-Allow-Origin", "*"}));
        try {
            String input = Utils.read((InputStream)new BufferedInputStream(inputStream));
            context.getLogger().log(input);
            JSNode request = JSNode.parseJsonNode((String)input);
            responseBody.put("request", (Object)request);
        }
        catch (Exception ex) {
            responseBody.put("error", (Object)Utils.getShortCause((Throwable)ex));
        }
        responseJson.put("body", (Object)responseBody.toString());
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        writer.write(responseJson.toString());
        writer.close();
    }
}

