/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import io.inversion.Api;
import io.inversion.Engine;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.utils.JSNode;
import io.inversion.utils.Url;
import io.inversion.utils.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AwsApiGatewayLambdaRequestStreamHandler
implements RequestStreamHandler {
    protected Engine engine = null;
    protected Api api = null;
    boolean debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
        block14: {
            Exception ex;
            JSNode responseBody;
            String input;
            block15: {
                input = Utils.read((InputStream)new BufferedInputStream(inputStream));
                responseBody = new JSNode();
                JSNode config = null;
                ex = null;
                try {
                    JSNode jsonHeaders;
                    JSNode json = JSNode.parseJsonNode((String)input);
                    this.debug("Request Event");
                    this.debug(json.toString(false));
                    String method = json.getString("httpMethod");
                    String host = (String)json.find("headers.Host");
                    String path = (String)json.find("requestContext.path");
                    Url url = new Url("http://" + host + path);
                    String profile = path != null ? (String)Utils.explode((String)"/", (String[])new String[]{path}).get(0) : "";
                    String proxyPath = (String)json.find("pathParameters.proxy");
                    proxyPath = proxyPath != null ? proxyPath : "";
                    String pathStr = Utils.implode((String)"/", (Object[])new Object[]{path});
                    String proxyStr = Utils.implode((String)"/", (Object[])new Object[]{proxyPath});
                    String servletPath = "";
                    if (pathStr.length() > proxyStr.length()) {
                        servletPath = pathStr.substring(0, pathStr.length() - proxyStr.length());
                    }
                    config = new JSNode(new Object[]{"method", method, "host", host, "path", path, "url", url.toString(), "profile", profile, "proxyPath", proxyPath, "servletPath", servletPath});
                    if (this.engine == null) {
                        AwsApiGatewayLambdaRequestStreamHandler awsApiGatewayLambdaRequestStreamHandler = this;
                        synchronized (awsApiGatewayLambdaRequestStreamHandler) {
                            if (this.engine == null) {
                                this.engine = this.buildEngine(profile, servletPath);
                                this.engine.startup();
                            }
                        }
                    }
                    Map headers = (jsonHeaders = json.getNode("headers")) == null ? new HashMap() : jsonHeaders.asMap();
                    JSNode jsonParams = json.getNode("queryStringParameters");
                    Map params = jsonParams == null ? new HashMap() : jsonParams.asMap();
                    String body = json.getString("body");
                    if (method.equals("POST") && body != null) {
                        LinkedHashMap postParams = Utils.parseQueryString((String)body);
                        params.putAll(postParams);
                    }
                    Request req = new Request(method, url.toString(), headers, params, body);
                    Response res = new Response();
                    this.engine.service(req, res);
                    if (outputStream != null) {
                        this.writeResponse(res, outputStream);
                    }
                    if (ex == null) break block14;
                    if (config == null) break block15;
                }
                catch (Exception e1) {
                    block16: {
                        try {
                            ex = e1;
                            if (ex == null) break block14;
                            if (config == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (ex != null) {
                                if (config != null) {
                                    responseBody.put("config", config);
                                }
                                responseBody.put("error", (Object)Utils.getShortCause((Throwable)ex));
                                responseBody.put("request", (Object)JSNode.parseJsonNode((String)input));
                                JSNode responseJson = new JSNode();
                                responseJson.put("isBase64Encoded", (Object)false);
                                responseJson.put("statusCode", (Object)"500");
                                responseJson.put("headers", (Object)new JSNode(new Object[]{"Access-Control-Allow-Origin", "*"}));
                                responseJson.put("body", (Object)responseBody.toString());
                                OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
                                writer.write(responseJson.toString());
                                writer.close();
                            }
                            throw throwable;
                        }
                        responseBody.put("config", config);
                    }
                    responseBody.put("error", (Object)Utils.getShortCause((Throwable)ex));
                    responseBody.put("request", (Object)JSNode.parseJsonNode((String)input));
                    JSNode responseJson = new JSNode();
                    responseJson.put("isBase64Encoded", (Object)false);
                    responseJson.put("statusCode", (Object)"500");
                    responseJson.put("headers", (Object)new JSNode(new Object[]{"Access-Control-Allow-Origin", "*"}));
                    responseJson.put("body", (Object)responseBody.toString());
                    OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
                    writer.write(responseJson.toString());
                    writer.close();
                }
                responseBody.put("config", (Object)config);
            }
            responseBody.put("error", (Object)Utils.getShortCause((Throwable)ex));
            responseBody.put("request", (Object)JSNode.parseJsonNode((String)input));
            JSNode responseJson = new JSNode();
            responseJson.put("isBase64Encoded", (Object)false);
            responseJson.put("statusCode", (Object)"500");
            responseJson.put("headers", (Object)new JSNode(new Object[]{"Access-Control-Allow-Origin", "*"}));
            responseJson.put("body", (Object)responseBody.toString());
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
            writer.write(responseJson.toString());
            writer.close();
        }
    }

    protected Engine buildEngine(String configProfile, String servletPath) {
        System.out.println("TODO FIX ME: " + servletPath);
        System.out.println("TODO FIX ME: " + configProfile);
        Engine engine = new Engine();
        engine.withConfigProfile(configProfile);
        if (this.api == null) {
            this.api = this.buildApi(engine);
        }
        if (this.api != null) {
            engine.withApi(this.api);
        }
        return engine;
    }

    protected Api buildApi(Engine engine) {
        System.out.println("You can override buildApi(engine) to wire up your api in code: " + engine);
        return null;
    }

    protected void writeResponse(Response res, OutputStream outputStream) throws IOException {
        JSNode responseJson = new JSNode();
        responseJson.put("isBase64Encoded", (Object)false);
        responseJson.put("statusCode", (Object)res.getStatusCode());
        JSNode headers = new JSNode();
        responseJson.put("headers", (Object)headers);
        for (String key : res.getHeaders().keySet()) {
            List values = res.getHeaders().get((Object)key);
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < values.size(); ++i) {
                buff.append(values.get(i));
                if (i >= values.size() - 1) continue;
                buff.append(",");
            }
            headers.put(key, (Object)buff.toString());
        }
        String output = res.getOutput();
        responseJson.put("body", (Object)output);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        writer.write(responseJson.toString());
        writer.close();
    }

    public void debug(String msg) {
        if (this.isDebug()) {
            System.out.println(msg);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public Api getApi() {
        return this.api;
    }

    public void setApi(Api api) {
        this.api = api;
    }
}

