/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.jdbc;

import io.inversion.utils.Utils;
import java.util.HashSet;
import java.util.Set;

class SqlTokenizer {
    static final Set keywords = new HashSet(Utils.explode((String)",", (String[])new String[]{"insert,into,update,delete,select,from,where,group,order,limit"}));
    final char[] chars;
    int head = 0;
    StringBuilder clause = new StringBuilder();
    StringBuilder token = new StringBuilder();
    boolean escape = false;
    boolean doubleQuote = false;
    boolean singleQuote = false;
    boolean backQuote = false;

    public SqlTokenizer(String chars) {
        this.chars = chars.toCharArray();
    }

    boolean quoted() {
        return this.doubleQuote || this.singleQuote || this.backQuote;
    }

    boolean escaped() {
        return this.escape;
    }

    boolean isAlphaNum(char c) {
        return Character.isAlphabetic(c) || Character.isDigit(c);
    }

    public String nextClause() {
        String nextToken;
        String toReturn = null;
        while ((nextToken = this.next()) != null) {
            if (keywords.contains(nextToken.toLowerCase()) && this.clause.length() > 0) {
                toReturn = this.clause.toString();
                this.clause = new StringBuilder(nextToken);
                return toReturn;
            }
            this.clause.append(nextToken);
        }
        if (this.clause.length() > 0) {
            toReturn = this.clause.toString();
            this.clause = new StringBuilder();
        }
        return toReturn;
    }

    public String next() {
        if (this.head >= this.chars.length) {
            return null;
        }
        this.doubleQuote = false;
        this.singleQuote = false;
        this.backQuote = false;
        this.escape = false;
        boolean done = false;
        int parens = 0;
        while (this.head < this.chars.length && !done) {
            char c = this.chars[this.head];
            switch (c) {
                case '\\': {
                    this.token.append(c);
                    this.escape = !this.escape;
                    break;
                }
                case '(': {
                    if (!this.escaped() && !this.quoted()) {
                        if (parens == 0 && this.token.length() > 0) {
                            --this.head;
                            done = true;
                            break;
                        }
                        ++parens;
                    }
                    this.token.append(c);
                    break;
                }
                case ')': {
                    if (!this.escaped() && !this.quoted() && --parens == 0) {
                        this.token.append(c);
                        done = true;
                        break;
                    }
                    this.token.append(c);
                    break;
                }
                case '\"': {
                    if (!(this.escape || this.singleQuote || this.backQuote || parens > 0)) {
                        if (!this.doubleQuote && this.token.length() > 0) {
                            --this.head;
                            done = true;
                            break;
                        }
                        boolean bl = this.doubleQuote = !this.doubleQuote;
                        if (!this.doubleQuote) {
                            this.token.append(c);
                            done = true;
                            break;
                        }
                    }
                    this.token.append(c);
                    break;
                }
                case '\'': {
                    if (!(this.escape || this.doubleQuote || this.backQuote || parens > 0)) {
                        if (!this.singleQuote && this.token.length() > 0) {
                            --this.head;
                            done = true;
                            break;
                        }
                        boolean bl = this.singleQuote = !this.singleQuote;
                        if (!this.singleQuote) {
                            this.token.append(c);
                            done = true;
                            break;
                        }
                    }
                    this.token.append(c);
                    break;
                }
                case '`': {
                    if (!(this.escape || this.doubleQuote || this.singleQuote || parens > 0)) {
                        if (!this.backQuote && this.token.length() > 0) {
                            --this.head;
                            done = true;
                            break;
                        }
                        boolean bl = this.backQuote = !this.backQuote;
                        if (!this.backQuote) {
                            this.token.append(c);
                            done = true;
                            break;
                        }
                    }
                    this.token.append(c);
                    break;
                }
                default: {
                    this.escape = false;
                    if (this.quoted() || parens > 0) {
                        this.token.append(c);
                        break;
                    }
                    if (this.token.length() > 0) {
                        char previousC = this.token.charAt(this.token.length() - 1);
                        if (!this.isAlphaNum(previousC)) {
                            --this.head;
                            done = true;
                            break;
                        }
                        if (this.isAlphaNum(previousC) && !this.isAlphaNum(c)) {
                            --this.head;
                            done = true;
                            break;
                        }
                    }
                    this.token.append(c);
                }
            }
            ++this.head;
        }
        String str = this.token.toString();
        this.token = new StringBuilder();
        return str;
    }
}

