/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.jdbc;

import io.inversion.ApiException;
import io.inversion.utils.Rows;
import io.inversion.utils.Utils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;

public class JdbcUtils {
    static final String[] ILLEGALS_REGX = new String[]{"insert", "update", "delete", "drop", "truncate", "exec"};
    static final Pattern[] ILLEGALS = new Pattern[ILLEGALS_REGX.length];
    static final List<SqlListener> listeners = new ArrayList<SqlListener>();

    public static String getDbType(Connection conn) {
        String connstr = conn.toString().toLowerCase();
        if (connstr.contains("mysql")) {
            return "mysql";
        }
        if (connstr.contains("postgres")) {
            return "postgres";
        }
        if (connstr.contains("h2")) {
            return "h2";
        }
        if (connstr.contains("sqlserver")) {
            return "sqlserver";
        }
        if (connstr.contains("clientconnectionid")) {
            return "sqlserver";
        }
        return "unknown";
    }

    public static char colQuote(Connection conn) {
        String connstr = conn.toString().toLowerCase();
        if (connstr.contains("mysql")) {
            return '`';
        }
        return '\"';
    }

    public static String quoteCol(Connection conn, Object str) {
        char c = JdbcUtils.colQuote(conn);
        return c + str.toString() + c;
    }

    public static void addSqlListener(SqlListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void removeSqlListener(SqlListener listener) {
        listeners.remove(listener);
    }

    public static void notifyBefore(String method, String sql, Object args) {
        for (SqlListener listener : listeners) {
            listener.beforeStmt(method, sql, args);
        }
    }

    public static void notifyError(String method, String sql, Object args, Exception ex) {
        for (SqlListener listener : listeners) {
            listener.onError(method, sql, args, ex);
        }
    }

    public static void notifyAfter(String method, String sql, Object args, Exception ex, Object result) {
        for (SqlListener listener : listeners) {
            listener.afterStmt(method, sql, args, ex, result);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object execute(Connection conn, String sql, Object ... vals) throws SQLException {
        block19: {
            if (vals != null && vals.length == 1 && vals[0] instanceof Collection) {
                vals = ((Collection)vals[0]).toArray();
            }
            JdbcUtils.notifyBefore("execute", sql, vals);
            ex = null;
            stmt = null;
            rs = null;
            rtval = null;
            if (JdbcUtils.isSelect(sql)) {
                if (vals != null && vals.length > 0) {
                    stmt = conn.prepareStatement(sql, 1);
                    for (i = 0; i < vals.length; ++i) {
                        ((PreparedStatement)stmt).setObject(i + 1, vals[i]);
                    }
                    rs = ((PreparedStatement)stmt).executeQuery();
                } else {
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(sql);
                }
                if (!rs.next()) break block19;
                i = rtval = rs.getObject(1);
            }
            ** GOTO lbl-1000
            {
                block20: {
                    catch (Exception e) {
                        try {
                            JdbcUtils.notifyError("execute", sql, vals, e);
                            ex = new SQLException(e.getMessage() + " SQL=" + sql, Utils.getCause((Throwable)e));
                            throw ex;
                        }
                        catch (Throwable var8_15) {
                            JdbcUtils.close(new Object[]{rs, stmt});
                            JdbcUtils.notifyAfter("execute", sql, vals, ex, rtval);
                            throw var8_15;
                        }
                    }
                    JdbcUtils.close(new Object[]{rs, stmt});
                    JdbcUtils.notifyAfter("execute", sql, vals, ex, rtval);
                    return i;
lbl-1000:
                    // 1 sources

                    {
                        if (vals != null && vals.length > 0) {
                            stmt = conn.prepareStatement(sql, 1);
                            for (i = 0; i < vals.length; ++i) {
                                ((PreparedStatement)stmt).setObject(i + 1, vals[i]);
                            }
                            ((PreparedStatement)stmt).execute();
                        } else {
                            stmt = conn.createStatement();
                            stmt.execute(sql, 1);
                        }
                        if (!JdbcUtils.isInsert(sql)) break block20;
                        try {
                            rs = stmt.getGeneratedKeys();
                            if (!rs.next()) break block19;
                            i = rtval = rs.getObject(1);
                        }
                        catch (SQLFeatureNotSupportedException e) {
                            JdbcUtils.notifyError("execute", sql, vals, e);
                            break block19;
                        }
                    }
                    JdbcUtils.close(new Object[]{rs, stmt});
                    JdbcUtils.notifyAfter("execute", sql, vals, ex, rtval);
                    return i;
                }
                if (!JdbcUtils.isUpdate(sql)) break block19;
                try {
                    e = rtval = Integer.valueOf(stmt.getUpdateCount());
                }
                catch (SQLFeatureNotSupportedException e) {}
                JdbcUtils.close(new Object[]{rs, stmt});
                JdbcUtils.notifyAfter("execute", sql, vals, ex, rtval);
                return e;
                {
                    JdbcUtils.notifyError("execute", sql, vals, e);
                }
            }
        }
        JdbcUtils.close(new Object[]{rs, stmt});
        JdbcUtils.notifyAfter("execute", sql, vals, ex, rtval);
        return null;
    }

    public static boolean isSelect(String sql) {
        return sql != null && sql.toLowerCase().trim().startsWith("select ");
    }

    public static Rows selectRows(Connection conn, String sql, Object ... vals) throws SQLException {
        Rows rows;
        ResultSet rs;
        Statement stmt;
        Exception ex;
        block19: {
            if (vals != null && vals.length == 1 && vals[0] instanceof List) {
                vals = ((List)vals[0]).toArray();
            }
            JdbcUtils.notifyBefore("selectRows", sql, vals);
            ex = null;
            stmt = null;
            rs = null;
            rows = null;
            try {
                int i;
                if (vals != null && vals.length > 0) {
                    stmt = conn.prepareStatement(sql);
                    for (int i2 = 0; i2 < vals.length; ++i2) {
                        Object o = vals[i2];
                        ((PreparedStatement)stmt).setObject(i2 + 1, o);
                    }
                    rs = ((PreparedStatement)stmt).executeQuery();
                } else {
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(sql);
                }
                rows = new Rows();
                if (sql.toLowerCase().trim().startsWith("set ")) break block19;
                ResultSetMetaData rsmd = rs.getMetaData();
                int cols = rsmd.getColumnCount();
                for (i = 1; i <= cols; ++i) {
                    rows.addKey(rsmd.getColumnLabel(i));
                }
                while (rs.next()) {
                    rows.addRow();
                    for (i = 0; i < cols; ++i) {
                        Object o = null;
                        try {
                            o = rs.getObject(i + 1);
                            if (o instanceof Clob) {
                                int numCharsRead;
                                Reader reader = ((Clob)o).getCharacterStream();
                                char[] arr = new char[8192];
                                StringBuilder buffer = new StringBuilder();
                                while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
                                    buffer.append(arr, 0, numCharsRead);
                                }
                                reader.close();
                                o = buffer.toString();
                            } else if (o != null && o.getClass().isArray() && Array.getLength(o) == 0) {
                                o = null;
                            }
                        }
                        catch (Exception e) {
                            if (ex != null) {
                                ex = e;
                            }
                            e.printStackTrace();
                            JdbcUtils.notifyError("selectRows", sql, vals, e);
                        }
                        rows.put(o);
                    }
                }
            }
            catch (Exception e) {
                try {
                    if (ex == null) {
                        ex = e;
                    }
                    JdbcUtils.notifyError("selectRows", sql, vals, e);
                    ex = new SQLException(e.getMessage() + " SQL=" + sql + " ERROR=" + e.getMessage(), Utils.getCause((Throwable)e));
                    throw (SQLException)ex;
                }
                catch (Throwable throwable) {
                    JdbcUtils.close(stmt, rs);
                    JdbcUtils.notifyAfter("selectRows", sql, vals, ex, rows);
                    throw throwable;
                }
            }
        }
        JdbcUtils.close(stmt, rs);
        JdbcUtils.notifyAfter("selectRows", sql, vals, ex, rows);
        return rows;
    }

    public static Rows.Row selectRow(Connection conn, String sql, Object ... vals) throws SQLException {
        Rows rows = JdbcUtils.selectRows(conn, sql, vals);
        if (rows.size() > 0) {
            return (Rows.Row)rows.get(0);
        }
        return null;
    }

    public static int selectInt(Connection conn, String sql, Object ... vals) throws SQLException {
        Object val = JdbcUtils.selectValue(conn, sql, vals);
        if (val == null) {
            return -1;
        }
        return Integer.parseInt(val + "");
    }

    public static Object selectValue(Connection conn, String sql, Object ... vals) throws SQLException {
        Rows.Row row = JdbcUtils.selectRow(conn, sql, vals);
        if (row != null) {
            return row.get((String)row.keySet().iterator().next());
        }
        return null;
    }

    public static boolean isInsert(String sql) {
        String lc = sql.toLowerCase().trim();
        return lc.startsWith("insert ") || lc.startsWith("merge ");
    }

    public static String buildInsertSQL(Connection conn, String tableName, Object[] columnNameArray) {
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        sql.append(JdbcUtils.quoteCol(conn, tableName)).append(" (");
        sql.append(JdbcUtils.getColumnStr(conn, columnNameArray)).append(") VALUES (");
        sql.append(JdbcUtils.getQuestionMarkStr(columnNameArray)).append(")");
        return sql.toString();
    }

    public static Object insertMap(Connection conn, String tableName, Map row) throws SQLException {
        ArrayList keys = new ArrayList();
        ArrayList values = new ArrayList();
        for (Object key : row.keySet()) {
            keys.add(key);
            values.add(row.get(key));
        }
        String sql = JdbcUtils.buildInsertSQL(conn, tableName, keys.toArray());
        return JdbcUtils.execute(conn, sql, values.toArray());
    }

    public static List insertMaps(Connection conn, String tableName, List maps) throws SQLException {
        if ("sqlserver".equalsIgnoreCase(JdbcUtils.getDbType(conn)) && maps.size() > 0) {
            ArrayList returnKeys = new ArrayList();
            for (Object map : maps) {
                returnKeys.addAll(JdbcUtils.insertMaps0(conn, tableName, Collections.singletonList(map)));
            }
            return returnKeys;
        }
        return JdbcUtils.insertMaps0(conn, tableName, maps);
    }

    static List insertMaps0(Connection conn, String tableName, List maps) throws SQLException {
        List rows = maps;
        ArrayList<Object> returnKeys = new ArrayList<Object>();
        LinkedHashSet keys = new LinkedHashSet();
        for (Map row : rows) {
            keys.addAll(row.keySet());
        }
        StringBuilder buff = new StringBuilder("INSERT INTO ");
        buff.append(JdbcUtils.quoteCol(conn, tableName)).append(" (");
        buff.append(JdbcUtils.getColumnStr(conn, keys.toArray())).append(") VALUES \r\n");
        for (int i = 0; i < maps.size(); ++i) {
            buff.append("(").append(JdbcUtils.getQuestionMarkStr(keys.size())).append(")");
            if (i >= maps.size() - 1) continue;
            buff.append(",\r\n");
        }
        String sql = buff.toString();
        Exception ex = null;
        PreparedStatement stmt = conn.prepareStatement(sql, 1);
        try {
            JdbcUtils.notifyBefore("insertMaps", sql, rows);
            int idx = 1;
            for (Map row : rows) {
                for (String col : keys) {
                    Object value = row.get(col);
                    stmt.setObject(idx++, value);
                }
            }
            stmt.executeUpdate();
            ResultSet rs = stmt.getGeneratedKeys();
            while (rs.next()) {
                Object key = rs.getObject(1);
                returnKeys.add(key);
            }
        }
        catch (Exception e) {
            ex = e;
            JdbcUtils.notifyError("insertMaps", sql, rows, ex);
            throw e;
        }
        finally {
            JdbcUtils.notifyAfter("insertMap", sql, rows, ex, null);
        }
        if (returnKeys.size() == 0) {
            for (int i = 0; i < maps.size(); ++i) {
                returnKeys.add(null);
            }
        }
        if (returnKeys.size() != rows.size()) {
            throw new RuntimeException("insertMaps() did not return generatedKeys for all rows");
        }
        return returnKeys;
    }

    public static boolean isUpdate(String sql) {
        return sql.toLowerCase().trim().startsWith("update ");
    }

    public static List<Integer> update(Connection conn, String tableName, List<String> primaryKeyCols, List<Map<String, Object>> rows) throws Exception {
        ArrayList<Integer> updatedCounts = new ArrayList<Integer>();
        Set<String> cols = null;
        ArrayList<Map<String, Object>> batch = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : rows) {
            if (cols == null) {
                cols = row.keySet();
            }
            if (batch.size() > 0 && CollectionUtils.disjunction(cols, row.keySet()).size() > 0) {
                updatedCounts.addAll(JdbcUtils.updateBatch(conn, tableName, primaryKeyCols, batch));
                batch.clear();
            }
            cols = row.keySet();
            batch.add(row);
        }
        if (batch.size() > 0) {
            updatedCounts.addAll(JdbcUtils.updateBatch(conn, tableName, primaryKeyCols, batch));
        }
        return updatedCounts;
    }

    public static List<Integer> updateBatch(Connection conn, String tableName, List<String> keyCols, List<Map<String, Object>> rows) throws SQLException {
        if (rows.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> returnCounts = new ArrayList<Integer>();
        ArrayList<String> valCols = new ArrayList<String>(rows.get(0).keySet());
        valCols.removeAll(keyCols);
        String sql = JdbcUtils.buildUpdateSQL(conn, tableName, valCols.toArray(), keyCols.toArray());
        Exception ex = null;
        PreparedStatement stmt = conn.prepareStatement(sql);
        try {
            int[] updatedCounts;
            JdbcUtils.notifyBefore("update", sql, rows);
            for (Map<String, Object> row : rows) {
                Object value;
                int i;
                for (i = 0; i < valCols.size(); ++i) {
                    value = row.get(valCols.get(i));
                    stmt.setObject(i + 1, value);
                }
                for (i = 0; i < keyCols.size(); ++i) {
                    value = row.get(keyCols.get(i));
                    stmt.setObject(i + 1 + valCols.size(), value);
                }
                stmt.addBatch();
            }
            for (int updatedCount : updatedCounts = stmt.executeBatch()) {
                returnCounts.add(updatedCount);
            }
        }
        catch (Exception e) {
            try {
                ex = e;
                JdbcUtils.notifyError("update", sql, rows, ex);
                throw e;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(stmt);
                JdbcUtils.notifyAfter("update", sql, rows, ex, returnCounts);
                throw throwable;
            }
        }
        JdbcUtils.close(stmt);
        JdbcUtils.notifyAfter("update", sql, rows, ex, returnCounts);
        return returnCounts;
    }

    public static String buildUpdateSQL(Connection conn, String tableName, Object[] setColumnNameArray, Object[] whereColumnNames) {
        StringBuilder sql = new StringBuilder("UPDATE ");
        sql.append(JdbcUtils.quoteCol(conn, tableName)).append(" SET ");
        sql.append(JdbcUtils.getWhereColumnStr(conn, setColumnNameArray, ","));
        if (whereColumnNames != null && whereColumnNames.length > 0) {
            sql.append(" WHERE ").append(JdbcUtils.getWhereColumnStr(conn, whereColumnNames, " AND "));
        }
        return sql.toString();
    }

    public static List<Rows.Row> upsert(Connection conn, String tableName, List<String> primaryKeyCols, List<Map<String, Object>> rows) throws SQLException {
        ArrayList<Rows.Row> generatedKeys = new ArrayList<Rows.Row>();
        if (rows.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Set<String> cols = null;
        int hadKey = -1;
        ArrayList<Map<String, Object>> batch = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : rows) {
            int hasKey = 1;
            for (String indexCol : primaryKeyCols) {
                if (!Utils.empty((Object[])new Object[]{map.get(indexCol)})) continue;
                hasKey = 0;
                break;
            }
            if (hadKey == -1) {
                hadKey = hasKey;
            }
            if (cols == null) {
                cols = map.keySet();
            }
            if (batch.size() > 0 && hadKey != hasKey || CollectionUtils.disjunction(cols, map.keySet()).size() > 0) {
                if (hadKey == 0) {
                    generatedKeys.addAll(JdbcUtils.insertBatch(conn, tableName, primaryKeyCols, batch));
                } else {
                    generatedKeys.addAll(JdbcUtils.upsertBatch(conn, tableName, primaryKeyCols, batch));
                }
                batch.clear();
            }
            hadKey = hasKey;
            cols = map.keySet();
            batch.add(map);
        }
        if (batch.size() > 0) {
            if (hadKey == 0) {
                generatedKeys.addAll(JdbcUtils.insertBatch(conn, tableName, primaryKeyCols, batch));
            } else {
                generatedKeys.addAll(JdbcUtils.upsertBatch(conn, tableName, primaryKeyCols, batch));
            }
        }
        for (int i = 0; i < generatedKeys.size(); ++i) {
            Rows.Row row = new Rows.Row();
            for (String col : primaryKeyCols) {
                Object val = rows.get(i).get(col);
                if (val == null) {
                    val = generatedKeys.get(i);
                    generatedKeys.set(i, null);
                }
                if (val == null) {
                    throw ApiException.new500InternalServerError((String)"Unable to determine upsert key or column '{}'", (Object[])new Object[]{col});
                }
                row.put(col, val);
            }
            generatedKeys.set(i, row);
        }
        return generatedKeys;
    }

    static List insertBatch(Connection conn, String tableName, List<String> indexCols, List<Map<String, Object>> rows) throws SQLException {
        List returnKeys = JdbcUtils.insertMaps(conn, tableName, rows);
        for (int i = 0; i < returnKeys.size(); ++i) {
            Object key = returnKeys.get(i);
            if (key != null) continue;
            key = rows.get(i).get(indexCols.get(0));
            if (key == null) {
                throw ApiException.new500InternalServerError((String)("Unable to determine key for row: " + rows.get(i)), (Object[])new Object[0]);
            }
            returnKeys.set(i, key);
        }
        return returnKeys;
    }

    /*
     * WARNING - void declaration
     */
    static List upsertBatch(Connection conn, String tableName, List<String> idxCols, List<Map<String, Object>> rows) throws SQLException {
        void var7_11;
        ArrayList returnKeys = new ArrayList();
        String type = JdbcUtils.getDbType(conn);
        String string = type;
        int n = -1;
        switch (string.hashCode()) {
            case 104382626: {
                if (!string.equals("mysql")) break;
                boolean bl = false;
                break;
            }
            case 757584761: {
                if (!string.equals("postgres")) break;
                boolean bl = true;
                break;
            }
            case -1874470255: {
                if (!string.equals("sqlserver")) break;
                int n2 = 2;
            }
        }
        switch (var7_11) {
            case 0: {
                JdbcUtils.mysqlUpsertBatch(conn, tableName, idxCols, rows);
                break;
            }
            case 1: {
                JdbcUtils.postgresUpsertBatch(conn, tableName, idxCols, rows);
                break;
            }
            case 2: {
                JdbcUtils.sqlserverUpsertBatch(conn, tableName, idxCols, rows);
                break;
            }
            default: {
                JdbcUtils.h2UpsertBatch(conn, tableName, idxCols, rows);
            }
        }
        for (Map map : rows) {
            Object key = map.get(idxCols.get(0));
            if (key == null) {
                System.out.println("Unable to determine key for row: " + map);
            }
            returnKeys.add(key);
        }
        return returnKeys;
    }

    static List h2UpsertBatch(Connection conn, String tableName, List<String> idxCols, List<Map<String, Object>> rows) throws SQLException {
        ArrayList<Object> returnKeys = new ArrayList<Object>();
        for (Map<String, Object> row : rows) {
            returnKeys.add(JdbcUtils.h2UpsertBatch(conn, tableName, idxCols, row));
        }
        return returnKeys;
    }

    static Object h2UpsertBatch(Connection conn, String tableName, List<String> idxCols, Map<String, Object> row) throws SQLException {
        String sql = "";
        ArrayList<String> cols = new ArrayList<String>();
        ArrayList<Object> vals = new ArrayList<Object>();
        for (String col : row.keySet()) {
            cols.add(col);
            vals.add(row.get(col));
        }
        StringBuilder keyCols = new StringBuilder();
        for (int i = 0; i < idxCols.size(); ++i) {
            keyCols.append(JdbcUtils.quoteCol(conn, idxCols.get(i)));
            if (i >= idxCols.size() - 1) continue;
            keyCols.append(", ");
        }
        sql = sql + " MERGE INTO " + JdbcUtils.quoteCol(conn, tableName) + " (" + JdbcUtils.getColumnStr(conn, cols) + ")  KEY(" + keyCols + ") VALUES (" + JdbcUtils.getQuestionMarkStr(vals.size()) + ")";
        Exception ex = null;
        try {
            JdbcUtils.notifyBefore("upsert", sql, row);
            Object object = JdbcUtils.execute(conn, sql, vals);
            return object;
        }
        catch (Exception e) {
            ex = e;
            JdbcUtils.notifyError("upsert", sql, row, ex);
            throw e;
        }
        finally {
            JdbcUtils.notifyAfter("upsert", sql, row, ex, null);
        }
    }

    static void mysqlUpsertBatch(Connection conn, String tableName, List<String> idxCols, List<Map<String, Object>> rows) throws SQLException {
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        for (Map<String, Object> row : rows) {
            keySet.addAll(row.keySet());
        }
        ArrayList keys = new ArrayList(keySet);
        String sql = JdbcUtils.mysqlBuildInsertOnDuplicateKeySQL(conn, tableName, keys.toArray());
        Exception ex = null;
        PreparedStatement stmt = conn.prepareStatement(sql, 1);
        try {
            JdbcUtils.notifyBefore("upsert", sql, rows);
            for (Map<String, Object> row : rows) {
                for (int i = 0; i < keys.size(); ++i) {
                    Object value = row.get(keys.get(i));
                    stmt.setObject(i + 1, value);
                }
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                ex = e;
                JdbcUtils.notifyError("upsert", sql, rows, ex);
                throw e;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(stmt);
                JdbcUtils.notifyAfter("upsert", sql, rows, ex, null);
                throw throwable;
            }
        }
        JdbcUtils.close(stmt);
        JdbcUtils.notifyAfter("upsert", sql, rows, ex, null);
    }

    static String mysqlBuildInsertOnDuplicateKeySQL(Connection conn, String tableName, Object[] columnNameArray) {
        StringBuilder sql = new StringBuilder(JdbcUtils.buildInsertSQL(conn, tableName, columnNameArray));
        sql.append(" ON DUPLICATE KEY UPDATE ");
        for (int i = 0; i < columnNameArray.length; ++i) {
            Object col = columnNameArray[i];
            sql.append("\r\n`").append(col).append("`= values(`").append(col).append("`)");
            if (i >= columnNameArray.length - 1) continue;
            sql.append(", ");
        }
        return sql.toString();
    }

    static List postgresUpsertBatch(Connection conn, String tableName, List<String> idxCols, List<Map<String, Object>> rows) throws SQLException {
        int i;
        ArrayList<String> returnKeys = new ArrayList<String>();
        ArrayList<String> cols = new ArrayList<String>(rows.get(0).keySet());
        StringBuilder buff = new StringBuilder(JdbcUtils.buildInsertSQL(conn, tableName, cols.toArray()));
        buff.append("\r\n ON CONFLICT (");
        for (i = 0; i < idxCols.size(); ++i) {
            buff.append(JdbcUtils.quoteCol(conn, idxCols.get(i)));
            if (i >= idxCols.size() - 1) continue;
            buff.append(", ");
        }
        buff.append(") DO UPDATE SET ");
        for (i = 0; i < cols.size(); ++i) {
            buff.append("\r\n ").append(JdbcUtils.quoteCol(conn, cols.get(i))).append(" = EXCLUDED.").append(JdbcUtils.quoteCol(conn, cols.get(i)));
            if (i >= cols.size() - 1) continue;
            buff.append(", ");
        }
        Exception ex = null;
        String sql = buff.toString();
        PreparedStatement stmt = conn.prepareStatement(sql, 1);
        try {
            JdbcUtils.notifyBefore("upsert", sql, rows);
            for (Map<String, Object> row : rows) {
                for (int i2 = 0; i2 < cols.size(); ++i2) {
                    Object value = row.get(cols.get(i2));
                    stmt.setObject(i2 + 1, value);
                }
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                ex = e;
                JdbcUtils.notifyError("upsert", sql, rows, ex);
                throw e;
            }
            catch (Throwable throwable) {
                ResultSet rs = stmt.getGeneratedKeys();
                while (rs.next()) {
                    String key = rs.getString(1);
                    returnKeys.add(key);
                }
                JdbcUtils.close(stmt);
                JdbcUtils.notifyAfter("upsert", sql, rows, ex, null);
                throw throwable;
            }
        }
        ResultSet rs = stmt.getGeneratedKeys();
        while (rs.next()) {
            String key = rs.getString(1);
            returnKeys.add(key);
        }
        JdbcUtils.close(stmt);
        JdbcUtils.notifyAfter("upsert", sql, rows, ex, null);
        return returnKeys;
    }

    static List sqlserverUpsertBatch(Connection conn, String tableName, List<String> idxCols, List<Map<String, Object>> rows) throws SQLException {
        ArrayList<Object> returnKeys = new ArrayList<Object>();
        for (Map<String, Object> row : rows) {
            JdbcUtils.sqlserverUpsertBatch(conn, tableName, idxCols, row);
            returnKeys.add(row.get(idxCols.get(0)));
        }
        return returnKeys;
    }

    static void sqlserverUpsertBatch(Connection conn, String tableName, List<String> indexCols, Map<String, Object> row) throws SQLException {
        ArrayList<String> updateCols = new ArrayList<String>(row.keySet());
        ArrayList<String> insertCols = new ArrayList<String>(row.keySet());
        if (indexCols.size() < updateCols.size()) {
            updateCols.removeAll(indexCols);
        }
        String sql = JdbcUtils.buildUpdateSQL(conn, tableName, updateCols.toArray(), indexCols.toArray());
        sql = sql + "\r\n IF @@ROWCOUNT = 0 ";
        sql = sql + "\r\n " + JdbcUtils.buildInsertSQL(conn, tableName, insertCols.toArray());
        Exception ex = null;
        PreparedStatement stmt = conn.prepareStatement(sql);
        try {
            Object value;
            JdbcUtils.notifyBefore("upsert", sql, row);
            int colNum = 1;
            for (String col : updateCols) {
                value = row.get(col);
                stmt.setObject(colNum++, value);
            }
            for (String key : indexCols) {
                value = row.get(key);
                stmt.setObject(colNum++, value);
            }
            for (String col : insertCols) {
                value = row.get(col);
                stmt.setObject(colNum++, value);
            }
            stmt.execute();
        }
        catch (Exception e) {
            try {
                ex = e;
                JdbcUtils.notifyError("upsert", sql, row, ex);
                throw e;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(stmt);
                JdbcUtils.notifyAfter("upsert", sql, row, ex, null);
                throw throwable;
            }
        }
        JdbcUtils.close(stmt);
        JdbcUtils.notifyAfter("upsert", sql, row, ex, null);
    }

    public static void runSql(Connection conn, String sqlString) throws SQLException {
        JdbcUtils.runSql(conn, JdbcUtils.readSql(sqlString));
    }

    public static void runSql(Connection conn, InputStream ddlStream) throws SQLException {
        List<String> script = JdbcUtils.readSql(ddlStream);
        JdbcUtils.runSql(conn, script.toArray(new String[0]));
    }

    public static List<String> readSql(String string) throws SQLException {
        return JdbcUtils.readSql(new ByteArrayInputStream(string.getBytes()));
    }

    public static List<String> readSql(InputStream ddlStream) throws SQLException {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(ddlStream));
            StringBuilder curLine = new StringBuilder();
            ArrayList<String> ddlList = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("--") || line.startsWith("#")) continue;
                curLine.append("\r\n").append(line);
                if (!line.trim().endsWith(";")) continue;
                ddlList.add(curLine.toString().trim());
                curLine = new StringBuilder();
            }
            if (!Utils.empty((Object[])new Object[]{curLine.toString().trim()})) {
                ddlList.add(curLine.toString().trim());
            }
            return ddlList;
        }
        catch (IOException io) {
            throw new SQLException("Error reading input stream. " + io.getMessage());
        }
    }

    public static void runSql(Connection con, List<String> sql) throws SQLException {
        JdbcUtils.runSql(con, sql.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runSql(Connection con, String[] sql) throws SQLException {
        if (sql != null && sql.length > 0) {
            boolean oldAutoCommit = con.getAutoCommit();
            con.setAutoCommit(false);
            try {
                try (Statement stmt = con.createStatement();){
                    for (String s : sql) {
                        try {
                            stmt.execute(s);
                        }
                        catch (SQLException ex) {
                            System.err.println("Error trying to run sql statement: \r\n" + s + "\r\n\r\n");
                            ex.printStackTrace();
                            throw ex;
                        }
                    }
                }
                con.commit();
            }
            finally {
                con.setAutoCommit(oldAutoCommit);
            }
        }
    }

    public static String getWhereColumnStr(Connection conn, Object[] columnNameArray, String sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columnNameArray.length; ++i) {
            sb.append(JdbcUtils.quoteCol(conn, columnNameArray[i]));
            sb.append(" = ? ");
            if (i >= columnNameArray.length - 1) continue;
            sb.append(sep).append(" ");
        }
        return sb.toString();
    }

    public static String getColumnStr(Connection conn, Object[] columnNameArray) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columnNameArray.length; ++i) {
            sb.append(JdbcUtils.quoteCol(conn, columnNameArray[i]));
            if (i >= columnNameArray.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String getColumnStr(Connection conn, List columnNameArray) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columnNameArray.size(); ++i) {
            sb.append(JdbcUtils.quoteCol(conn, columnNameArray.get(i)));
            if (i >= columnNameArray.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String getQuestionMarkStr(Object[] columnNameArray) {
        return JdbcUtils.getQuestionMarkStr(columnNameArray.length);
    }

    public static String getQuestionMarkStr(int numQMarks) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numQMarks; ++i) {
            sb.append("?");
            if (i >= numQMarks - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String check(Object sql) {
        if (sql == null) {
            return null;
        }
        String str = sql.toString();
        for (int i = 0; i < ILLEGALS.length; ++i) {
            Matcher m = ILLEGALS[i].matcher(str);
            if (!m.find()) continue;
            throw new RuntimeException("Sql injection attack blocker on keyword \"" + ILLEGALS_REGX[i].trim() + "\".  You have modifying sql in a select statement: " + str);
        }
        return str;
    }

    public static void close(Object ... toClose) {
        for (Object o : toClose) {
            try {
                if (o instanceof Connection) {
                    ((Connection)o).close();
                    continue;
                }
                if (o instanceof Statement) {
                    ((Statement)o).close();
                    continue;
                }
                if (!(o instanceof ResultSet)) continue;
                ((ResultSet)o).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        for (int i = 0; i < ILLEGALS_REGX.length; ++i) {
            JdbcUtils.ILLEGALS[i] = Pattern.compile("\\W*" + ILLEGALS_REGX[i] + "\\W+", 34);
        }
    }

    public static interface SqlListener {
        public void onError(String var1, String var2, Object var3, Exception var4);

        public void beforeStmt(String var1, String var2, Object var3);

        public void afterStmt(String var1, String var2, Object var3, Exception var4, Object var5);
    }
}

