/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.jdbc;

import io.inversion.ApiException;
import io.inversion.User;
import io.inversion.action.security.AuthAction;
import io.inversion.jdbc.JdbcDb;
import io.inversion.jdbc.JdbcUtils;
import io.inversion.utils.Config;
import io.inversion.utils.Rows;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class JdbcDbUserDao
extends AuthAction.JwtUserDao {
    protected String name = null;
    protected JdbcDb db = null;
    protected String salt = null;

    public JdbcDbUserDao() {
    }

    public JdbcDbUserDao(JdbcDb db) {
        this.withDb(db);
    }

    public static String strongHash(Object salt, String password) throws ApiException {
        try {
            int iterationNb = 1000;
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            digest.reset();
            digest.update(salt.toString().getBytes());
            byte[] input = digest.digest(password.getBytes(StandardCharsets.UTF_8));
            for (int i = 0; i < iterationNb; ++i) {
                digest.reset();
                input = digest.digest(input);
            }
            return Base64.encodeBase64String((byte[])input).trim();
        }
        catch (Exception ex) {
            throw new ApiException((Throwable)ex);
        }
    }

    public static String weakHash(String password) {
        try {
            byte[] byteArr = password.getBytes();
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(byteArr);
            byte[] bytes = digest.digest();
            return new HexBinaryAdapter().marshal(bytes);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean checkPassword(String actual, String supplied) {
        String salt = this.getSalt();
        if (salt == null) {
            throw ApiException.new500InternalServerError((String)"You must configure a salt value for password hashing.", (Object[])new Object[0]);
        }
        String strongHash = JdbcDbUserDao.strongHash(salt, supplied);
        String weakHash = JdbcDbUserDao.weakHash(supplied);
        return actual.equals(strongHash) || actual.equals(weakHash);
    }

    public User getUser(AuthAction action, String username, String suppliedPassword, String apiName, String tenant) throws ApiException {
        User user = null;
        try {
            Connection conn;
            Rows.Row userRow;
            String sql = "";
            if (username != null) {
                sql = sql + " SELECT DISTINCT u.*";
                sql = sql + " FROM User u   ";
                sql = sql + " WHERE (u.revoked IS NULL OR u.revoked != 1) ";
                sql = sql + " AND u.username = ? ";
                sql = sql + " LIMIT 1 ";
            }
            if ((userRow = JdbcUtils.selectRow(conn = this.db.getConnection(), sql, username)) != null) {
                CaseInsensitiveMap map = new CaseInsensitiveMap((Map)userRow);
                String actualPassword = (String)map.get((Object)"password");
                if (this.checkPassword(actualPassword, suppliedPassword)) {
                    user = new User();
                    user.withId(Integer.parseInt(map.get((Object)"id") + "")).withUsername((String)map.get((Object)"username")).withAccessKey((String)map.get((Object)"accessKey")).withTenant((String)map.get((Object)"tenant"));
                }
                if (user != null) {
                    Rows rows = this.findGRP(conn, user.getId(), apiName, tenant);
                    if (rows == null || rows.size() == 0) {
                        user = null;
                    } else {
                        this.populateGRP(user, rows);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw ApiException.new500InternalServerError((Throwable)ex);
        }
        return user;
    }

    void populateGRP(User user, Rows rows) {
        for (Rows.Row row : rows) {
            String type = row.getString("type");
            String name = row.getString("name");
            if (name == null) continue;
            switch (type) {
                case "group": {
                    user.withGroups(new String[]{name});
                    break;
                }
                case "role": {
                    user.withRoles(new String[]{name});
                    break;
                }
                case "permission": {
                    user.withPermissions(new String[]{name});
                }
            }
        }
    }

    protected Rows findGRP(Connection conn, int userId, String api, String tenant) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = "";
        sql = sql + "SELECT * FROM (";
        sql = sql + "\r\n    SELECT 'permission' as type, p.name, 'user->permission' as via";
        sql = sql + "\r\n    FROM Permission p";
        sql = sql + "\r\n    JOIN UserPermission u ON p.id = u.permissionId";
        sql = sql + "\r\n    WHERE u.userId = ?";
        values.add(userId);
        sql = sql + "\r\n     AND ((p.api is null OR p.api = ?) AND (p.tenant is null OR p.tenant = ?))";
        sql = sql + "\r\n     AND ((u.api is null OR u.api = ?) AND (u.tenant is null OR u.tenant = ?))";
        values.addAll(Arrays.asList(api, tenant, api, tenant));
        sql = sql + "\r\n                                                           ";
        sql = sql + "\r\n    UNION";
        sql = sql + "\r\n                                                           ";
        sql = sql + "\r\n    SELECT 'permission' as type, p.name, 'user->group->permission' as via";
        sql = sql + "\r\n    FROM Permission p";
        sql = sql + "\r\n    JOIN GroupPermission g ON p.id = g.permissionId";
        sql = sql + "\r\n    JOIN UserGroup u ON u.groupId = g.groupId ";
        sql = sql + "\r\n    WHERE u.userId = ?";
        sql = sql + "\r\n     AND ((p.api is null OR p.api = ?) AND (p.tenant is null OR p.tenant = ?))";
        sql = sql + "\r\n     AND ((g.api is null OR g.api = ?) AND (g.tenant is null OR g.tenant = ?))";
        sql = sql + "\r\n     AND ((u.api is null OR u.api = ?) AND (u.tenant is null OR u.tenant = ?))";
        values.addAll(Arrays.asList(userId, api, tenant, api, tenant, api, tenant));
        sql = sql + "\r\n                                                           ";
        sql = sql + "\r\n    UNION";
        sql = sql + "\r\n                                                           ";
        sql = sql + "\r\n    SELECT 'permission' as type, p.name, 'user->role->permission' as via";
        sql = sql + "\r\n    FROM Permission p";
        sql = sql + "\r\n    JOIN RolePermission r ON p.id = r.permissionId";
        sql = sql + "\r\n    JOIN UserRole u ON u.roleId = r.roleId ";
        sql = sql + "\r\n    WHERE u.userId = ?";
        sql = sql + "\r\n     AND ((p.api is null OR p.api = ?) AND (p.tenant is null OR p.tenant = ?))";
        sql = sql + "\r\n     AND ((r.api is null OR r.api = ?) AND (r.tenant is null OR r.tenant = ?))";
        sql = sql + "\r\n     AND ((u.api is null OR u.api = ?) AND (u.tenant is null OR u.tenant = ?))";
        values.addAll(Arrays.asList(userId, api, tenant, api, tenant, api, tenant));
        sql = sql + "\r\n                                                           ";
        sql = sql + "\r\n    UNION";
        sql = sql + "\r\n                                                           ";
        sql = sql + "\r\n    SELECT 'permission' as type, p.name, 'user->group->role->permission' as via";
        sql = sql + "\r\n    FROM Permission p";
        sql = sql + "\r\n    JOIN RolePermission r ON p.id = r.permissionId";
        sql = sql + "\r\n    JOIN GroupRole g ON r.roleID = g.roleId";
        sql = sql + "\r\n    JOIN UserGroup u ON g.groupId = u.groupId";
        sql = sql + "\r\n    WHERE u.userId = ?";
        sql = sql + "\r\n     AND ((p.api is null OR p.api = ?) AND (p.tenant is null OR p.tenant = ?))";
        sql = sql + "\r\n     AND ((r.api is null OR r.api = ?) AND (r.tenant is null OR r.tenant = ?))";
        sql = sql + "\r\n     AND ((g.api is null OR g.api = ?) AND (g.tenant is null OR g.tenant = ?))";
        sql = sql + "\r\n     AND ((u.api is null OR u.api = ?) AND (u.tenant is null OR u.tenant = ?))";
        values.addAll(Arrays.asList(userId, api, tenant, api, tenant, api, tenant, api, tenant));
        sql = sql + "\r\n                                                           ";
        sql = sql + "\r\n    UNION";
        sql = sql + "\r\n                                                           ";
        sql = sql + "\r\n    SELECT 'group' as type, g.name, '' as via";
        sql = sql + "\r\n    FROM `Group` g";
        sql = sql + "\r\n    JOIN UserGroup u ON g.id = u.groupId";
        sql = sql + "\r\n    WHERE u.userId = ?";
        sql = sql + "\r\n     AND ((u.api is null OR u.api = ?) AND (u.tenant is null OR u.tenant = ?))";
        values.addAll(Arrays.asList(userId, api, tenant));
        sql = sql + "\r\n                                                           ";
        sql = sql + "\r\n    UNION";
        sql = sql + "\r\n                                                           ";
        sql = sql + "\r\n    SELECT 'role' as type, r.name, '' as via";
        sql = sql + "\r\n    FROM Role r";
        sql = sql + "\r\n    JOIN UserRole u ON r.id = u.roleId";
        sql = sql + "\r\n    WHERE u.userId = ?";
        sql = sql + "\r\n     AND ((u.api is null OR u.api = ?) AND (u.tenant is null OR u.tenant = ?))";
        values.addAll(Arrays.asList(userId, api, tenant));
        sql = sql + " ) as q ORDER BY type, name, via";
        System.out.println(sql + " -> " + values);
        return JdbcUtils.selectRows(conn, sql, values);
    }

    public JdbcDbUserDao withDb(JdbcDb db) {
        this.db = db;
        return this;
    }

    public JdbcDb getDb() {
        return this.db;
    }

    public void setDb(JdbcDb db) {
        this.db = db;
    }

    public JdbcDbUserDao withSalt(String salt) {
        this.salt = salt;
        return this;
    }

    public String getSalt() {
        return Config.getString((String)(this.getName() + ".salt"), (String)this.salt);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

