/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.jdbc;

import io.inversion.Db;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;

class JdbcConnectionLocal {
    static final Map<Db, Map<Thread, Connection>> dbToThreadMap = new Hashtable<Db, Map<Thread, Connection>>();
    static final Map<Thread, Map<Db, Connection>> threadToDbMap = new Hashtable<Thread, Map<Db, Connection>>();

    JdbcConnectionLocal() {
    }

    public static void closeAll() {
        for (Thread thread : threadToDbMap.keySet()) {
            try {
                JdbcConnectionLocal.close(thread);
            }
            catch (Exception exception) {}
        }
    }

    public static Connection getConnection(Db db) {
        return JdbcConnectionLocal.getConnection(db, Thread.currentThread());
    }

    static Connection getConnection(Db db, Thread thread) {
        Map<Thread, Connection> threadToConnMap = dbToThreadMap.get(db);
        if (threadToConnMap == null) {
            return null;
        }
        return threadToConnMap.get(thread);
    }

    public static void putConnection(Db db, Connection connection) {
        JdbcConnectionLocal.putConnection(db, Thread.currentThread(), connection);
    }

    static void putConnection(Db db, Thread thread, Connection connection) {
        Map threadToConnMap = dbToThreadMap.computeIfAbsent(db, k -> new Hashtable());
        threadToConnMap.put(thread, connection);
        Map dbToConnMap = threadToDbMap.computeIfAbsent(thread, k -> new Hashtable());
        dbToConnMap.put(db, connection);
    }

    public static void commit() throws Exception {
        Exception toThrow = null;
        Map<Db, Connection> dbToConnMap = threadToDbMap.get(Thread.currentThread());
        if (dbToConnMap != null) {
            Collection<Connection> connections = dbToConnMap.values();
            for (Connection conn : connections) {
                try {
                    if (conn.isClosed() || conn.getAutoCommit()) continue;
                    conn.commit();
                }
                catch (Exception ex) {
                    if (toThrow != null) continue;
                    toThrow = ex;
                }
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    public static void rollback() throws Exception {
        Exception toThrow = null;
        Map<Db, Connection> dbToConnMap = threadToDbMap.get(Thread.currentThread());
        if (dbToConnMap != null) {
            for (Connection conn : dbToConnMap.values()) {
                try {
                    if (conn.isClosed() || conn.getAutoCommit()) continue;
                    conn.rollback();
                }
                catch (Exception ex) {
                    if (toThrow != null) continue;
                    toThrow = ex;
                }
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    public static void close() throws Exception {
        JdbcConnectionLocal.close(Thread.currentThread());
    }

    static void close(Thread thread) throws Exception {
        Exception toThrow = null;
        Map<Db, Connection> dbToConnMap = threadToDbMap.remove(thread);
        if (dbToConnMap != null) {
            ArrayList<Db> dbs = new ArrayList<Db>(dbToConnMap.keySet());
            for (Db db : dbs) {
                Map<Thread, Connection> threadToConnMap = dbToThreadMap.get(db);
                threadToConnMap.remove(thread);
                if (threadToConnMap.size() == 0) {
                    dbToThreadMap.remove(db);
                }
                try {
                    Connection conn = dbToConnMap.get(db);
                    if (conn.isClosed()) continue;
                    conn.close();
                }
                catch (Exception ex) {
                    if (toThrow != null) continue;
                    toThrow = ex;
                }
            }
            if (dbToConnMap.size() == 0) {
                threadToDbMap.remove(thread);
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }
}

