/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.openapi;

import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Collection;
import io.inversion.Op;
import io.inversion.Param;
import io.inversion.Property;
import io.inversion.Request;
import io.inversion.Server;
import io.inversion.Url;
import io.inversion.action.openapi.OpenAPIWriter;
import io.inversion.action.security.AuthScheme;
import io.inversion.utils.ListMap;
import io.inversion.utils.Path;
import io.inversion.utils.Task;
import io.inversion.utils.Utils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OpenAPISpecWriter
implements OpenAPIWriter<OpenAPISpecWriter> {
    protected List<String> ignoredSuffixes = (List)Utils.add(new ArrayList(), (Object[])new Object[]{".json", ".yaml", ".html", ".xml"});

    protected String getDescription() {
        InputStream is = Utils.findInputStream((Object)this, (String[])new String[]{"description.md"});
        if (is != null) {
            return Utils.read((InputStream)is);
        }
        return "";
    }

    public OpenAPI writeOpenAPI(Request req, OpenAPI openApi) throws ApiException {
        ArrayList<Op> opsToDoc = new ArrayList<Op>(req.getApi().getOps());
        opsToDoc.removeIf(o -> this.ignoredSuffixes.parallelStream().anyMatch(suffix -> o.getPath().toString().endsWith((String)suffix)));
        LinkedHashMap<Object, Schema> schemas = new LinkedHashMap<Object, Schema>();
        this.documentInfo(openApi, req);
        this.documentServers(openApi, opsToDoc, req);
        this.documentSchemas(openApi, req);
        this.documentPathItems(openApi, opsToDoc);
        this.documentOperations(openApi, opsToDoc, schemas);
        this.removeInternalOps(openApi, opsToDoc);
        return openApi;
    }

    protected void removeInternalOps(OpenAPI openApi, List<Op> ops) {
        for (Op op : ops) {
            if (!op.isInternal()) continue;
            switch (op.getMethod().toUpperCase()) {
                case "GET": {
                    ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).setGet(null);
                    break;
                }
                case "POST": {
                    ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).setPost(null);
                    break;
                }
                case "PUT": {
                    ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).setPut(null);
                    break;
                }
                case "PATCH": {
                    ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).setPatch(null);
                    break;
                }
                case "DELETE": {
                    ((PathItem)openApi.getPaths().get((Object)op.getOperationPath())).setDelete(null);
                }
            }
        }
    }

    protected void documentInfo(OpenAPI openApi, Request req) {
        Info info = openApi.getInfo();
        if (info == null) {
            info = new Info();
            openApi.setInfo(info);
        }
        if (info.getVersion() == null) {
            String version = req.getApi().getVersion();
            if (version == null) {
                version = "0.1";
            }
            info.setVersion(version);
        }
        if (info.getTitle() == null) {
            info.setTitle(req.getApi().getName());
        }
        if (info.getDescription() == null) {
            info.setDescription(this.getDescription());
        }
    }

    protected void documentServers(OpenAPI openApi, List<Op> ops, Request req) {
        if (openApi.getServers() == null) {
            ArrayList<io.swagger.v3.oas.models.servers.Server> apiServers = new ArrayList<io.swagger.v3.oas.models.servers.Server>();
            ListMap serversMap = new ListMap();
            Api api = ops.get(0).getApi();
            for (Server serv : api.getServers()) {
                if (!serv.isDocumented()) continue;
                for (Url url : serv.getUrls()) {
                    io.swagger.v3.oas.models.servers.Server server = new io.swagger.v3.oas.models.servers.Server();
                    apiServers.add(server);
                    String urlStr = url.toString();
                    if (urlStr.startsWith("http://127.0.0.1:8080")) {
                        urlStr = urlStr.substring("http://localhost:8080".length());
                    }
                    server.setUrl(urlStr);
                    Path host = url.getHostAsPath();
                    if (host == null) continue;
                    for (int i = 0; i < host.size(); ++i) {
                        if (!host.isVar(i)) continue;
                        ServerVariables variables = server.getVariables();
                        if (variables == null) {
                            variables = new ServerVariables();
                            server.setVariables(variables);
                        }
                        ServerVariable var = new ServerVariable();
                        variables.put((Object)host.getVarName(i), (Object)var);
                    }
                }
            }
            openApi.setServers(apiServers);
        }
    }

    protected void documentSchemas(OpenAPI openApi, Request req) {
        HashMap schemas;
        Components comps = openApi.getComponents();
        if (comps == null) {
            comps = new Components();
            openApi.setComponents(comps);
        }
        if ((schemas = comps.getSchemas()) == null) {
            schemas = new HashMap();
            comps.setSchemas(schemas);
        }
        this.documentErrorSchema(openApi);
    }

    protected String getDescription(AuthScheme scheme, Param param) {
        String paramDesc;
        String schemeDesc = scheme.getDescription();
        String string = paramDesc = param == null ? null : param.getDescription();
        if (schemeDesc == null && paramDesc == null) {
            return null;
        }
        if (schemeDesc != null && paramDesc != null) {
            return schemeDesc + " " + paramDesc;
        }
        if (schemeDesc != null) {
            return schemeDesc;
        }
        return paramDesc;
    }

    protected void documentErrorSchema(OpenAPI openApi) {
        if (openApi.getComponents().getSchemas().get("error") != null) {
            return;
        }
        Schema schema = new Schema();
        openApi.getComponents().addSchemas("error", schema);
        schema.addProperties("status", this.newTypeSchema("string", null));
        schema.addProperties("message", this.newTypeSchema("string", null));
        schema.addProperties("error", this.newTypeSchema("string", null));
    }

    protected void documentPathItems(OpenAPI openApi, List<Op> opsToDoc) {
        if (openApi.getPaths() == null) {
            openApi.setPaths(new Paths());
        }
        for (Op op : opsToDoc) {
            String path = op.getOperationPath();
            PathItem pathItem = (PathItem)openApi.getPaths().get((Object)path);
            if (pathItem != null) continue;
            this.documentPathItem(openApi, op);
        }
    }

    protected void documentPathItem(OpenAPI openApi, Op op) {
        PathItem pathItem = (PathItem)openApi.getPaths().get((Object)op.getPath());
        if (pathItem == null) {
            pathItem = new PathItem();
            openApi.getPaths().addPathItem(op.getOperationPath(), pathItem);
        }
        String operationPath = op.getOperationPath();
        Path pathMatch = op.getPath();
        Path path = new Path(new String[]{operationPath});
        for (int i = 0; i < path.size(); ++i) {
            Collection coll;
            Property prop;
            String name = path.get(i);
            if (!path.isVar(i)) continue;
            name = path.getVarName(i);
            if (name == null) {
                name = path.getRegex(i);
            }
            Schema schema = null;
            if (op.getCollection() != null && (prop = (coll = op.getCollection()).getProperty(name)) != null) {
                String type = prop.getJsonType();
                if (type.equalsIgnoreCase("number")) {
                    schema = this.newTypeSchema("number", null);
                }
                if (type.equalsIgnoreCase("boolean")) {
                    schema = this.newTypeSchema("boolean", null);
                }
            }
            if (schema == null) {
                schema = this.newTypeSchema("string", null);
                String regex = pathMatch.getRegex(i);
                if (regex != null) {
                    schema.setPattern(regex);
                }
            }
            Parameter param = new Parameter();
            param.setName(name);
            param.setIn("path");
            param.setRequired(Boolean.valueOf(true));
            param.setSchema(schema);
            boolean hasParam = false;
            if (pathItem.getParameters() != null) {
                for (Parameter existing : pathItem.getParameters()) {
                    if (!name.equalsIgnoreCase(existing.getName()) || !param.getIn().equalsIgnoreCase(existing.getIn())) continue;
                    hasParam = true;
                    break;
                }
            }
            if (hasParam) continue;
            pathItem.addParametersItem(param);
        }
    }

    protected void documentOperations(OpenAPI openApi, List<Op> ops, Map<Object, Schema> schemas) {
        for (Op op : ops) {
            ArrayList<OpenAPISpecWriter> writers = new ArrayList<OpenAPISpecWriter>();
            writers.add(this);
            ArrayList<Object> actions = new ArrayList<Object>(op.getActions());
            actions.removeIf(o -> !(o instanceof OpenAPIWriter));
            writers.addAll(actions);
            Task.buildTask(writers, (String)"hook_documentOp", (Object[])new Object[]{openApi, ops, op, schemas}).go();
        }
    }

    @Override
    public Operation hook_documentOp(Task docChain, OpenAPI openApi, List<Op> ops, Op op, Map<Object, Schema> schemas) {
        return OpenAPIWriter.super.hook_documentOp(docChain, openApi, ops, op, schemas);
    }
}

