/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.action.openapi;

import io.inversion.ApiException;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.action.misc.FileAction;
import io.inversion.action.openapi.OpenAPISpecWriter;
import io.inversion.json.JSNode;
import io.inversion.json.JSParser;
import io.inversion.utils.Path;
import io.inversion.utils.Utils;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.InputStream;

public class OpenAPIAction<A extends OpenAPIAction>
extends FileAction<A> {
    protected String templateBaseDir = "openapi/templates";
    protected String patchesBaseDir = "openapi/patches";
    protected String outputBaseDir = "openapi/output";
    protected OpenAPISpecWriter writer = new OpenAPISpecWriter();
    protected boolean copyToOutputDirInDevMode = true;

    public OpenAPIAction() {
        this.withFiles(new String[]{"rapidoc.html", "openapi.json", "openapi.yml"});
    }

    public void doGet(Request req, Response res) throws ApiException {
        boolean filterMode = req.getOp() == null;
        String file = req.getUrl().getPath().last();
        if (this.canServe(file)) {
            if ("openapi.json".equalsIgnoreCase(file) || "openapi.yaml".equalsIgnoreCase(file)) {
                this.serveOpenApi(req, res, file);
                if (filterMode) {
                    req.getChain().cancel();
                }
            } else {
                super.serveFile(req, res);
            }
        }
    }

    void writeFile(Request req, Response res, String baseDir, String file, String content) {
        Object filePath = null;
        try {
            String apiName = req.getApi().getName();
            if (apiName == null) {
                apiName = "UNNAMED";
            }
            filePath = baseDir + "/" + apiName + "/" + file;
            filePath = ((String)filePath).replace("//", "/");
            File f = new File((String)filePath);
            f.getParentFile().mkdirs();
            Utils.write((File)f, (String)content);
            this.log.warn("Writing debug file: {}", filePath);
        }
        catch (Exception ex) {
            this.log.warn("Error writing out debug file to disk: " + filePath, (Throwable)ex);
        }
    }

    public void serveOpenApi(Request req, Response res, String file) {
        if (req.getApi() == null && !req.getEngine().matchApi(req)) {
            return;
        }
        try {
            File debug = new File("./openapi.json");
            if (debug.exists()) {
                JSNode json = (JSNode)JSParser.parseJson((InputStream)debug.toURI().toURL().openStream());
                res.withJson(json);
                return;
            }
            OpenAPI openApi = this.generateOpenApi(req);
            JSNode json = this.writeOpenAPI(req, openApi);
            openApi = (OpenAPI)Json.mapper().readValue(json.toString(), OpenAPI.class);
            if (file.toLowerCase().endsWith(".yaml")) {
                res.withJson((JSNode)null);
                res.withContentType("application/yaml");
                res.withText(Yaml.pretty((Object)openApi));
            } else {
                res.withJson(json);
            }
            if (req.isDebug()) {
                this.writeFile(req, res, this.outputBaseDir, "openapi.json", json.toString());
                this.writeFile(req, res, this.outputBaseDir, "openapi.yaml", Yaml.pretty((Object)openApi));
            }
        }
        catch (Exception ex) {
            throw ApiException.new500InternalServerError((Throwable)ex);
        }
    }

    public JSNode writeOpenAPI(Request req, OpenAPI openApi) {
        String string = Json.pretty((Object)openApi);
        JSNode json = JSParser.asJSNode((String)string);
        return json;
    }

    public OpenAPI generateOpenApi(Request req) {
        OpenAPI openApi = new OpenAPI();
        String template = this.findTemplate(req);
        if (template != null) {
            SwaggerParseResult result = new OpenAPIParser().readContents(template, null, null);
            openApi = result.getOpenAPI();
        }
        return this.writer.writeOpenAPI(req, openApi);
    }

    public String findTemplate(Request req) {
        if (this.templateBaseDir != null) {
            Path path = req.getUrl().getPath();
            for (int i = path.size() - 1; i >= 0; --i) {
                String pathString = path.subpath(0, i).toString();
                String templatePath = new Path(new String[]{this.templateBaseDir, pathString, "openapi.json"}).toString();
                InputStream stream = Utils.findInputStream((Object)((Object)this), (String)templatePath);
                if (stream == null) {
                    templatePath = new Path(new String[]{this.templateBaseDir, pathString, "openapi.yaml"}).toString();
                    stream = Utils.findInputStream((Object)((Object)this), (String)templatePath);
                }
                if (stream == null) continue;
                return Utils.read((InputStream)stream);
            }
        }
        return null;
    }

    public String getTemplateBaseDir() {
        return this.templateBaseDir;
    }

    public OpenAPIAction withTemplateBaseDir(String templateBaseDir) {
        this.templateBaseDir = templateBaseDir;
        return this;
    }

    public String getPatchesBaseDir() {
        return this.patchesBaseDir;
    }

    public OpenAPIAction withPatchesBaseDir(String patchesBaseDir) {
        this.patchesBaseDir = patchesBaseDir;
        return this;
    }

    public String getOutputBaseDir() {
        return this.outputBaseDir;
    }

    public OpenAPIAction withOutputBaseDir(String outputBaseDir) {
        this.outputBaseDir = outputBaseDir;
        return this;
    }

    public OpenAPISpecWriter getWriter() {
        return this.writer;
    }

    public OpenAPIAction withWriter(OpenAPISpecWriter writer) {
        this.writer = writer;
        return this;
    }
}

