/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.elasticsearch;

import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Property;
import io.inversion.Results;
import io.inversion.elasticsearch.ElasticsearchQuery;
import io.inversion.elasticsearch.WrappedQueryBuilder;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;
import io.inversion.json.JSParser;
import io.inversion.rql.Query;
import io.inversion.rql.Term;
import io.inversion.utils.Rows;
import io.inversion.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;

public class ElasticsearchDb
extends Db<ElasticsearchDb> {
    public final String defaultSource;
    protected final int maxRequestDuration = 10000;
    protected final int[] allowedFailResponseCodes = new int[]{400, 401, 403, 404};
    public int maxElasticQuerySize = 10000;
    protected String url = null;
    private transient RestHighLevelClient client;

    public ElasticsearchDb() {
        this.defaultSource = null;
        this.withType("elasticsearch");
    }

    public ElasticsearchDb(String elasticUrl) {
        this.defaultSource = null;
        this.url = elasticUrl;
    }

    public ElasticsearchDb(String name, String url) {
        this(url);
        this.withName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestHighLevelClient getElasticClient() {
        if (this.client == null) {
            ElasticsearchDb elasticsearchDb = this;
            synchronized (elasticsearchDb) {
                if (this.client == null) {
                    this.client = this.buildElasticClient(this.url);
                }
            }
        }
        return this.client;
    }

    private RestHighLevelClient buildElasticClient(String url) {
        RestHighLevelClient client = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)url)}));
        return client;
    }

    public Results<Rows.Row> doSelect(Collection table, List<Term> columnMappedTerms) throws ApiException {
        ElasticsearchQuery query = new ElasticsearchQuery(this, table, columnMappedTerms);
        if (this.defaultSource != null && query.getSelect().find(new String[]{"source"}) == null) {
            query.getSelect().withTerm("source=id");
        }
        JSNode json = query.getJson();
        SearchResponse res = null;
        if (json != null) {
            SearchRequest searchReq = new SearchRequest(new String[]{table.getTableName()});
            searchReq.source(query.getSearchBuilder());
            try {
                System.out.println(query.getJson());
                res = this.getElasticClient().search(searchReq, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                throw ApiException.new500InternalServerError((String)("The elastic client failed to search/select. " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        Results result = new Results((Query)query);
        int statusCode = res.status().getStatus();
        if (this.isSuccess(statusCode)) {
            SearchHit[] hitArray;
            SearchHits hits = res.getHits();
            System.out.println("total hits: " + hits.getTotalHits().value);
            for (SearchHit hit : hitArray = hits.getHits()) {
                result.withRow(hit.getSourceAsMap());
            }
            result.withFoundRows((int)hits.getTotalHits().value);
        } else {
            System.out.println("request failed (");
        }
        return result;
    }

    public void doDelete(Collection table, List<Map<String, Object>> indexValues) throws ApiException {
        for (Map<String, Object> row : indexValues) {
            this.deleteRow(table, row);
        }
    }

    protected void deleteRow(Collection collection, Map<String, Object> indexValues) throws ApiException {
        String id = collection.encodeKeyFromColumnNames(indexValues);
        try {
            DeleteRequest request = new DeleteRequest(collection.getTableName(), "doc", id.toString());
            Chain.debug((String)("ElasticDb: Delete request=" + request.toString()), (Object[])new Object[0]);
            DeleteResponse response = this.getElasticClient().delete(request, RequestOptions.DEFAULT);
            int statusCode = response.status().getStatus();
            if (statusCode >= 400) {
                throw ApiException.new500InternalServerError((String)"Unexpected http status code returned from database: %s", (Object[])new Object[]{statusCode});
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ApiException.new500InternalServerError((Throwable)ex);
        }
    }

    public List doUpsert(Collection table, List<Map<String, Object>> rows) throws ApiException {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map<String, Object> row : rows) {
            keys.add(this.upsertRow(table, row));
        }
        return keys;
    }

    public String upsertRow(Collection table, Map<String, Object> columnMappedTermsRow) throws ApiException {
        UpdateResponse response;
        JSMap doc = new JSMap(columnMappedTermsRow);
        String id = doc.getString((Object)"id");
        if (id == null) {
            id = table.encodeKeyFromColumnNames(columnMappedTermsRow);
            if (id == null) {
                throw ApiException.new400BadRequest((String)"Your record does not contain the required key fields.", (Object[])new Object[0]);
            }
            doc.putFirst("id", (Object)id);
        }
        String json = doc.toString();
        UpdateRequest updateRequest = new UpdateRequest(table.getTableName(), "doc", id);
        updateRequest.upsert(json, XContentType.JSON);
        Chain.debug((String)("ElasticDb: Upsert " + updateRequest.toString()), (Object[])new Object[0]);
        try {
            response = this.getElasticClient().update(updateRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw ApiException.new500InternalServerError((String)("The elastic client failed to upsert. " + e.getMessage()), (Object[])new Object[0]);
        }
        int statusCode = response.status().getStatus();
        if (statusCode > 299) {
            throw ApiException.new400BadRequest((String)"Unexpected http status code returned from database: '%s'", (Object[])new Object[]{statusCode});
        }
        String returnedId = response.getId();
        if (!Utils.equal((Object)id, (Object)returnedId)) {
            throw ApiException.new500InternalServerError((String)"The supplied 'id' field does not match the returned 'id' field: '%s' vs. '%s'", (Object[])new Object[]{id, returnedId});
        }
        return id;
    }

    private void handleAutoSuggestRequest() {
    }

    private void handleSearchRequest() {
    }

    private void handlePaging(WrappedQueryBuilder builder) {
    }

    public void configDb() throws ApiException {
        block4: {
            try {
                Response allResponse = this.getElasticClient().getLowLevelClient().performRequest(new Request("GET", "/_all"));
                int statusCode = allResponse.getStatusLine().getStatusCode();
                if (this.isSuccess(statusCode)) {
                    JSMap jsObj;
                    JSMap jsContentMap = jsObj = JSParser.asJSMap((String)EntityUtils.toString((HttpEntity)allResponse.getEntity()));
                    HashMap<String, Collection> tableMap = new HashMap<String, Collection>();
                    for (Map.Entry entry : jsContentMap.entrySet()) {
                        this.buildTables((String)entry.getKey(), (JSNode)entry.getValue(), tableMap);
                    }
                    break block4;
                }
                throw new ApiException("Failed to retieve /_all with status code:" + statusCode, new Object[0]);
            }
            catch (Exception ex) {
                Utils.rethrow((Throwable)ex);
            }
        }
    }

    protected Collection buildCollection(String tableName) {
        return null;
    }

    private void buildTables(String elasticName, JSNode jsIndex, Map<String, Collection> tableMap) {
        Collection table;
        Map jsMappingsDocProps = (Map)jsIndex.getMap((Object)"mappings").getNode((Object)"_doc").getNode((Object)"properties");
        if (tableMap.containsKey(elasticName)) {
            table = tableMap.get(elasticName);
        } else {
            table = new Collection(elasticName).withDb((Db)this);
            tableMap.put(elasticName, table);
        }
        this.withCollection(table);
        this.addColumns(table, false, jsMappingsDocProps, "");
        JSMap jsAliasProps = jsIndex.getMap((Object)"aliases");
        for (Map.Entry propEntry : jsAliasProps.entrySet()) {
            String aliasName = (String)propEntry.getKey();
            if (tableMap.containsKey(aliasName)) {
                table = tableMap.get(aliasName);
            } else {
                table = new Collection(aliasName).withDb((Db)this);
                tableMap.put(aliasName, table);
            }
            this.withCollection(table);
            this.addColumns(table, false, jsMappingsDocProps, "");
        }
    }

    private void addColumns(Collection table, boolean nullable, Map<String, JSMap> jsPropsMap, String parentPrefix) {
        for (Map.Entry<String, JSMap> propEntry : jsPropsMap.entrySet()) {
            String colName = parentPrefix + propEntry.getKey();
            JSMap propValue = propEntry.getValue();
            if (!propValue.containsKey((Object)"type") || table.getProperty(colName) != null) continue;
            Property columnProp = new Property(colName, propValue.getString((Object)"type"), true);
            table.withProperties(new Property[]{columnProp});
        }
    }

    public String getUrl() {
        return this.url;
    }

    public ElasticsearchDb withUrl(String url) {
        this.url = url;
        return this;
    }

    private boolean isSuccess(int statusCode) {
        return statusCode >= 200 && statusCode <= 300;
    }
}

