/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.elasticsearch;

import io.inversion.ApiException;
import io.inversion.Index;
import io.inversion.elasticsearch.ElasticsearchQuery;
import io.inversion.rql.Term;
import io.inversion.rql.Where;
import java.util.List;
import java.util.Map;

public class ElasticsearchWhere<T extends ElasticsearchWhere, P extends ElasticsearchQuery>
extends Where<T, P> {
    public ElasticsearchWhere(P query) {
        super(query);
        this.clearFunctions();
        this.withFunctions(new String[]{"eq", "ne", "gt", "ge", "lt", "le", "ew", "sw", "w", "wo", "nn", "n", "and", "or", "emp", "nemp", "search", "in", "out"});
    }

    protected Term transform(Term parent) {
        Term transformed = parent;
        for (Term child : parent.getTerms()) {
            if (child.isLeaf()) continue;
            if (!this.functions.contains(child.getToken())) {
                throw ApiException.new400BadRequest((String)"Invalid where function token '%s' : %s", (Object[])new Object[]{child.getToken(), parent});
            }
            this.transform(child);
        }
        if (parent.hasToken(new String[]{"_key"})) {
            String indexName = parent.getToken(0);
            Index index = ((ElasticsearchQuery)this.getParent()).getCollection().getIndex(indexName);
            if (index == null) {
                throw ApiException.new400BadRequest((String)"You can't use the _key() function unless your table has a unique index", (Object[])new Object[0]);
            }
            if (index.size() == 1) {
                Term t = Term.term(null, (String)"in", (Object[])new Object[]{index.getColumnName(0)});
                List children = parent.getTerms();
                for (int i = 1; i < children.size(); ++i) {
                    Term child = (Term)children.get(i);
                    t.withTerm(child);
                }
                if (t.getNumTerms() == 2) {
                    t.withToken("eq");
                }
                transformed = t;
            } else {
                Term or = Term.term(null, (String)"or", (Object[])new Object[0]);
                List children = parent.getTerms();
                transformed = or;
                for (int i = 1; i < children.size(); ++i) {
                    Term child = (Term)children.get(i);
                    if (!child.isLeaf()) {
                        throw ApiException.new400BadRequest((String)"Resource key value is not a leaf node: %s", (Object[])new Object[]{child});
                    }
                    Map keyParts = ((ElasticsearchQuery)this.getParent()).getCollection().decodeKeyToColumnNames(index, child.getToken());
                    Term and = Term.term((Term)or, (String)"and", (Object[])new Object[0]);
                    for (String key : keyParts.keySet()) {
                        and.withTerm(Term.term((Term)and, (String)"eq", (Object[])new Object[]{key, keyParts.get(key).toString()}));
                    }
                }
                if (or.getNumTerms() == 1) {
                    transformed = or.getTerm(0);
                    transformed.withParent(null);
                }
            }
        }
        if (parent.getParent() != null && transformed != parent) {
            parent.getParent().replaceTerm(parent, transformed);
        }
        return transformed;
    }
}

