/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.elasticsearch;

import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Results;
import io.inversion.elasticsearch.ElasticsearchDb;
import io.inversion.elasticsearch.ElasticsearchPage;
import io.inversion.elasticsearch.ElasticsearchSelect;
import io.inversion.elasticsearch.ElasticsearchWhere;
import io.inversion.elasticsearch.WrappedQueryBuilder;
import io.inversion.json.JSNode;
import io.inversion.json.JSParser;
import io.inversion.rql.From;
import io.inversion.rql.Group;
import io.inversion.rql.Order;
import io.inversion.rql.Page;
import io.inversion.rql.Query;
import io.inversion.rql.Select;
import io.inversion.rql.Term;
import io.inversion.rql.Where;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class ElasticsearchQuery
extends Query<ElasticsearchQuery, ElasticsearchDb, Select<Select<Select, ElasticsearchQuery>, ElasticsearchQuery>, From<From<From, ElasticsearchQuery>, ElasticsearchQuery>, Where<Where<Where, ElasticsearchQuery>, ElasticsearchQuery>, Group<Group<Group, ElasticsearchQuery>, ElasticsearchQuery>, Order<Order<Order, ElasticsearchQuery>, ElasticsearchQuery>, Page<Page<Page, ElasticsearchQuery>, ElasticsearchQuery>> {
    public ElasticsearchQuery() {
    }

    public ElasticsearchQuery(ElasticsearchDb db, Collection index, List<Term> terms) {
        super((Db)db, index, terms, new String[0]);
    }

    protected Select createSelect() {
        return new ElasticsearchSelect(this);
    }

    protected ElasticsearchWhere createWhere() {
        return new ElasticsearchWhere(this);
    }

    protected ElasticsearchPage createPage() {
        return new ElasticsearchPage(this);
    }

    public Results doSelect() throws ApiException {
        Results results = new Results((Query)this);
        ElasticsearchDb db = (ElasticsearchDb)this.getDb();
        Chain.debug((String)(this.collection + ""), (Object[])new Object[0]);
        String debug = "ElasticsearchDb: index: " + this.collection.getName() + ", QueryBuilder=" + this.getJson();
        debug = debug.replaceAll("\r", "");
        debug = debug.replaceAll("\n", " ");
        debug = debug.replaceAll(" +", " ");
        Chain.debug((String)debug, (Object[])new Object[0]);
        results.withTestQuery(debug);
        System.out.println();
        return results;
    }

    protected void push(List<JSNode> stack, JSNode child) {
    }

    public WrappedQueryBuilder buildQuery(Term parent, Term child) {
        ExistsQueryBuilder qb;
        String token = child.getToken().toLowerCase();
        String field = child.getToken(0);
        String value = null;
        ArrayList<WrappedQueryBuilder> childBuilderList = new ArrayList<WrappedQueryBuilder>();
        String nestedPath = this.getNestedBaseIfExists(field);
        for (Term term : child.getTerms()) {
            if (term.isLeaf()) continue;
            WrappedQueryBuilder childBuilder = this.buildQuery(child, term);
            childBuilderList.add(childBuilder);
        }
        if (child.getNumTerms() > 1) {
            value = child.getTerm(1).getToken();
        }
        switch (token) {
            case "gt": {
                qb = QueryBuilders.rangeQuery((String)field).gt((Object)value);
                break;
            }
            case "ge": {
                qb = QueryBuilders.rangeQuery((String)field).gte((Object)value);
                break;
            }
            case "lt": {
                qb = QueryBuilders.rangeQuery((String)field).lt((Object)value);
                break;
            }
            case "le": {
                qb = QueryBuilders.rangeQuery((String)field).lte((Object)value);
                break;
            }
            case "eq": {
                if (value instanceof String && value.contains("*")) {
                    qb = QueryBuilders.wildcardQuery((String)field, (String)value.toString());
                    break;
                }
                qb = QueryBuilders.termQuery((String)field, (Object)value);
                break;
            }
            case "ne": {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)field, (Object)value));
                break;
            }
            case "and": {
                WrappedQueryBuilder wqb = this.mergeChildBuilders(childBuilderList, child);
                if (wqb.hasNestedPath()) {
                    nestedPath = wqb.getNestedPath();
                }
                qb = wqb.getBuilder();
                break;
            }
            case "or": {
                BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
                for (WrappedQueryBuilder childBuilder : childBuilderList) {
                    if (childBuilder.hasNestedPath()) {
                        nestedPath = childBuilder.getNestedPath();
                    }
                    boolBuilder.should(childBuilder.getBuilder());
                }
                if (nestedPath != null) {
                    qb = QueryBuilders.nestedQuery((String)nestedPath, (QueryBuilder)boolBuilder, (ScoreMode)ScoreMode.Avg);
                    nestedPath = this.getNestedBaseIfExists(nestedPath);
                    break;
                }
                qb = boolBuilder;
                break;
            }
            case "sw": {
                qb = QueryBuilders.wildcardQuery((String)field, (String)(value + "*"));
                break;
            }
            case "ew": {
                qb = QueryBuilders.wildcardQuery((String)field, (String)("*" + value));
                break;
            }
            case "w": {
                ArrayList<WildcardQueryBuilder> withList = new ArrayList<WildcardQueryBuilder>();
                for (int i = 1; i < child.getNumTerms(); ++i) {
                    if (!child.getTerm(i).isLeaf()) continue;
                    value = child.getTerm(i).getToken();
                    withList.add(QueryBuilders.wildcardQuery((String)field, (String)("*" + value + "*")));
                }
                if (withList.size() > 1) {
                    BoolQueryBuilder bqb = QueryBuilders.boolQuery();
                    for (QueryBuilder queryBuilder : withList) {
                        bqb.should(queryBuilder);
                    }
                    qb = bqb;
                    break;
                }
                qb = (QueryBuilder)withList.get(0);
                break;
            }
            case "wo": {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)field, (String)("*" + value + "*")));
                break;
            }
            case "emp": {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)field, (String)"")).should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)field)));
                break;
            }
            case "nemp": {
                qb = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)field, (String)""))).must((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)field)));
                break;
            }
            case "nn": {
                qb = QueryBuilders.existsQuery((String)field);
                break;
            }
            case "n": {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)field));
                break;
            }
            case "in": {
                ArrayList<String> valueList = new ArrayList<String>();
                for (int i = 1; i < child.getNumTerms(); ++i) {
                    if (!child.getTerm(i).isLeaf()) continue;
                    valueList.add(child.getTerm(i).getToken());
                }
                qb = QueryBuilders.termsQuery((String)field, valueList);
                break;
            }
            case "out": {
                ArrayList<String> valueList = new ArrayList();
                for (int i = 1; i < child.getNumTerms(); ++i) {
                    if (!child.getTerm(i).isLeaf()) continue;
                    valueList.add(child.getTerm(i).getToken());
                }
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)field, valueList));
                break;
            }
            case "search": {
                qb = QueryBuilders.fuzzyQuery((String)field, (Object)value);
                break;
            }
            default: {
                throw new RuntimeException("unexpected rql token: " + token);
            }
        }
        return new WrappedQueryBuilder((QueryBuilder)qb, child, nestedPath);
    }

    public SearchSourceBuilder getSearchBuilder() {
        ArrayList<WrappedQueryBuilder> childList = new ArrayList<WrappedQueryBuilder>();
        for (Term term : this.where.getTerms()) {
            WrappedQueryBuilder wrappedChild = this.buildQuery(null, term);
            childList.add(wrappedChild);
        }
        WrappedQueryBuilder wrappedBuilder = this.mergeChildBuilders(childList, null);
        QueryBuilder root = wrappedBuilder.getBuilder();
        SearchSourceBuilder searchBuilder = null;
        if (this.select.getTerms().size() > 0) {
            if (searchBuilder == null) {
                searchBuilder = new SearchSourceBuilder();
            }
            ArrayList<String> includesList = null;
            ArrayList<String> excludesList = null;
            for (Term term : this.select.getTerms()) {
                String token = term.getToken();
                if (token.equalsIgnoreCase("source") || token.equalsIgnoreCase("include")) {
                    if (includesList == null) {
                        includesList = new ArrayList<String>();
                    }
                    for (Term selectTerm : term.getTerms()) {
                        includesList.add(selectTerm.getToken());
                    }
                    continue;
                }
                if (!token.equalsIgnoreCase("exclude")) continue;
                if (excludesList == null) {
                    excludesList = new ArrayList<String>();
                }
                for (Term selectTerm : term.getTerms()) {
                    excludesList.add(selectTerm.getToken());
                }
            }
            String[] includesArray = null;
            String[] excludesArray = null;
            if (includesList != null && includesList.size() > 0) {
                includesArray = new String[includesList.size()];
                includesArray = includesList.toArray(includesArray);
            }
            if (excludesList != null && excludesList.size() > 0) {
                excludesArray = new String[excludesList.size()];
                excludesArray = excludesList.toArray(excludesArray);
            }
            searchBuilder.fetchSource(includesArray, excludesArray);
        }
        if (searchBuilder == null) {
            searchBuilder = new SearchSourceBuilder();
        }
        boolean isSortingById = false;
        for (Order.Sort sort : this.order.getSorts()) {
            SortOrder so = sort.isAsc() ? SortOrder.ASC : SortOrder.DESC;
            String sortProp = sort.getProperty();
            searchBuilder.sort(sortProp, so);
            if (!sortProp.equals("id")) continue;
            isSortingById = true;
        }
        if (!isSortingById) {
            searchBuilder.sort("id", SortOrder.ASC);
        }
        if (this.page.getTerms().size() > 0) {
            searchBuilder.size(this.page.getPageSize());
            if (this.page.getPageNum() - 1 > 0) {
                searchBuilder.from(this.page.getPageNum());
            }
        }
        return searchBuilder.query(root);
    }

    public JSNode getJson() {
        return JSParser.asJSNode((String)this.getSearchBuilder().toString());
    }

    private WrappedQueryBuilder mergeChildBuilders(List<WrappedQueryBuilder> childBuilderList, Term term) {
        BoolQueryBuilder qb = null;
        BoolQueryBuilder boolBuilder = null;
        ArrayList<WrappedQueryBuilder> nestedList = new ArrayList<WrappedQueryBuilder>();
        boolean nestedPathsMatch = true;
        String nestedPath = null;
        for (WrappedQueryBuilder wrappedQueryBuilder : childBuilderList) {
            if (wrappedQueryBuilder.hasNestedPath()) {
                nestedList.add(wrappedQueryBuilder);
                if (nestedPath != null && !nestedPath.equalsIgnoreCase(wrappedQueryBuilder.getNestedPath())) {
                    nestedPathsMatch = false;
                    continue;
                }
                nestedPath = wrappedQueryBuilder.getNestedPath();
                continue;
            }
            if (childBuilderList.size() == 1) {
                qb = wrappedQueryBuilder.getBuilder();
                continue;
            }
            if (boolBuilder == null) {
                boolBuilder = QueryBuilders.boolQuery();
            }
            boolBuilder.filter(wrappedQueryBuilder.getBuilder());
        }
        if (nestedList.size() > 0) {
            BoolQueryBuilder nestedBoolBuilder = QueryBuilders.boolQuery();
            if (nestedList.size() > 1) {
                for (WrappedQueryBuilder nestedBuilder : nestedList) {
                    if (nestedPathsMatch) {
                        nestedBoolBuilder.filter(nestedBuilder.getBuilder());
                        continue;
                    }
                    qb = QueryBuilders.nestedQuery((String)nestedBuilder.getNestedPath(), (QueryBuilder)nestedBuilder.getBuilder(), (ScoreMode)ScoreMode.Avg);
                    nestedBoolBuilder.filter((QueryBuilder)qb);
                }
                if (nestedPathsMatch) {
                    qb = QueryBuilders.nestedQuery((String)nestedPath, (QueryBuilder)nestedBoolBuilder, (ScoreMode)ScoreMode.Avg);
                    nestedPath = this.getNestedBaseIfExists(nestedPath);
                } else {
                    qb = nestedBoolBuilder;
                    nestedPath = null;
                }
            } else {
                WrappedQueryBuilder wrappedQueryBuilder = (WrappedQueryBuilder)nestedList.get(0);
                qb = QueryBuilders.nestedQuery((String)nestedPath, (QueryBuilder)wrappedQueryBuilder.getBuilder(), (ScoreMode)ScoreMode.Avg);
                nestedPath = this.getNestedBaseIfExists(nestedPath);
            }
        }
        if (boolBuilder != null) {
            qb = qb == null ? boolBuilder : boolBuilder.filter(qb);
        }
        return new WrappedQueryBuilder((QueryBuilder)qb, term, nestedPath);
    }

    private String getNestedBaseIfExists(String possibleNestedField) {
        String base = null;
        int lastPeriodIndex = possibleNestedField.lastIndexOf(".");
        if (lastPeriodIndex > 0 && lastPeriodIndex < possibleNestedField.length()) {
            base = possibleNestedField.substring(0, lastPeriodIndex);
        }
        return base;
    }
}

