/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.dynamodb;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.ItemUtils;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Index;
import io.inversion.Property;
import io.inversion.Results;
import io.inversion.dynamodb.DynamoDbQuery;
import io.inversion.rql.Term;
import io.inversion.utils.Config;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DynamoDb
extends Db<DynamoDb> {
    public static final String PRIMARY_INDEX_NAME = "Primary Index";
    public static final String PRIMARY_INDEX_TYPE = "primary";
    public static final String LOCAL_SECONDARY_INDEX_TYPE = "localsecondary";
    public static final String GLOBAL_SECONDARY_INDEX_TYPE = "globalsecondary";
    protected final int batchMax = 20;
    protected String awsAccessKey = null;
    protected String awsSecretKey = null;
    protected String awsRegion = "us-east-1";
    protected String awsEndpoint = null;
    protected String blueprintRow;
    protected transient AmazonDynamoDB dynamoClient = null;

    public DynamoDb() {
        this.withType("dynamodb");
    }

    public DynamoDb(String name, String includeTables) {
        this();
        this.withName(name);
        this.withIncludeTables(includeTables);
    }

    public static Index findIndexByName(Collection coll, String name) {
        if (coll != null && coll.getIndexes() != null) {
            for (Index index : coll.getIndexes()) {
                if (!index.getName().equals(name)) continue;
                return index;
            }
        }
        return null;
    }

    protected static String getTypeStringFromObject(Object obj) {
        if (obj instanceof Number) {
            return "N";
        }
        if (obj instanceof Boolean) {
            return "BOOL";
        }
        return "S";
    }

    public static AmazonDynamoDB buildDynamoClient(String prefix) {
        return DynamoDb.buildDynamoClient(Config.getString((String)(prefix + ".awsRegion")), Config.getString((String)(prefix + ".awsAccessKey")), Config.getString((String)(prefix + ".awsSecretKey")), Config.getString((String)(prefix + ".awsEndpoint")));
    }

    public static AmazonDynamoDB buildDynamoClient(String awsRegion, String awsAccessKey, String awsSecretKey, String awsEndpoint) {
        AmazonDynamoDBClientBuilder builder = AmazonDynamoDBClientBuilder.standard();
        if (!Utils.empty((Object[])new Object[]{awsRegion})) {
            if (!Utils.empty((Object[])new Object[]{awsEndpoint})) {
                AwsClientBuilder.EndpointConfiguration endpointConfig = new AwsClientBuilder.EndpointConfiguration(awsEndpoint, awsRegion);
                builder.withEndpointConfiguration(endpointConfig);
            } else {
                builder.withRegion(awsRegion);
            }
        }
        if (!Utils.empty((Object[])new Object[]{awsAccessKey}) && !Utils.empty((Object[])new Object[]{awsSecretKey})) {
            BasicAWSCredentials creds = new BasicAWSCredentials(awsAccessKey, awsSecretKey);
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)creds));
        }
        AmazonDynamoDB dynamoClient = (AmazonDynamoDB)builder.build();
        return dynamoClient;
    }

    public Results doSelect(Collection table, List<Term> columnMappedTerms) throws ApiException {
        DynamoDbQuery query = new DynamoDbQuery(this, table, columnMappedTerms).withDynamoTable(this.getDynamoTable(table));
        return query.doSelect();
    }

    public List<String> doUpsert(Collection table, List<Map<String, Object>> rows) throws ApiException {
        AmazonDynamoDB dynamoClient = this.getDynamoClient();
        ArrayList<String> keys = new ArrayList<String>();
        LinkedList<WriteRequest> writeRequests = new LinkedList<WriteRequest>();
        BatchWriteItemRequest batch = new BatchWriteItemRequest();
        for (int i = 0; i < rows.size(); ++i) {
            Map<String, Object> row = rows.get(i);
            String key = table.encodeResourceKey(row);
            keys.add(key);
            for (String attr : new ArrayList<String>(row.keySet())) {
                if (!Utils.empty((Object[])new Object[]{row.get(attr)})) continue;
                row.remove(attr);
            }
            if (i > 0 && i % 20 == 0) {
                batch.addRequestItemsEntry(table.getTableName(), writeRequests);
                dynamoClient.batchWriteItem(batch);
                batch.clearRequestItemsEntries();
                writeRequests.clear();
            }
            Map item = ItemUtils.fromSimpleMap(row);
            Chain.debug((Object[])new Object[]{"DynamoDb", "PutRequest", item});
            PutRequest put = new PutRequest().withItem(item);
            writeRequests.add(new WriteRequest(put));
        }
        if (writeRequests.size() > 0) {
            batch.addRequestItemsEntry(table.getTableName(), writeRequests);
            this.getDynamoClient().batchWriteItem(batch);
            batch.clearRequestItemsEntries();
            writeRequests.clear();
        }
        return keys;
    }

    public void delete(Collection table, List<Map<String, Object>> indexValues) throws ApiException {
        for (Map<String, Object> row : indexValues) {
            this.deleteRow(table, row);
        }
    }

    public void deleteRow(Collection table, Map<String, Object> row) throws ApiException {
        Table dynamo = this.getDynamoTable(table);
        Index pk = table.getPrimaryIndex();
        if (pk.size() == 1) {
            dynamo.deleteItem(pk.getProperty(0).getColumnName(), row.get(pk.getProperty(0).getColumnName()));
        } else if (pk.size() == 2) {
            dynamo.deleteItem(pk.getProperty(0).getColumnName(), row.get(pk.getProperty(0).getColumnName()), pk.getProperty(1).getColumnName(), row.get(pk.getProperty(1).getColumnName()));
        } else {
            throw ApiException.new400BadRequest((String)"A dynamo delete must have a hash key and an optional sortKey and that is it: '{}'", (Object[])new Object[]{row});
        }
    }

    public void configDb() throws ApiException {
        for (String tableName : this.includeTables.keySet()) {
            this.withCollection(this.buildCollection(tableName));
        }
    }

    protected Collection buildCollection(String tableName) {
        AmazonDynamoDB dynamoClient = this.getDynamoClient();
        Collection coll = new Collection(tableName);
        this.withCollection(coll);
        DynamoDB dynamoDB = new DynamoDB(dynamoClient);
        Table dynamoTable = dynamoDB.getTable(tableName);
        TableDescription tableDescription = dynamoTable.describe();
        for (AttributeDefinition attr : tableDescription.getAttributeDefinitions()) {
            coll.withProperty(attr.getAttributeName(), attr.getAttributeType(), true);
        }
        List keySchema = tableDescription.getKeySchema();
        this.addTableIndex(PRIMARY_INDEX_TYPE, PRIMARY_INDEX_NAME, keySchema, coll, true);
        if (tableDescription.getGlobalSecondaryIndexes() != null) {
            for (GlobalSecondaryIndexDescription indexDesc : tableDescription.getGlobalSecondaryIndexes()) {
                this.addTableIndex(GLOBAL_SECONDARY_INDEX_TYPE, indexDesc.getIndexName(), indexDesc.getKeySchema(), coll, false);
            }
        }
        if (tableDescription.getLocalSecondaryIndexes() != null) {
            for (GlobalSecondaryIndexDescription indexDesc : tableDescription.getLocalSecondaryIndexes()) {
                this.addTableIndex(LOCAL_SECONDARY_INDEX_TYPE, indexDesc.getIndexName(), indexDesc.getKeySchema(), coll, false);
            }
        }
        return coll;
    }

    protected void addTableIndex(String type, String indexName, List<KeySchemaElement> keySchemaList, Collection table, boolean unique) {
        Index index = new Index(indexName, type, unique, new Property[0]);
        for (KeySchemaElement keyInfo : keySchemaList) {
            Property property = table.getProperty(keyInfo.getAttributeName());
            index.withProperties(new Property[]{property});
            property.withColumnName(keyInfo.getAttributeName());
        }
        table.withIndexes(new Index[]{index});
    }

    public Table getDynamoTable(Collection table) {
        return this.getDynamoTable(table.getTableName());
    }

    public Table getDynamoTable(String tableName) {
        return new DynamoDB(this.getDynamoClient()).getTable(tableName);
    }

    public DynamoDb withBlueprintRow(String blueprintRow) {
        this.blueprintRow = blueprintRow;
        return this;
    }

    public DynamoDb withAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
        return this;
    }

    public DynamoDb withAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
        return this;
    }

    public DynamoDb withAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
        return this;
    }

    public DynamoDb withAwsEndpoint(String awsEndpoint) {
        this.awsEndpoint = awsEndpoint;
        return this;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " - " + this.getName() + " - " + this.getCollections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonDynamoDB getDynamoClient() {
        if (this.dynamoClient == null) {
            DynamoDb dynamoDb = this;
            synchronized (dynamoDb) {
                if (this.dynamoClient == null) {
                    this.dynamoClient = DynamoDb.buildDynamoClient(this.awsRegion, this.awsAccessKey, this.awsSecretKey, this.awsEndpoint);
                }
            }
        }
        return this.dynamoClient;
    }
}

