/*
 * Decompiled with CFR 0.152.
 */
package io.inversion.cosmosdb;

import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.PartitionKey;
import com.microsoft.azure.documentdb.RequestOptions;
import com.microsoft.azure.documentdb.ResourceResponse;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Collection;
import io.inversion.Db;
import io.inversion.Index;
import io.inversion.Property;
import io.inversion.Results;
import io.inversion.cosmosdb.CosmosSqlQuery;
import io.inversion.rql.Term;
import io.inversion.utils.JSNode;
import io.inversion.utils.Rows;
import io.inversion.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CosmosDb
extends Db<CosmosDb> {
    public static final String INDEX_TYPE_PARTITION_KEY = "PartitionKey";
    protected String uri = null;
    protected String db = "";
    protected String key = null;
    protected transient DocumentClient documentClient = null;
    boolean allowCrossPartitionQueries = false;

    public CosmosDb() {
        this.withType("cosmosdb");
    }

    public CosmosDb(String name) {
        this();
        this.withName(name);
    }

    public static DocumentClient buildDocumentClient(String uri, String key) {
        if (Utils.empty((Object[])new Object[]{uri}) || Utils.empty((Object[])new Object[]{key})) {
            String error = "";
            error = error + "Unable to connect to Cosmos DB because conf values for 'uri' or 'key' can not be found. ";
            error = error + "If this is a development environment, you should probably add these key/value pairs to a '.env' properties file in your working directory. ";
            error = error + "If this is a production deployment, you should probably set these as environment variables on your container.";
            error = error + "You could call CosmosDocumentDb.withUri() and CosmosDocumentDb.withKey() directly in your code but compiling these ";
            error = error + "values into your code is strongly discouraged as a poor security practice.";
            throw ApiException.new500InternalServerError((String)error, (Object[])new Object[0]);
        }
        DocumentClient client = new DocumentClient(uri, key, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        return client;
    }

    public Results doSelect(Collection collection, List<Term> columnMappedTerms) throws ApiException {
        Index partitionIdx = collection.getIndexByType(INDEX_TYPE_PARTITION_KEY);
        if (partitionIdx != null) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            block0: for (Property prop : partitionIdx.getProperties()) {
                String colName = prop.getColumnName();
                for (Term term2 : columnMappedTerms) {
                    if (!term2.hasChildLeafToken(new String[]{"eq"}) || !colName.equals(term2.getToken(0))) continue;
                    values.put(colName, term2.getToken(1));
                    continue block0;
                }
            }
            for (Term term3 : columnMappedTerms) {
                if (!term3.hasToken(new String[]{"_key"})) continue;
                String indexName = term3.getToken(0);
                Index idx = collection.getIndex(indexName);
                Rows.Row key = collection.decodeResourceKey(idx, term3.getToken(1));
                for (Property prop : partitionIdx.getProperties()) {
                    String colName = prop.getColumnName();
                    if (!key.containsKey((Object)colName)) continue;
                    values.put(colName, key.get(colName));
                }
            }
            if (values.size() == partitionIdx.size()) {
                columnMappedTerms.removeIf(term -> term.hasToken(new String[]{"eq"}) && partitionIdx.getName().equals(term.getToken(0)));
                String partitionKey = Collection.encodeResourceKey(values, (Index)partitionIdx);
                columnMappedTerms.add(Term.term(null, (String)"eq", (Object[])new Object[]{partitionIdx.getName(), partitionKey}));
            }
        }
        CosmosSqlQuery query = new CosmosSqlQuery(this, collection, columnMappedTerms);
        return query.doSelect();
    }

    public List<String> doUpsert(Collection table, List<Map<String, Object>> rows) throws ApiException {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map<String, Object> row : rows) {
            keys.add(this.upsertRow(table, row));
        }
        return keys;
    }

    void normalizePartitionKey(Collection collection, Map<String, Object> row) {
        Index partitionIdx = collection.getIndexByType(INDEX_TYPE_PARTITION_KEY);
        if (partitionIdx != null) {
            String partitionKey = Collection.encodeResourceKey(row, (Index)partitionIdx);
            if (partitionKey == null) {
                throw ApiException.new400BadRequest((String)"Unable to determine the CosmosDb partition key from the supplied fields", (Object[])new Object[0]);
            }
            row.put(partitionIdx.getName(), partitionKey);
        }
    }

    public String upsertRow(Collection collection, Map<String, Object> row) throws ApiException {
        try {
            Results existing;
            this.normalizePartitionKey(collection, row);
            JSNode doc = new JSNode(row);
            String id = doc.getString("id");
            if (id == null) {
                id = collection.encodeResourceKey(row);
                if (id == null) {
                    Index index = collection.getPrimaryIndex();
                    if (index == null) {
                        this.log.warn("INVERSION UNABLE TO DETERMINE PRIMARY INDEX");
                    } else {
                        this.log.info("INVERSION USING INDEX [{}]", (Object)index);
                        if (row == null) {
                            this.log.warn("BUT THE ROW IS NULL!");
                        } else if (row.size() == 0) {
                            this.log.warn("BUT THE ROW IS EMPTY!");
                        } else {
                            index.getColumnNames().forEach(colName -> {
                                if (Utils.empty((Object[])new Object[]{row.get(colName)})) {
                                    this.log.warn("INVERSION ROW MAP KEY [{}] is EMPTY", colName);
                                }
                            });
                        }
                    }
                    throw ApiException.new400BadRequest((String)"Your record does not contain the required key fields.", (Object[])new Object[0]);
                }
                doc.putFirst("id", (Object)id);
            }
            if ((existing = this.doSelect(collection, Utils.asList((Object[])new Object[]{Term.term(null, (String)"_key", (Object[])new Object[]{collection.getPrimaryIndex().getName(), id})}))).size() == 1) {
                Map existingRow = existing.getRow(0);
                for (String key : existingRow.keySet()) {
                    if (doc.containsKey((Object)key)) continue;
                    doc.put(key, existingRow.get(key));
                }
            }
            String cosmosCollectionUri = "/dbs/" + this.db + "/colls/" + collection.getTableName();
            String json = doc.toString();
            Document document = new Document(json);
            String debug = "CosmosDb: Insert " + json;
            Chain.debug((Object[])new Object[]{debug});
            ResourceResponse response = this.getDocumentClient().upsertDocument(cosmosCollectionUri, (Object)document, new RequestOptions(), true);
            int statusCode = response.getStatusCode();
            if (statusCode > 299) {
                throw ApiException.new400BadRequest((String)"Unexpected http status code returned from database: '{}'", (Object[])new Object[]{statusCode});
            }
            String returnedId = ((Document)response.getResource()).getId();
            if (!Utils.equal((Object)id, (Object)returnedId)) {
                throw ApiException.new500InternalServerError((String)"The supplied 'id' field does not match the returned 'id' field: '{}' vs. '{}'", (Object[])new Object[]{id, returnedId});
            }
            return id;
        }
        catch (Exception ex) {
            throw ApiException.new500InternalServerError((Throwable)ex);
        }
    }

    public void delete(Collection table, List<Map<String, Object>> indexValues) throws ApiException {
        for (Map<String, Object> row : indexValues) {
            this.deleteRow(table, row);
        }
    }

    protected void deleteRow(Collection collection, Map<String, Object> indexValues) throws ApiException {
        block3: {
            this.normalizePartitionKey(collection, indexValues);
            String id = collection.encodeResourceKey(indexValues);
            Object partitionKeyValue = indexValues.get(collection.getIndex(INDEX_TYPE_PARTITION_KEY).getProperty(0).getColumnName());
            String documentUri = "/dbs/" + this.db + "/colls/" + collection.getTableName() + "/docs/" + id;
            RequestOptions options = new RequestOptions();
            options.setPartitionKey(new PartitionKey(partitionKeyValue));
            try {
                Chain.debug((Object[])new Object[]{"CosmosDb: Delete documentUri=" + documentUri + "partitionKeyValue=" + partitionKeyValue});
                ResourceResponse response = this.getDocumentClient().deleteDocument(documentUri, options);
                int statusCode = response.getStatusCode();
                if (statusCode >= 400) {
                    throw ApiException.new500InternalServerError((String)"Unexpected http status code returned from database: {}", (Object[])new Object[]{statusCode});
                }
            }
            catch (DocumentClientException ex) {
                ex.printStackTrace();
                int statusCode = ex.getStatusCode();
                if (statusCode == 404) break block3;
                throw ApiException.new500InternalServerError((Throwable)ex);
            }
        }
    }

    protected String getCollectionUri(Collection table) {
        String documentUri = "/dbs/" + this.db + "/colls/" + table.getTableName();
        return documentUri;
    }

    public String getUri() {
        return this.uri;
    }

    public CosmosDb withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getDb() {
        return this.db;
    }

    public CosmosDb withDb(String db) {
        this.db = db;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public CosmosDb withKey(String key) {
        this.key = key;
        return this;
    }

    public boolean isAllowCrossPartitionQueries() {
        return this.allowCrossPartitionQueries;
    }

    public CosmosDb withAllowCrossPartitionQueries(boolean allowCrossPartitionQueries) {
        this.allowCrossPartitionQueries = allowCrossPartitionQueries;
        return this;
    }

    public synchronized CosmosDb withDocumentClient(DocumentClient documentClient) {
        this.documentClient = documentClient;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentClient getDocumentClient() {
        if (this.documentClient == null) {
            CosmosDb cosmosDb = this;
            synchronized (cosmosDb) {
                if (this.documentClient == null) {
                    this.documentClient = CosmosDb.buildDocumentClient(this.uri, this.key);
                }
            }
        }
        return this.documentClient;
    }
}

